/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.lang.reflect.Method;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.converter.CachingInjector;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceMethodTypeConverter
implements TypeConverter {
    private final CachingInjector injector;
    private final Method method;
    private final boolean useExchange;

    public InstanceMethodTypeConverter(CachingInjector injector, Method method) {
        this.injector = injector;
        this.method = method;
        this.useExchange = method.getParameterTypes().length == 2;
    }

    public String toString() {
        return "InstanceMethodTypeConverter: " + this.method;
    }

    @Override
    public <T> T convertTo(Class<T> type, Object value) {
        return this.convertTo(type, null, value);
    }

    @Override
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        Object instance = this.injector.newInstance();
        if (instance == null) {
            throw new RuntimeCamelException("Could not instantiate an instance of: " + type.getCanonicalName());
        }
        return (T)(this.useExchange ? ObjectHelper.invokeMethod(this.method, instance, value, exchange) : ObjectHelper.invokeMethod(this.method, instance, value));
    }

    @Override
    public <T> T mandatoryConvertTo(Class<T> type, Object value) {
        return this.convertTo(type, null, value);
    }

    @Override
    public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange, Object value) {
        return this.convertTo(type, null, value);
    }
}

