/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.management.InstrumentationProcessor;
import org.apache.camel.management.PerformanceCounter;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.InterceptStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationInterceptStrategy
implements InterceptStrategy {
    private Map<ProcessorDefinition, PerformanceCounter> registeredCounters;

    public InstrumentationInterceptStrategy(Map<ProcessorDefinition, PerformanceCounter> registeredCounters) {
        this.registeredCounters = registeredCounters;
    }

    @Override
    public Processor wrapProcessorInInterceptors(CamelContext context, ProcessorDefinition definition, Processor target, Processor nextTarget) throws Exception {
        if (target instanceof InstrumentationProcessor) {
            return target;
        }
        PerformanceCounter counter = this.registeredCounters.get(definition);
        if (counter != null) {
            InstrumentationProcessor wrapper = new InstrumentationProcessor(counter);
            wrapper.setProcessor(target);
            wrapper.setType(definition.getShortName());
            this.registeredCounters.remove(definition);
            return wrapper;
        }
        return target;
    }

    public String toString() {
        return "Instrument";
    }
}

