/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.processor.Enricher;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="enrich")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EnrichDefinition
extends OutputDefinition<EnrichDefinition> {
    @XmlAttribute(name="uri", required=true)
    private String resourceUri;
    @XmlAttribute(name="strategyRef", required=false)
    private String aggregationStrategyRef;
    @XmlTransient
    private AggregationStrategy aggregationStrategy;

    public EnrichDefinition() {
        this(null, null);
    }

    public EnrichDefinition(String resourceUri) {
        this(null, resourceUri);
    }

    public EnrichDefinition(AggregationStrategy aggregationStrategy, String resourceUri) {
        this.aggregationStrategy = aggregationStrategy;
        this.resourceUri = resourceUri;
    }

    public String toString() {
        return "Enrich[" + this.resourceUri + " " + this.aggregationStrategy + "]";
    }

    @Override
    public String getShortName() {
        return "enrich";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Endpoint endpoint = routeContext.resolveEndpoint(this.resourceUri);
        Enricher enricher = new Enricher(null, endpoint.createProducer());
        if (this.aggregationStrategyRef != null) {
            this.aggregationStrategy = routeContext.lookup(this.aggregationStrategyRef, AggregationStrategy.class);
        }
        if (this.aggregationStrategy == null) {
            enricher.setDefaultAggregationStrategy();
        } else {
            enricher.setAggregationStrategy(this.aggregationStrategy);
        }
        return enricher;
    }
}

