/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchProcessor
extends ServiceSupport
implements Processor,
Navigate<Processor> {
    public static final long DEFAULT_BATCH_TIMEOUT = 1000L;
    public static final int DEFAULT_BATCH_SIZE = 100;
    private static final Log LOG = LogFactory.getLog(BatchProcessor.class);
    private long batchTimeout = 1000L;
    private int batchSize = 100;
    private int outBatchSize;
    private boolean groupExchanges;
    private boolean batchConsumer;
    private final Processor processor;
    private final Collection<Exchange> collection;
    private ExceptionHandler exceptionHandler;
    private final BatchSender sender;

    public BatchProcessor(Processor processor, Collection<Exchange> collection) {
        ObjectHelper.notNull(processor, "processor");
        ObjectHelper.notNull(collection, "collection");
        this.processor = processor;
        this.collection = collection;
        this.sender = new BatchSender();
    }

    public String toString() {
        return "BatchProcessor[to: " + this.processor + "]";
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new LoggingExceptionHandler(this.getClass());
        }
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        if (batchSize <= 0) {
            LOG.debug((Object)"Disabling batch size, will only be triggered by timeout");
            this.batchSize = Integer.MAX_VALUE;
        } else {
            this.batchSize = batchSize;
        }
    }

    public int getOutBatchSize() {
        return this.outBatchSize;
    }

    public void setOutBatchSize(int outBatchSize) {
        this.outBatchSize = outBatchSize;
    }

    public long getBatchTimeout() {
        return this.batchTimeout;
    }

    public void setBatchTimeout(long batchTimeout) {
        this.batchTimeout = batchTimeout;
    }

    public boolean isGroupExchanges() {
        return this.groupExchanges;
    }

    public void setGroupExchanges(boolean groupExchanges) {
        this.groupExchanges = groupExchanges;
    }

    public boolean isBatchConsumer() {
        return this.batchConsumer;
    }

    public void setBatchConsumer(boolean batchConsumer) {
        this.batchConsumer = batchConsumer;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.processor);
        return answer;
    }

    @Override
    public boolean hasNext() {
        return this.processor != null;
    }

    private boolean isInBatchCompleted(int num) {
        return num >= this.batchSize;
    }

    private boolean isOutBatchCompleted() {
        if (this.outBatchSize == 0) {
            return true;
        }
        return this.collection.size() > 0 && this.collection.size() >= this.outBatchSize;
    }

    protected void processExchange(Exchange exchange) throws Exception {
        this.processor.process(exchange);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.processor);
        this.sender.start();
    }

    @Override
    protected void doStop() throws Exception {
        this.sender.cancel();
        ServiceHelper.stopServices(this.sender);
        ServiceHelper.stopServices(this.processor);
        this.collection.clear();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        int size;
        if (this.isBatchConsumer() && this.batchSize != (size = exchange.getProperty("CamelBatchSize", Integer.class).intValue())) {
            this.batchSize = size;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Using batch consumer completion, so setting batch size to: " + this.batchSize));
            }
        }
        this.sender.enqueueExchange(exchange);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BatchSender
    extends Thread {
        private Queue<Exchange> queue;
        private Lock queueLock;
        private boolean exchangeEnqueued;
        private Condition exchangeEnqueuedCondition;

        public BatchSender() {
            super(ExecutorServiceHelper.getThreadName("Batch Sender"));
            this.queueLock = new ReentrantLock();
            this.exchangeEnqueuedCondition = this.queueLock.newCondition();
            this.queue = new LinkedList<Exchange>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.queueLock.lock();
            try {
                do {
                    try {
                        if (!this.exchangeEnqueued) {
                            this.exchangeEnqueuedCondition.await(BatchProcessor.this.batchTimeout, TimeUnit.MILLISECONDS);
                        }
                        if (!this.exchangeEnqueued) {
                            this.drainQueueTo(BatchProcessor.this.collection, BatchProcessor.this.batchSize);
                        } else {
                            this.exchangeEnqueued = false;
                            while (BatchProcessor.this.isInBatchCompleted(this.queue.size())) {
                                this.drainQueueTo(BatchProcessor.this.collection, BatchProcessor.this.batchSize);
                            }
                            if (!BatchProcessor.this.isOutBatchCompleted()) continue;
                        }
                        this.queueLock.unlock();
                        try {
                            try {
                                this.sendExchanges();
                            }
                            catch (Exception e) {
                                BatchProcessor.this.getExceptionHandler().handleException(e);
                            }
                        }
                        finally {
                            this.queueLock.lock();
                        }
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                } while (BatchProcessor.this.isRunAllowed());
            }
            finally {
                this.queueLock.unlock();
            }
        }

        private void drainQueueTo(Collection<Exchange> collection, int batchSize) {
            Exchange e;
            for (int i = 0; i < batchSize && (e = this.queue.poll()) != null; ++i) {
                try {
                    collection.add(e);
                    continue;
                }
                catch (Exception t) {
                    e.setException(t);
                    continue;
                }
                catch (Throwable t) {
                    BatchProcessor.this.getExceptionHandler().handleException(t);
                }
            }
        }

        public void cancel() {
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enqueueExchange(Exchange exchange) {
            this.queueLock.lock();
            try {
                this.queue.add(exchange);
                this.exchangeEnqueued = true;
                this.exchangeEnqueuedCondition.signal();
            }
            finally {
                this.queueLock.unlock();
            }
        }

        private void sendExchanges() throws Exception {
            Exchange grouped = null;
            Iterator iter = BatchProcessor.this.collection.iterator();
            while (iter.hasNext()) {
                ArrayList<Exchange> list;
                Exchange exchange = (Exchange)iter.next();
                iter.remove();
                if (!BatchProcessor.this.groupExchanges) {
                    BatchProcessor.this.processExchange(exchange);
                    continue;
                }
                if (grouped == null) {
                    grouped = new DefaultExchange(exchange);
                }
                if ((list = grouped.getProperty("CamelGroupedExchange", List.class)) == null) {
                    list = new ArrayList<Exchange>();
                    grouped.setProperty("CamelGroupedExchange", list);
                }
                list.add(exchange);
            }
            if (grouped != null) {
                BatchProcessor.this.processExchange(grouped);
            }
        }
    }
}

