/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.processor.loadbalancer.QueueLoadBalancer;
import org.apache.camel.processor.loadbalancer.RoundRobinLoadBalancer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StickyLoadBalancer
extends QueueLoadBalancer {
    private Expression correlationExpression;
    private QueueLoadBalancer loadBalancer;
    private int numberOfHashGroups = 65536;
    private final Map<Object, Processor> stickyMap = new HashMap<Object, Processor>();

    public StickyLoadBalancer() {
        this.loadBalancer = new RoundRobinLoadBalancer();
    }

    public StickyLoadBalancer(Expression correlationExpression) {
        this(correlationExpression, new RoundRobinLoadBalancer());
    }

    public StickyLoadBalancer(Expression correlationExpression, QueueLoadBalancer loadBalancer) {
        this.correlationExpression = correlationExpression;
        this.loadBalancer = loadBalancer;
    }

    public Expression getCorrelationExpression() {
        return this.correlationExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized Processor chooseProcessor(List<Processor> processors, Exchange exchange) {
        Processor processor;
        Object value = this.correlationExpression.evaluate(exchange, Object.class);
        Object key = this.getStickyKey(value);
        Map<Object, Processor> map = this.stickyMap;
        synchronized (map) {
            processor = this.stickyMap.get(key);
            if (processor == null) {
                processor = this.loadBalancer.chooseProcessor(processors, exchange);
                this.stickyMap.put(key, processor);
            }
        }
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProcessor(Processor processor) {
        Map<Object, Processor> map = this.stickyMap;
        synchronized (map) {
            Iterator<Map.Entry<Object, Processor>> iter = this.stickyMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Object, Processor> entry = iter.next();
                if (!processor.equals(entry.getValue())) continue;
                iter.remove();
            }
        }
        super.removeProcessor(processor);
    }

    public int getNumberOfHashGroups() {
        return this.numberOfHashGroups;
    }

    public void setNumberOfHashGroups(int numberOfHashGroups) {
        this.numberOfHashGroups = numberOfHashGroups;
    }

    protected Object getStickyKey(Object value) {
        int hashCode = 37;
        if (value != null) {
            hashCode = value.hashCode();
        }
        if (this.numberOfHashGroups > 0) {
            hashCode %= this.numberOfHashGroups;
        }
        return hashCode;
    }

    public String toString() {
        return "StickyLoadBalancer";
    }
}

