/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.component.jms.ConsumerType;
import org.apache.camel.component.jms.DestinationEndpoint;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsConsumer;
import org.apache.camel.component.jms.JmsHeaderFilterStrategy;
import org.apache.camel.component.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.component.jms.JmsMessageType;
import org.apache.camel.component.jms.JmsPollingConsumer;
import org.apache.camel.component.jms.JmsProducer;
import org.apache.camel.component.jms.JmsProviderMetadata;
import org.apache.camel.component.jms.JmsQueueEndpoint;
import org.apache.camel.component.jms.JmsTemporaryQueueEndpoint;
import org.apache.camel.component.jms.JmsTemporaryTopicEndpoint;
import org.apache.camel.component.jms.requestor.Requestor;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware {
    private HeaderFilterStrategy headerFilterStrategy;
    private boolean pubSubDomain;
    private JmsBinding binding;
    private String destinationName;
    private Destination destination;
    private String selector;
    private JmsConfiguration configuration;
    private Requestor requestor;

    public JmsEndpoint() {
        this(null, null);
    }

    public JmsEndpoint(Topic destination) throws JMSException {
        this("jms:topic:" + destination.getTopicName(), null);
        this.destination = destination;
    }

    public JmsEndpoint(String uri, JmsComponent component, String destinationName, boolean pubSubDomain, JmsConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
        this.destinationName = destinationName;
        this.pubSubDomain = pubSubDomain;
    }

    public JmsEndpoint(String endpointUri, JmsBinding binding, JmsConfiguration configuration, String destinationName, boolean pubSubDomain) {
        super(endpointUri);
        this.binding = binding;
        this.configuration = configuration;
        this.destinationName = destinationName;
        this.pubSubDomain = pubSubDomain;
    }

    public JmsEndpoint(String endpointUri, String destinationName, boolean pubSubDomain) {
        this(endpointUri, null, new JmsConfiguration(), destinationName, pubSubDomain);
        this.binding = new JmsBinding(this);
    }

    public JmsEndpoint(String endpointUri, String destinationName) {
        this(endpointUri, destinationName, true);
    }

    public static JmsEndpoint newInstance(Destination destination, JmsComponent component) throws JMSException {
        JmsEndpoint answer = JmsEndpoint.newInstance(destination);
        JmsConfiguration newConfiguration = component.getConfiguration().copy();
        answer.setConfiguration(newConfiguration);
        answer.setCamelContext(component.getCamelContext());
        return answer;
    }

    public static JmsEndpoint newInstance(Destination destination) throws JMSException {
        if (destination instanceof TemporaryQueue) {
            return new JmsTemporaryQueueEndpoint((TemporaryQueue)destination);
        }
        if (destination instanceof TemporaryTopic) {
            return new JmsTemporaryTopicEndpoint((TemporaryTopic)destination);
        }
        if (destination instanceof Queue) {
            return new JmsQueueEndpoint((Queue)destination);
        }
        return new JmsEndpoint((Topic)destination);
    }

    public JmsProducer createProducer() throws Exception {
        return new JmsProducer(this);
    }

    public JmsProducer createProducer(JmsOperations template) throws Exception {
        JmsProducer answer = this.createProducer();
        if (template instanceof JmsTemplate) {
            JmsTemplate jmsTemplate = (JmsTemplate)template;
            jmsTemplate.setPubSubDomain(this.pubSubDomain);
            if (this.destinationName != null) {
                jmsTemplate.setDefaultDestinationName(this.destinationName);
            } else if (this.destination != null) {
                jmsTemplate.setDefaultDestination(this.destination);
            }
        }
        answer.setInOnlyTemplate(template);
        return answer;
    }

    public JmsConsumer createConsumer(Processor processor) throws Exception {
        AbstractMessageListenerContainer listenerContainer = this.configuration.createMessageListenerContainer(this);
        return this.createConsumer(processor, listenerContainer);
    }

    public JmsConsumer createConsumer(Processor processor, AbstractMessageListenerContainer listenerContainer) throws Exception {
        if (this.destinationName != null) {
            listenerContainer.setDestinationName(this.destinationName);
        } else if (this.destination != null) {
            listenerContainer.setDestination(this.destination);
        } else {
            DestinationResolver resolver = this.getDestinationResolver();
            if (resolver != null) {
                listenerContainer.setDestinationResolver(resolver);
            } else {
                throw new IllegalArgumentException("Neither destination, destinationName or destinationResolver are specified on this endpoint!");
            }
        }
        listenerContainer.setPubSubDomain(this.pubSubDomain);
        return new JmsConsumer(this, processor, listenerContainer);
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        JmsOperations template = this.createInOnlyTemplate();
        return new JmsPollingConsumer(this, template);
    }

    public Exchange createExchange(ExchangePattern pattern) {
        DefaultExchange exchange = new DefaultExchange((Endpoint)this, pattern);
        exchange.setProperty("CamelBinding", (Object)this.getBinding());
        return exchange;
    }

    public Exchange createExchange(javax.jms.Message message) {
        Exchange exchange = this.createExchange(this.getExchangePattern());
        exchange.setIn((Message)new JmsMessage(message, this.getBinding()));
        return exchange;
    }

    public JmsOperations createInOnlyTemplate() {
        return this.configuration.createInOnlyTemplate(this, this.pubSubDomain, this.destinationName);
    }

    public JmsOperations createInOutTemplate() {
        return this.configuration.createInOutTemplate(this, this.pubSubDomain, this.destinationName, this.configuration.getRequestTimeout());
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new JmsHeaderFilterStrategy();
        }
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public JmsBinding getBinding() {
        if (this.binding == null) {
            this.binding = new JmsBinding(this);
        }
        return this.binding;
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public JmsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JmsConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public boolean isSingleton() {
        return false;
    }

    public synchronized Requestor getRequestor() throws Exception {
        if (this.requestor == null) {
            this.requestor = new Requestor(this.getConfiguration(), this.getScheduledExecutorService());
            this.requestor.start();
        }
        return this.requestor;
    }

    public void setRequestor(Requestor requestor) {
        this.requestor = requestor;
    }

    public boolean isPubSubDomain() {
        return this.pubSubDomain;
    }

    public Class<? extends TemporaryQueue> getTemporaryQueueType() {
        JmsProviderMetadata metadata = this.getProviderMetadata();
        JmsOperations template = this.getMetadataJmsOperations();
        return metadata.getTemporaryQueueType(template);
    }

    public Class<? extends TemporaryTopic> getTemporaryTopicType() {
        JmsOperations template = this.getMetadataJmsOperations();
        JmsProviderMetadata metadata = this.getProviderMetadata();
        return metadata.getTemporaryTopicType(template);
    }

    protected JmsProviderMetadata getProviderMetadata() {
        JmsConfiguration conf = this.getConfiguration();
        JmsProviderMetadata metadata = conf.getProviderMetadata();
        return metadata;
    }

    protected JmsOperations getMetadataJmsOperations() {
        JmsOperations template = this.getConfiguration().getMetadataJmsOperations(this);
        if (template == null) {
            throw new IllegalArgumentException("No Metadata JmsTemplate supplied!");
        }
        return template;
    }

    public void checkValidTemplate(JmsTemplate template) {
        if (template.getDestinationResolver() == null && this instanceof DestinationEndpoint) {
            DestinationEndpoint destinationEndpoint = (DestinationEndpoint)((Object)this);
            template.setDestinationResolver(JmsConfiguration.createDestinationResolver(destinationEndpoint));
        }
    }

    public int getAcknowledgementMode() {
        return this.getConfiguration().getAcknowledgementMode();
    }

    public String getAcknowledgementModeName() {
        return this.getConfiguration().getAcknowledgementModeName();
    }

    public int getCacheLevel() {
        return this.getConfiguration().getCacheLevel();
    }

    public String getCacheLevelName() {
        return this.getConfiguration().getCacheLevelName();
    }

    public String getClientId() {
        return this.getConfiguration().getClientId();
    }

    public int getConcurrentConsumers() {
        return this.getConfiguration().getConcurrentConsumers();
    }

    public ConnectionFactory getConnectionFactory() {
        return this.getConfiguration().getConnectionFactory();
    }

    public ConsumerType getConsumerType() {
        return this.getConfiguration().getConsumerType();
    }

    public DestinationResolver getDestinationResolver() {
        return this.getConfiguration().getDestinationResolver();
    }

    public String getDurableSubscriptionName() {
        return this.getConfiguration().getDurableSubscriptionName();
    }

    public ExceptionListener getExceptionListener() {
        return this.getConfiguration().getExceptionListener();
    }

    public int getIdleTaskExecutionLimit() {
        return this.getConfiguration().getIdleTaskExecutionLimit();
    }

    public JmsOperations getJmsOperations() {
        return this.getConfiguration().getJmsOperations();
    }

    public ConnectionFactory getListenerConnectionFactory() {
        return this.getConfiguration().getListenerConnectionFactory();
    }

    public int getMaxConcurrentConsumers() {
        return this.getConfiguration().getMaxConcurrentConsumers();
    }

    public int getMaxMessagesPerTask() {
        return this.getConfiguration().getMaxMessagesPerTask();
    }

    public MessageConverter getMessageConverter() {
        return this.getConfiguration().getMessageConverter();
    }

    public JmsOperations getMetadataJmsOperations(JmsEndpoint endpoint) {
        return this.getConfiguration().getMetadataJmsOperations(endpoint);
    }

    public int getPriority() {
        return this.getConfiguration().getPriority();
    }

    public long getReceiveTimeout() {
        return this.getConfiguration().getReceiveTimeout();
    }

    public long getRecoveryInterval() {
        return this.getConfiguration().getRecoveryInterval();
    }

    public String getReplyTo() {
        return this.getConfiguration().getReplyTo();
    }

    public String getReplyToDestinationSelectorName() {
        return this.getConfiguration().getReplyToDestinationSelectorName();
    }

    public String getReplyToTempDestinationAffinity() {
        return this.getConfiguration().getReplyToTempDestinationAffinity();
    }

    public long getRequestMapPurgePollTimeMillis() {
        return this.getConfiguration().getRequestMapPurgePollTimeMillis();
    }

    public long getRequestTimeout() {
        return this.getConfiguration().getRequestTimeout();
    }

    public TaskExecutor getTaskExecutor() {
        return this.getConfiguration().getTaskExecutor();
    }

    public ConnectionFactory getTemplateConnectionFactory() {
        return this.getConfiguration().getTemplateConnectionFactory();
    }

    public long getTimeToLive() {
        return this.getConfiguration().getTimeToLive();
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.getConfiguration().getTransactionManager();
    }

    public String getTransactionName() {
        return this.getConfiguration().getTransactionName();
    }

    public int getTransactionTimeout() {
        return this.getConfiguration().getTransactionTimeout();
    }

    public boolean isAcceptMessagesWhileStopping() {
        return this.getConfiguration().isAcceptMessagesWhileStopping();
    }

    public boolean isAlwaysCopyMessage() {
        return this.getConfiguration().isAlwaysCopyMessage();
    }

    public boolean isAutoStartup() {
        return this.getConfiguration().isAutoStartup();
    }

    public boolean isDeliveryPersistent() {
        return this.getConfiguration().isDeliveryPersistent();
    }

    public boolean isDisableReplyTo() {
        return this.getConfiguration().isDisableReplyTo();
    }

    public boolean isEagerLoadingOfProperties() {
        return this.getConfiguration().isEagerLoadingOfProperties();
    }

    public boolean isExplicitQosEnabled() {
        return this.getConfiguration().isExplicitQosEnabled();
    }

    public boolean isExposeListenerSession() {
        return this.getConfiguration().isExposeListenerSession();
    }

    public boolean isMessageIdEnabled() {
        return this.getConfiguration().isMessageIdEnabled();
    }

    public boolean isMessageTimestampEnabled() {
        return this.getConfiguration().isMessageTimestampEnabled();
    }

    public boolean isPreserveMessageQos() {
        return this.getConfiguration().isPreserveMessageQos();
    }

    public boolean isPubSubNoLocal() {
        return this.getConfiguration().isPubSubNoLocal();
    }

    public boolean isReplyToDeliveryPersistent() {
        return this.getConfiguration().isReplyToDeliveryPersistent();
    }

    public boolean isSubscriptionDurable() {
        return this.getConfiguration().isSubscriptionDurable();
    }

    public boolean isTransacted() {
        return this.getConfiguration().isTransacted();
    }

    public boolean isTransactedInOut() {
        return this.getConfiguration().isTransactedInOut();
    }

    public boolean isUseMessageIDAsCorrelationID() {
        return this.getConfiguration().isUseMessageIDAsCorrelationID();
    }

    public boolean isUseVersion102() {
        return this.getConfiguration().isUseVersion102();
    }

    public void setAcceptMessagesWhileStopping(boolean acceptMessagesWhileStopping) {
        this.getConfiguration().setAcceptMessagesWhileStopping(acceptMessagesWhileStopping);
    }

    public void setAcknowledgementMode(int consumerAcknowledgementMode) {
        this.getConfiguration().setAcknowledgementMode(consumerAcknowledgementMode);
    }

    public void setAcknowledgementModeName(String consumerAcknowledgementMode) {
        this.getConfiguration().setAcknowledgementModeName(consumerAcknowledgementMode);
    }

    public void setAlwaysCopyMessage(boolean alwaysCopyMessage) {
        this.getConfiguration().setAlwaysCopyMessage(alwaysCopyMessage);
    }

    public void setAutoStartup(boolean autoStartup) {
        this.getConfiguration().setAutoStartup(autoStartup);
    }

    public void setCacheLevel(int cacheLevel) {
        this.getConfiguration().setCacheLevel(cacheLevel);
    }

    public void setCacheLevelName(String cacheName) {
        this.getConfiguration().setCacheLevelName(cacheName);
    }

    public void setClientId(String consumerClientId) {
        this.getConfiguration().setClientId(consumerClientId);
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.getConfiguration().setConcurrentConsumers(concurrentConsumers);
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.getConfiguration().setConnectionFactory(connectionFactory);
    }

    public void setConsumerType(ConsumerType consumerType) {
        this.getConfiguration().setConsumerType(consumerType);
    }

    public void setDeliveryPersistent(boolean deliveryPersistent) {
        this.getConfiguration().setDeliveryPersistent(deliveryPersistent);
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.getConfiguration().setDestinationResolver(destinationResolver);
    }

    public void setDisableReplyTo(boolean disableReplyTo) {
        this.getConfiguration().setDisableReplyTo(disableReplyTo);
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.getConfiguration().setDurableSubscriptionName(durableSubscriptionName);
    }

    public void setEagerLoadingOfProperties(boolean eagerLoadingOfProperties) {
        this.getConfiguration().setEagerLoadingOfProperties(eagerLoadingOfProperties);
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.getConfiguration().setExceptionListener(exceptionListener);
    }

    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.getConfiguration().setExplicitQosEnabled(explicitQosEnabled);
    }

    public void setExposeListenerSession(boolean exposeListenerSession) {
        this.getConfiguration().setExposeListenerSession(exposeListenerSession);
    }

    public void setIdleTaskExecutionLimit(int idleTaskExecutionLimit) {
        this.getConfiguration().setIdleTaskExecutionLimit(idleTaskExecutionLimit);
    }

    public void setJmsOperations(JmsOperations jmsOperations) {
        this.getConfiguration().setJmsOperations(jmsOperations);
    }

    public void setListenerConnectionFactory(ConnectionFactory listenerConnectionFactory) {
        this.getConfiguration().setListenerConnectionFactory(listenerConnectionFactory);
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.getConfiguration().setMaxConcurrentConsumers(maxConcurrentConsumers);
    }

    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        this.getConfiguration().setMaxMessagesPerTask(maxMessagesPerTask);
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.getConfiguration().setMessageConverter(messageConverter);
    }

    public void setMessageIdEnabled(boolean messageIdEnabled) {
        this.getConfiguration().setMessageIdEnabled(messageIdEnabled);
    }

    public void setMessageTimestampEnabled(boolean messageTimestampEnabled) {
        this.getConfiguration().setMessageTimestampEnabled(messageTimestampEnabled);
    }

    public void setMetadataJmsOperations(JmsOperations metadataJmsOperations) {
        this.getConfiguration().setMetadataJmsOperations(metadataJmsOperations);
    }

    public void setPreserveMessageQos(boolean preserveMessageQos) {
        this.getConfiguration().setPreserveMessageQos(preserveMessageQos);
    }

    public void setPriority(int priority) {
        this.getConfiguration().setPriority(priority);
    }

    public void setProviderMetadata(JmsProviderMetadata providerMetadata) {
        this.getConfiguration().setProviderMetadata(providerMetadata);
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.getConfiguration().setPubSubNoLocal(pubSubNoLocal);
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.getConfiguration().setReceiveTimeout(receiveTimeout);
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.getConfiguration().setRecoveryInterval(recoveryInterval);
    }

    public void setReplyTo(String replyToDestination) {
        this.getConfiguration().setReplyTo(replyToDestination);
    }

    public void setReplyToDeliveryPersistent(boolean replyToDeliveryPersistent) {
        this.getConfiguration().setReplyToDeliveryPersistent(replyToDeliveryPersistent);
    }

    public void setReplyToDestinationSelectorName(String replyToDestinationSelectorName) {
        this.getConfiguration().setReplyToDestinationSelectorName(replyToDestinationSelectorName);
    }

    public void setReplyToTempDestinationAffinity(String replyToTempDestinationAffinity) {
        this.getConfiguration().setReplyToTempDestinationAffinity(replyToTempDestinationAffinity);
    }

    public void setRequestMapPurgePollTimeMillis(long requestMapPurgePollTimeMillis) {
        this.getConfiguration().setRequestMapPurgePollTimeMillis(requestMapPurgePollTimeMillis);
    }

    public void setRequestTimeout(long requestTimeout) {
        this.getConfiguration().setRequestTimeout(requestTimeout);
    }

    public void setSubscriptionDurable(boolean subscriptionDurable) {
        this.getConfiguration().setSubscriptionDurable(subscriptionDurable);
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.getConfiguration().setTaskExecutor(taskExecutor);
    }

    public void setTemplateConnectionFactory(ConnectionFactory templateConnectionFactory) {
        this.getConfiguration().setTemplateConnectionFactory(templateConnectionFactory);
    }

    public void setTimeToLive(long timeToLive) {
        this.getConfiguration().setTimeToLive(timeToLive);
    }

    public void setTransacted(boolean consumerTransacted) {
        this.getConfiguration().setTransacted(consumerTransacted);
    }

    public void setTransactedInOut(boolean transactedInOut) {
        this.getConfiguration().setTransactedInOut(transactedInOut);
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.getConfiguration().setTransactionManager(transactionManager);
    }

    public void setTransactionName(String transactionName) {
        this.getConfiguration().setTransactionName(transactionName);
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.getConfiguration().setTransactionTimeout(transactionTimeout);
    }

    public void setUseMessageIDAsCorrelationID(boolean useMessageIDAsCorrelationID) {
        this.getConfiguration().setUseMessageIDAsCorrelationID(useMessageIDAsCorrelationID);
    }

    public void setUseVersion102(boolean useVersion102) {
        this.getConfiguration().setUseVersion102(useVersion102);
    }

    public JmsMessageType getJmsMessageType() {
        return this.getConfiguration().getJmsMessageType();
    }

    public void setJmsMessageType(JmsMessageType jmsMessageType) {
        this.getConfiguration().setJmsMessageType(jmsMessageType);
    }

    public JmsKeyFormatStrategy getJmsKeyFormatStrategy() {
        return this.getConfiguration().getJmsKeyFormatStrategy();
    }

    public void setJmsKeyFormatStrategy(JmsKeyFormatStrategy jmsHeaderStrategy) {
        this.getConfiguration().setJmsKeyFormatStrategy(jmsHeaderStrategy);
    }

    public boolean isTransferExchange() {
        return this.getConfiguration().isTransferExchange();
    }

    public void setTransferExchange(boolean transferExchange) {
        this.getConfiguration().setTransferExchange(transferExchange);
    }

    public boolean isTransferException() {
        return this.getConfiguration().isTransferException();
    }

    public void setTransferException(boolean transferException) {
        this.getConfiguration().setTransferException(transferException);
    }

    protected String createEndpointUri() {
        String scheme = "jms";
        Component owner = this.getComponent();
        if (owner != null) {
            // empty if block
        }
        if (this.destination != null) {
            return scheme + ":" + this.destination;
        }
        if (this.destinationName != null) {
            return scheme + ":" + this.destinationName;
        }
        DestinationResolver resolver = this.getDestinationResolver();
        if (resolver != null) {
            return scheme + ":" + resolver;
        }
        return super.createEndpointUri();
    }
}

