/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.extensions.cluster;

import javax.management.ObjectName;
import org.ow2.jonas.lib.management.extensions.base.BaseManagement;
import org.ow2.jonas.lib.management.extensions.base.JonasManagementRepr;
import org.ow2.jonas.lib.management.extensions.domain.DomainManagement;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.management.extensions.cluster.api.ICluster;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ClusterManagement
extends BaseManagement
implements ICluster {
    protected static Log logger = LogFactory.getLog(ClusterManagement.class);
    private static ClusterManagement unique = null;

    public static ICluster getInstance() {
        if (unique == null) {
            unique = new ClusterManagement();
        }
        return unique;
    }

    public void addServerToCluster(String clusterName, String serverName, String clusterDaemon, String serverURL) {
        String clusterType = "LogicalCluster";
        try {
            ObjectName on = JonasObjectName.cluster((String)this.getDomainName(), (String)clusterName, (String)clusterType);
            String[] signature = new String[]{"java.lang.String", "[Ljava.lang.String;", "java.lang.String", "java.lang.String", "java.lang.String"};
            Object[] params = new Object[5];
            String[] urls = new String[]{serverURL};
            String currentServerName = null;
            Object username = null;
            if (serverName != null) {
                params[0] = serverName;
                params[1] = urls;
                params[2] = clusterDaemon;
                params[3] = username;
                params[4] = null;
                JonasManagementRepr.invoke(on, "addServer", params, signature, currentServerName);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error in adding server to cluster   ", new Object[]{e});
            return;
        }
    }

    public void startAllServers(String clusterName) {
        DomainManagement dm = new DomainManagement();
        String domainName = this.getDomainName();
        String clusterType = dm.getClusterType(clusterName);
        String serverName = this.getServerName();
        ObjectName on = null;
        try {
            on = JonasObjectName.cluster((String)domainName, (String)clusterName, (String)clusterType);
        }
        catch (Exception e) {
            logger.error((Object)"Error in startAllServers", new Object[]{e});
            return;
        }
        String opName = "start";
        Object[] standby = new Object[]{false};
        String[] signature = new String[]{Boolean.class.toString()};
        JonasManagementRepr.invoke(on, opName, standby, signature, serverName);
    }

    public void stopAllServers(String clusterName) {
        DomainManagement dm = new DomainManagement();
        String domainName = this.getDomainName();
        String clusterType = dm.getClusterType(clusterName);
        String serverName = this.getServerName();
        ObjectName on = null;
        try {
            on = JonasObjectName.cluster((String)domainName, (String)clusterName, (String)clusterType);
        }
        catch (Exception e) {
            logger.error((Object)"Error in stopAllServers", new Object[]{e});
            return;
        }
        String opName = "stopit";
        JonasManagementRepr.invoke(on, opName, null, null, serverName);
    }

    public String getMcastAddr(String clusterName) {
        DomainManagement dm = new DomainManagement();
        String domainName = this.getDomainName();
        String clusterType = dm.getClusterType(clusterName);
        ObjectName on = null;
        try {
            on = JonasObjectName.cluster((String)domainName, (String)clusterName, (String)clusterType);
        }
        catch (Exception e) {
            logger.error((Object)"Error in getMcastAddr", new Object[]{e});
            return null;
        }
        return this.getStringAttribute(on, "McastAddr");
    }

    public int getMcastPort(String clusterName) {
        String domainName = this.getDomainName();
        DomainManagement dm = new DomainManagement();
        String clusterType = dm.getClusterType(clusterName);
        ObjectName on = null;
        try {
            on = JonasObjectName.cluster((String)domainName, (String)clusterName, (String)clusterType);
        }
        catch (Exception e) {
            logger.error((Object)"Error in getMcastPort", new Object[]{e});
            return -1;
        }
        return this.getIntegerAttribute(on, "McastPort");
    }

    public String getProtocol(String clusterName) {
        String domainName = this.getDomainName();
        ObjectName on = null;
        try {
            on = JonasObjectName.cluster((String)domainName, (String)clusterName, (String)"CmiCluster");
        }
        catch (Exception e) {
            logger.error((Object)"Error in getProtocol", new Object[]{e});
            return null;
        }
        return this.getStringAttribute(on, "Protocol");
    }

    public int getDelayToRefresh(String clusterName) {
        String domainName = this.getDomainName();
        ObjectName on = null;
        try {
            on = JonasObjectName.cluster((String)domainName, (String)clusterName, (String)"CmiCluster");
        }
        catch (Exception e) {
            logger.error((Object)"Error in getDelayToRefresh", new Object[]{e});
            return -1;
        }
        return this.getIntegerAttribute(on, "DelayToRefresh");
    }
}

