/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.registry.osgi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.spi.Registry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiRegistry
implements Registry {
    private Log logger = LogFactory.getLog(this.getClass());
    private final BundleContext bundleContext;

    public OSGiRegistry(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Object lookup(String name) {
        return this.lookup(name, null);
    }

    public <T> T lookup(String name, Class<T> clazz) {
        return this.lookupByType(clazz).get(name);
    }

    public <T> Map<String, T> lookupByType(Class<T> clazz) {
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences(clazz == null ? null : clazz.getName(), null);
            if (refs != null && refs.length >= 0) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                for (ServiceReference ref : refs) {
                    String serviceName = (String)ref.getProperty("name");
                    result.put(serviceName, this.bundleContext.getService(ref));
                }
                return result;
            }
        }
        catch (InvalidSyntaxException e) {
            this.logger.error((Object)"Failed listing OSGi services", new Object[]{e});
        }
        return Collections.EMPTY_MAP;
    }
}

