/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.remote;

import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.remote.SimpleFunctionCall;

public class SequencingFunctionCall {

    public static class GetNextValue
    extends SimpleFunctionCall {
        protected Class cls;

        public GetNextValue(Class cls) {
            this.cls = cls;
        }

        protected Object execute(AbstractSession session) {
            return session.getSequencing().getNextValue(this.cls);
        }
    }

    public static class ShouldOverrideExistingValue
    extends SimpleFunctionCall {
        protected Class cls;
        protected Object existingValue;

        public ShouldOverrideExistingValue(Class cls, Object existingValue) {
            this.cls = cls;
            this.existingValue = existingValue;
        }

        protected Object execute(AbstractSession session) {
            return new Boolean(session.getSequencing().shouldOverrideExistingValue(this.cls, this.existingValue));
        }
    }

    public static class ShouldAcquireValueAfterInsert
    extends SimpleFunctionCall {
        protected Class cls;

        public ShouldAcquireValueAfterInsert(Class cls) {
            this.cls = cls;
        }

        protected Object execute(AbstractSession session) {
            return new Boolean(session.getSequencing().shouldAcquireValueAfterInsert(this.cls));
        }
    }

    public static class WhenShouldAcquireValueForAll
    extends SimpleFunctionCall {
        protected Object execute(AbstractSession session) {
            return new Integer(session.getSequencing().whenShouldAcquireValueForAll());
        }
    }

    public static class DoesExist
    extends SimpleFunctionCall {
        protected Object execute(AbstractSession session) {
            return new Boolean(session.getSequencing() != null);
        }
    }
}

