/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import javax.xml.namespace.QName;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.wsdl11.WSDLServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLServiceFactoryBean
extends ReflectionServiceFactoryBean {
    private QName serviceName;
    private QName endpointName;

    public Service create() {
        WSDLServiceFactory factory = new WSDLServiceFactory(this.getBus(), this.getWsdlURL(), this.getServiceQName());
        this.setService(factory.create());
        this.initializeDefaultInterceptors();
        this.updateEndpointInfors();
        this.createEndpoints();
        return this.getService();
    }

    private void updateEndpointInfors() {
        Service service = this.getService();
        for (ServiceInfo inf : service.getServiceInfos()) {
            for (EndpointInfo ei : inf.getEndpoints()) {
                ei.setAddress("local://" + ei.getService().getName().toString() + "/" + ei.getName().getLocalPart());
            }
        }
    }

    protected void checkServiceClassAnnotations(Class<?> sc) {
    }

    public void setServiceName(QName name) {
        this.serviceName = name;
    }

    public String getServiceName() {
        return this.serviceName.toString();
    }

    public QName getServiceQName() {
        return this.serviceName;
    }

    public QName getEndpointName() {
        if (this.endpointName == null) {
            this.endpointName = (QName)this.getService().getEndpoints().keySet().iterator().next();
        }
        return this.endpointName;
    }

    public void setEndpointName(QName name) {
        this.endpointName = name;
    }
}

