/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.interceptors;

import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageOutInterceptor<T extends Message>
extends AbstractPhaseInterceptor<T> {
    public AbstractMessageOutInterceptor(String phase) {
        super(phase);
    }

    protected boolean isRequestor(Message message) {
        return Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.client"));
    }

    protected abstract Logger getLogger();

    protected Element createElement(QName elName, List<Element> childEl) {
        Document doc = DOMUtils.createDocument();
        String prefix = elName.getPrefix();
        StringBuilder tagName = new StringBuilder();
        if (!"".equals(prefix)) {
            tagName.append(prefix);
            tagName.append(":");
        }
        tagName.append(elName.getLocalPart());
        Element el = doc.createElementNS(elName.getNamespaceURI(), tagName.toString());
        if (!"".equals(elName.getPrefix())) {
            StringBuilder attrName = new StringBuilder("xmlns");
            attrName.append(':');
            attrName.append(elName.getPrefix());
            el.setAttribute(attrName.toString(), elName.getNamespaceURI());
        }
        for (Element part : childEl) {
            Node adoptedNode = doc.adoptNode(part);
            el.appendChild(adoptedNode);
        }
        return el;
    }
}

