/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.lang.reflect.Method;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.jaxrs.CxfRsBinding;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfRsProducer
extends DefaultProducer {
    private static final Log LOG = LogFactory.getLog(CxfRsProducer.class);
    JAXRSClientFactoryBean cfb;

    public CxfRsProducer(CxfRsEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.cfb = endpoint.createJAXRSClientFactoryBean();
    }

    public void process(Exchange exchange) throws Exception {
        Message inMessage;
        Boolean httpClientAPI;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Process exchange: " + exchange));
        }
        if ((httpClientAPI = (Boolean)(inMessage = exchange.getIn()).getHeader("CamelCxfRsUsingHttpAPI", Boolean.class)) != null && httpClientAPI.booleanValue()) {
            this.invokeHttpClient(exchange);
        } else {
            this.invokeProxyClient(exchange);
        }
    }

    protected void invokeHttpClient(Exchange exchange) throws Exception {
        Message inMessage = exchange.getIn();
        WebClient client = this.cfb.createWebClient();
        String httpMethod = (String)inMessage.getHeader("CamelHttpMethod", String.class);
        Class responseClass = (Class)inMessage.getHeader("CamelCxfRsResponseClass", Class.class);
        String path = (String)inMessage.getHeader("CamelHttpPath", String.class);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("HTTP method = " + httpMethod));
            LOG.trace((Object)("path = " + path));
            LOG.trace((Object)("responseClass = " + responseClass));
        }
        if (path != null) {
            client.path((Object)path);
        }
        CxfRsBinding binding = ((CxfRsEndpoint)this.getEndpoint()).getBinding();
        Object body = null;
        if (!"GET".equals(httpMethod)) {
            body = binding.bindCamelMessageBodyToRequestBody(inMessage, exchange);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Request body = " + body));
            }
        }
        client.headers(binding.bindCamelHeadersToRequestHeaders(inMessage.getHeaders(), exchange));
        Object response = null;
        response = responseClass == null || Response.class.equals((Object)responseClass) ? client.invoke(httpMethod, body) : client.invoke(httpMethod, body, responseClass);
        if (exchange.getPattern().isOutCapable()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Response body = " + response));
            }
            exchange.getOut().setBody(binding.bindResponseToCamelBody(response, exchange));
            exchange.getOut().setHeaders(binding.bindResponseHeadersToCamelHeaders(response, exchange));
        }
    }

    protected void invokeProxyClient(Exchange exchange) throws Exception {
        Message inMessage = exchange.getIn();
        Object[] varValues = (Object[])inMessage.getHeader("CamelCxfRsVarValues", Object[].class);
        String methodName = (String)inMessage.getHeader("operationName", String.class);
        Client target = null;
        target = varValues == null ? this.cfb.create() : this.cfb.createWithValues(varValues);
        JAXRSServiceFactoryBean sfb = this.cfb.getServiceFactory();
        sfb.getResourceClasses();
        Object[] parameters = (Object[])inMessage.getBody(Object[].class);
        Method method = this.findRightMethod(sfb.getResourceClasses(), methodName, this.getParameterTypes(parameters));
        Object response = method.invoke((Object)target, parameters);
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().setBody(response);
        }
    }

    private Method findRightMethod(List<Class> resourceClasses, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        Method answer = null;
        for (Class clazz : resourceClasses) {
            try {
                answer = clazz.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException ex) {
            }
            catch (SecurityException ex) {
                // empty catch block
            }
            if (answer == null) continue;
            return answer;
        }
        throw new NoSuchMethodException("Can find the method " + methodName + "withe these parameter " + this.arrayToString(parameterTypes));
    }

    private Class<?>[] getParameterTypes(Object[] objects) {
        Class[] answer = new Class[objects.length];
        int i = 0;
        for (Object obj : objects) {
            answer[i] = obj.getClass();
            ++i;
        }
        return answer;
    }

    private String arrayToString(Object[] array) {
        StringBuffer buffer = new StringBuffer("[");
        for (Object obj : array) {
            if (buffer.length() > 2) {
                buffer.append(",");
            }
            buffer.append(obj.toString());
        }
        buffer.append("]");
        return buffer.toString();
    }
}

