/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.spi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.ow2.carol.jndi.spi.MultiContext;
import org.ow2.carol.util.configuration.CarolDefaultValues;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.carol.util.configuration.Protocol;
import org.ow2.carol.util.configuration.TraceCarol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiOrbInitialContextFactory
implements InitialContextFactory {
    @Override
    public Context getInitialContext(Hashtable<?, ?> env) throws NamingException {
        String initFactory;
        String providerURL = null;
        if (env != null) {
            providerURL = (String)env.get("java.naming.provider.url");
        }
        if (providerURL == null) {
            if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("No provider URL, use multiprotocol context");
            }
            return new MultiContext(env);
        }
        Hashtable newEnv = new Hashtable(env);
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("Use provider URL of the environment '" + providerURL + "'.");
        }
        if ("org.ow2.carol.jndi.spi.MultiOrbInitialContextFactory".equals(initFactory = (String)env.get("java.naming.factory.initial")) || "org.objectweb.carol.jndi.spi.MultiOrbInitialContextFactory".equals(initFactory) || CarolDefaultValues.INTERCEPT_JNDI.equals(initFactory)) {
            initFactory = null;
        }
        if (initFactory == null) {
            String protocolName = CarolDefaultValues.getRMIProtocol(providerURL);
            Protocol protocol = ConfigurationRepository.getProtocol(protocolName);
            if (protocol == null) {
                throw new NamingException("The protocol '" + protocolName + "' is not available within carol.");
            }
            initFactory = protocol.getInitialContextFactoryClassName();
            newEnv.put("java.naming.factory.initial", initFactory);
            if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("No INITIAL_CONTEXT_FACTORY, use '" + initFactory + "' as InitialContext factory.");
            }
        }
        return new InitialContext(newEnv);
    }
}

