/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import fr.dyade.aaa.common.Debug;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.TopicConnectionFactory;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.FactoryParameters;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.admin.AbstractConnectionFactory;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminWrapper;
import org.objectweb.joram.client.jms.admin.JoramSaxWrapper;
import org.objectweb.joram.client.jms.admin.Server;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.joram.client.jms.ha.local.HALocalConnectionFactory;
import org.objectweb.joram.client.jms.ha.tcp.HATcpConnectionFactory;
import org.objectweb.joram.client.jms.local.LocalConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TcpConnectionFactory;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.security.SimpleIdentity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public final class AdminModule {
    public static final String ADM_NAME_PROPERTY = "JoramAdminXML";
    public static final String DEFAULT_ADM_NAME = "default";
    public static final String REQUEST_TIMEOUT_PROP = "org.objectweb.joram.client.jms.admin.requestTimeout";
    public static final long DEFAULT_REQUEST_TIMEOUT = 120000L;
    protected static String localHost;
    protected static int localPort;
    private static Connection cnx;
    static AdminWrapper wrapper;
    private static boolean isHa;
    public static Logger logger;

    public static AdminWrapper getWrapper() throws ConnectException {
        if (wrapper == null) {
            throw new ConnectException();
        }
        return wrapper;
    }

    public static void setHa(boolean isHa) {
        AdminModule.isHa = isHa;
    }

    public static void main(String[] args) {
        try {
            AdminModule.executeXMLAdmin(args[0]);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public static void connect(javax.jms.ConnectionFactory cf) throws ConnectException, AdminException {
        AdminModule.doConnect((AbstractConnectionFactory)cf, AbstractConnectionFactory.getDefaultRootLogin(), AbstractConnectionFactory.getDefaultRootPassword(), SimpleIdentity.class.getName());
    }

    public static void connect(javax.jms.ConnectionFactory cf, String name, String password) throws ConnectException, AdminException {
        AdminModule.doConnect((AbstractConnectionFactory)cf, name, password, SimpleIdentity.class.getName());
    }

    public static void connect(javax.jms.ConnectionFactory cf, String name, String password, String identityClass) throws ConnectException, AdminException {
        AdminModule.doConnect((AbstractConnectionFactory)cf, name, password, identityClass);
    }

    public static void connect(TopicConnectionFactory cf, String name, String password) throws ConnectException, AdminException {
        AdminModule.doConnect((AbstractConnectionFactory)cf, name, password, SimpleIdentity.class.getName());
    }

    public static void connect(TopicConnectionFactory cf, String name, String password, String identityClass) throws ConnectException, AdminException {
        AdminModule.doConnect((AbstractConnectionFactory)cf, name, password, identityClass);
    }

    public static void connect() throws UnknownHostException, ConnectException, AdminException {
        AdminModule.doConnect("localhost", 16010, AbstractConnectionFactory.getDefaultRootLogin(), AbstractConnectionFactory.getDefaultRootPassword(), 0, "org.objectweb.joram.client.jms.tcp.ReliableTcpClient", SimpleIdentity.class.getName());
    }

    public static void connect(String name, String password) throws UnknownHostException, ConnectException, AdminException {
        AdminModule.doConnect("localhost", 16010, name, password, 0, "org.objectweb.joram.client.jms.tcp.ReliableTcpClient", SimpleIdentity.class.getName());
    }

    public static void connect(String name, String password, int cnxTimer) throws UnknownHostException, ConnectException, AdminException {
        AdminModule.doConnect("localhost", 16010, name, password, cnxTimer, "org.objectweb.joram.client.jms.tcp.ReliableTcpClient", SimpleIdentity.class.getName());
    }

    public static void connect(String host, int port, String name, String password) throws UnknownHostException, ConnectException, AdminException {
        AdminModule.doConnect(host, port, name, password, 0, "org.objectweb.joram.client.jms.tcp.ReliableTcpClient", SimpleIdentity.class.getName());
    }

    public static void connect(String host, int port, String name, String password, int cnxTimer) throws UnknownHostException, ConnectException, AdminException {
        AdminModule.doConnect(host, port, name, password, cnxTimer, "org.objectweb.joram.client.jms.tcp.ReliableTcpClient", SimpleIdentity.class.getName());
    }

    public static void connect(String name, String password, int cnxTimer, String reliableClass) throws UnknownHostException, ConnectException, AdminException {
        AdminModule.doConnect("localhost", 16010, name, password, cnxTimer, reliableClass, SimpleIdentity.class.getName());
    }

    public static void connect(String host, int port, String name, String password, int cnxTimer, String reliableClass) throws UnknownHostException, ConnectException, AdminException {
        AdminModule.doConnect(host, port, name, password, cnxTimer, reliableClass, SimpleIdentity.class.getName());
    }

    public static void connect(String host, int port, String name, String password, int cnxTimer, String reliableClass, String identityClass) throws UnknownHostException, ConnectException, AdminException {
        AdminModule.doConnect(host, port, name, password, cnxTimer, reliableClass, identityClass);
    }

    private static void doConnect(String host, int port, String name, String password, int cnxTimer, String reliableClass, String identityClass) throws UnknownHostException, ConnectException, AdminException {
        ConnectionFactory cf = null;
        if (isHa) {
            String urlHa = "hajoram://" + host + ":" + port;
            cf = HATcpConnectionFactory.create(urlHa);
        } else {
            cf = TcpConnectionFactory.create(host, port, reliableClass);
        }
        cf.getParameters().connectingTimer = cnxTimer;
        AdminModule.doConnect(cf, name, password, identityClass);
    }

    public static void collocatedConnect() throws ConnectException, AdminException {
        AdminModule.doCollocatedConnect(AbstractConnectionFactory.getDefaultRootLogin(), AbstractConnectionFactory.getDefaultRootPassword(), SimpleIdentity.class.getName());
    }

    public static void collocatedConnect(String name, String password) throws ConnectException, AdminException {
        AdminModule.doCollocatedConnect(name, password, SimpleIdentity.class.getName());
    }

    public static void collocatedConnect(String name, String password, String identityClass) throws ConnectException, AdminException {
        AdminModule.doCollocatedConnect(name, password, identityClass);
    }

    public static void doCollocatedConnect(String name, String password, String identityClass) throws ConnectException, AdminException {
        if (isHa) {
            AdminModule.doConnect(HALocalConnectionFactory.create(), name, password, identityClass);
        } else {
            AdminModule.doConnect(LocalConnectionFactory.create(), name, password, identityClass);
        }
    }

    private static void doConnect(AbstractConnectionFactory cf, String name, String password, String identityClass) throws ConnectException, AdminException {
        if (wrapper != null) {
            return;
        }
        cf.setIdentityClassName(identityClass);
        try {
            cnx = cf.createConnection(name, password);
            cnx.start();
            wrapper = new AdminWrapper(cnx);
            FactoryParameters params = cf.getParameters();
            localHost = params.getHost();
            localPort = params.getPort();
        }
        catch (JMSSecurityException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"AdminModule.doConnect", (Throwable)exc);
            }
            throw new AdminException(exc.getMessage());
        }
        catch (JMSException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"AdminModule.doConnect", (Throwable)exc);
            }
            throw new ConnectException("Connecting failed: " + (Object)((Object)exc));
        }
    }

    public static AdminReply doRequest(AdminRequest request) throws AdminException, ConnectException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Admin.doRequest(" + request + ')'));
        }
        if (wrapper == null) {
            throw new ConnectException("Admin connection not established.");
        }
        return wrapper.doRequest(request);
    }

    public static void disconnect() {
        if (wrapper != null) {
            wrapper.close();
        }
        wrapper = null;
        if (cnx != null) {
            try {
                cnx.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            cnx = null;
        }
    }

    public static void stopServer(int serverId) throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administration connection is closed.");
        }
        wrapper.stopServer(serverId);
        if (serverId == AdminModule.getLocalServerId()) {
            AdminModule.disconnect();
        }
    }

    public static void stopServer() throws ConnectException, AdminException {
        AdminModule.stopServer(AdminModule.getLocalServerId());
    }

    public static void addServer(int sid, String host, String domain, int port, String server) throws ConnectException, AdminException {
        AdminModule.addServer(sid, host, domain, port, server, new String[0], new String[0]);
    }

    public static void addServer(int sid, String host, String domain, int port, String server, String[] services, String[] args) throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        wrapper.addServer(sid, host, domain, port, server, services, args);
    }

    public static void removeServer(int sid) throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        wrapper.removeServer(sid);
    }

    public static void addDomain(String domain, int sid, int port) throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        wrapper.addDomain(domain, sid, port);
    }

    public static void addDomain(String domain, String network, int sid, int port) throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        wrapper.addDomain(domain, network, sid, port);
    }

    public static void removeDomain(String domain) throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        wrapper.removeDomain(domain);
    }

    public static String getConfiguration() throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        return wrapper.getConfiguration();
    }

    public static Queue getDefaultDMQ() throws ConnectException, AdminException {
        return AdminModule.getDefaultDMQ(AdminModule.getLocalServerId());
    }

    public static Queue getDefaultDMQ(int serverId) throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        return wrapper.getDefaultDMQ(serverId);
    }

    public static void setDefaultDMQ(Queue dmq) throws ConnectException, AdminException {
        AdminModule.setDefaultDMQ(AdminModule.getLocalServerId(), dmq);
    }

    public static void setDefaultDMQ(int serverId, Queue dmq) throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        wrapper.setDefaultDMQ(serverId, dmq);
    }

    public static String getDefaultDMQId() throws ConnectException, AdminException {
        return AdminModule.getDefaultDMQId(AdminModule.getLocalServerId());
    }

    public static String getDefaultDMQId(int serverId) throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        return wrapper.getDefaultDMQId(serverId);
    }

    public static void setDefaultDMQId(String dmqId) throws ConnectException, AdminException {
        AdminModule.setDefaultDMQId(AdminModule.getLocalServerId(), dmqId);
    }

    public static void setDefaultDMQId(int serverId, String dmqId) throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        wrapper.setDefaultDMQId(serverId, dmqId);
    }

    public static int getDefaultThreshold() throws ConnectException, AdminException {
        return AdminModule.getDefaultThreshold(AdminModule.getLocalServerId());
    }

    public static int getDefaultThreshold(int serverId) throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        return wrapper.getDefaultThreshold(serverId);
    }

    public static void setDefaultThreshold(int threshold) throws ConnectException, AdminException {
        AdminModule.setDefaultThreshold(AdminModule.getLocalServerId(), threshold);
    }

    public static void setDefaultThreshold(int serverId, int threshold) throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        wrapper.setDefaultThreshold(serverId, threshold);
    }

    public static List getServersIds() throws ConnectException, AdminException {
        return AdminModule.getServersIds(null);
    }

    public static List getServersIds(String domain) throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        int[] serverIds = wrapper.getServersIds(domain);
        Vector<Integer> res = new Vector<Integer>();
        for (int i = 0; i < serverIds.length; ++i) {
            res.addElement(new Integer(serverIds[i]));
        }
        return res;
    }

    public static Server[] getServers() throws ConnectException, AdminException {
        return AdminModule.getServers(null);
    }

    public static Server[] getServers(String domain) throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        return wrapper.getServers(domain);
    }

    public static String[] getDomainNames(int serverId) throws ConnectException, AdminException {
        return wrapper.getDomainNames(serverId);
    }

    public static List getDestinationsList() throws ConnectException, AdminException {
        return AdminModule.getDestinationsList(AdminModule.getLocalServerId());
    }

    public static List getDestinationsList(int serverId) throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        Destination[] dest = wrapper.getDestinations(serverId);
        Vector<Destination> list = new Vector<Destination>();
        for (int i = 0; i < dest.length; ++i) {
            list.addElement(dest[i]);
        }
        return list;
    }

    public static Destination[] getDestinations() throws ConnectException, AdminException {
        return AdminModule.getDestinations(AdminModule.getLocalServerId());
    }

    public static Destination[] getDestinations(int serverId) throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        return wrapper.getDestinations(serverId);
    }

    public static Destination createQueue(int serverId, String name, String className, Properties prop) throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        return wrapper.createQueue(serverId, name, className, prop);
    }

    public static Destination createTopic(int serverId, String name, String className, Properties prop) throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        return wrapper.createTopic(serverId, name, className, prop);
    }

    public static List getUsersList() throws ConnectException, AdminException {
        return AdminModule.getUsersList(AdminModule.getLocalServerId());
    }

    public static List getUsersList(int serverId) throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        User[] users = wrapper.getUsers(serverId);
        Vector<User> list = new Vector<User>();
        for (int i = 0; i < users.length; ++i) {
            list.add(users[i]);
        }
        return list;
    }

    public static User[] getUsers() throws ConnectException, AdminException {
        return AdminModule.getUsers(AdminModule.getLocalServerId());
    }

    public static User[] getUsers(int serverId) throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        return wrapper.getUsers(serverId);
    }

    public static Server getLocalServer() throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        return wrapper.getLocalServer();
    }

    public static User createUser(String name, String password, int serverId, String identityClassName) throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        return wrapper.createUser(name, password, serverId, identityClassName);
    }

    public static int getLocalServerId() throws ConnectException, AdminException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        return wrapper.getLocalServerId();
    }

    public static String getLocalHost() throws ConnectException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        return localHost;
    }

    public static int getLocalPort() throws ConnectException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        return localPort;
    }

    public static void abortRequest() throws JMSException, ConnectException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        wrapper.abortRequest();
    }

    public static void executeXMLAdmin(String cfgDir, String cfgFileName) throws Exception {
        AdminModule.executeXMLAdmin(new File(cfgDir, cfgFileName).getPath());
    }

    public static void executeXMLAdmin(String path) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AdminModule.executeXMLAdmin(" + path + ")"));
        }
        FileReader reader = null;
        File cfgFile = new File(path);
        try {
            if (!cfgFile.exists() || !cfgFile.isFile() || cfgFile.length() == 0L) {
                throw new IOException();
            }
            reader = new FileReader(cfgFile);
        }
        catch (IOException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Unable to find Joram Admin configuration file \"" + cfgFile.getPath() + "\"."));
            }
            reader = null;
        }
        if (reader != null) {
            AdminModule.executeAdmin(reader);
            return;
        }
        InputStream is = null;
        ClassLoader classLoader = null;
        try {
            classLoader = AdminModule.class.getClassLoader();
            if (classLoader != null) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Trying to find [" + path + "] using AdminModule class loader."));
                }
                is = classLoader.getResourceAsStream(path);
            }
        }
        catch (Throwable t) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Can't find [" + path + "] using AdminModule class loader."), t);
            }
            is = null;
        }
        if (is == null) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Trying to find [" + path + "] using ClassLoader.getSystemResource()."));
            }
            is = ClassLoader.getSystemResourceAsStream(path);
        }
        if (is == null) {
            throw new FileNotFoundException("XML Joram configuration file \"" + path + "\" not found.");
        }
        AdminModule.executeAdmin(new InputStreamReader(is));
    }

    public static void executeAdmin(Reader reader) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"executeAdmin(Reader)");
        }
        String cfgName = System.getProperty(ADM_NAME_PROPERTY, DEFAULT_ADM_NAME);
        JoramSaxWrapper wrapper = new JoramSaxWrapper();
        wrapper.parse(reader, cfgName);
    }

    public static void exportRepositoryToFile(String exportDir, String exportFilename) throws AdminException {
        int[] servers;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("export repository to " + exportDir.toString()));
        }
        StringBuffer strbuf = new StringBuffer();
        int indent = 0;
        strbuf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!--\n Exported JMS objects : \n - destinations : Topic/Queue \n The file can be reloaded through the admin interface (joramAdmin.executeXMLAdmin())\n-->\n<JoramAdmin>\n");
        indent += 2;
        try {
            servers = wrapper.getServersIds();
        }
        catch (Exception exc) {
            throw new AdminException("exportRepositoryToFile() failed - " + exc);
        }
        if (servers != null) {
            for (int i = 0; i < servers.length; ++i) {
                try {
                    Destination[] dest = wrapper.getDestinations(servers[i]);
                    for (int j = 0; j < dest.length; ++j) {
                        strbuf.append(dest[j].toXml(indent, servers[i]));
                    }
                    continue;
                }
                catch (Exception exc) {
                    throw new AdminException("exportRepositoryToFile() failed - " + exc);
                }
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("exported objects : \n" + strbuf.toString()));
            }
        }
        indent -= 2;
        strbuf.append("</JoramAdmin>");
        File exportFile = null;
        FileOutputStream fos = null;
        try {
            exportFile = new File(exportDir, exportFilename);
            fos = new FileOutputStream(exportFile);
            fos.write(strbuf.toString().getBytes());
        }
        catch (Exception ioe) {
            throw new AdminException("exportRepositoryToFile() failed - " + ioe);
        }
        finally {
            block20: {
                try {
                    exportFile = null;
                    fos.close();
                }
                catch (Exception e) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) break block20;
                    logger.log(BasicLevel.DEBUG, (Object)("Unable to close the file  : " + fos));
                }
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("File : " + exportDir + "/" + exportFilename + " created"));
            }
        }
    }

    public static void setTimeOutToAbortRequest(long timeOut) throws ConnectException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        wrapper.setTimeOutToAbortRequest(timeOut);
    }

    public static long getTimeOutToAbortRequest() throws ConnectException {
        if (wrapper == null) {
            throw new ConnectException("Administrator not connected.");
        }
        return wrapper.getTimeOutToAbortRequest();
    }

    static {
        cnx = null;
        isHa = false;
        logger = Debug.getLogger(AdminModule.class.getName());
    }
}

