/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.expression.converter.rdb;

import java.util.Map;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapter;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapterException;
import org.objectweb.jorm.type.api.PTypeSpace;
import org.objectweb.medor.expression.api.BinaryOperator;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.UnaryOperator;
import org.objectweb.medor.expression.converter.api.IExpression2WhereClause;
import org.objectweb.medor.expression.lib.Abs;
import org.objectweb.medor.expression.lib.BasicOperand;
import org.objectweb.medor.expression.lib.Concat;
import org.objectweb.medor.expression.lib.FirstLocate;
import org.objectweb.medor.expression.lib.IndexedLocate;
import org.objectweb.medor.expression.lib.Length;
import org.objectweb.medor.expression.lib.Like;
import org.objectweb.medor.expression.lib.Mod;
import org.objectweb.medor.expression.lib.Round;
import org.objectweb.medor.expression.lib.Sqrt;
import org.objectweb.medor.expression.lib.StringLower;
import org.objectweb.medor.expression.lib.StringTrim;
import org.objectweb.medor.expression.lib.StringUpper;
import org.objectweb.medor.expression.lib.Substring;

public class Expression2WhereClauseImpl
implements IExpression2WhereClause {
    private static IExpression2WhereClause converter = null;
    private static Class converterClass = null;
    private static final String[] knownChildren = new String[]{"org.objectweb.medor.query.jorm.lib.JormExpression2WhereClause", "org.objectweb.medor.query.rdb.lib.MedorExpression2WhereClause"};
    private static final String LAND = "&";
    private static final String LCOND_AND = "&&";
    private static final String AND = "AND";
    private static final String EQUAL = "=";
    private static final String LEQUAL = "==";
    private static final String LOR = "|";
    private static final String LCOND_OR = "||";
    private static final String OR = "OR";
    private static final String NOT = "NOT";

    public static synchronized void registerConverter(Class c) {
        if (c == null) {
            throw new IllegalArgumentException("Null IExpression2WhereClause implementation is not allowed");
        }
        if (converterClass == null || !Expression2WhereClauseImpl.isAncestor(c, converterClass)) {
            converterClass = c;
        }
    }

    private static boolean isAncestor(Class c1, Class c2) {
        return c1 == c2 || c2.getSuperclass() != null && Expression2WhereClauseImpl.isAncestor(c1, c2.getSuperclass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IExpression2WhereClause getConverter() throws ExpressionException {
        if (converter == null) {
            Class clazz = Expression2WhereClauseImpl.class;
            synchronized (clazz) {
                if (converter == null) {
                    try {
                        converter = (IExpression2WhereClause)converterClass.newInstance();
                    }
                    catch (Exception e) {
                        throw new ExpressionException("Impossible to instanciate the converter : ", e);
                    }
                }
            }
        }
        return converter;
    }

    public static String e2where(Expression e, RdbAdapter rdbAdapter, Map ctx) throws ExpressionException {
        return Expression2WhereClauseImpl.getConverter().convertExp2WhereClause(e, rdbAdapter, ctx);
    }

    public Expression2WhereClauseImpl() {
        Expression2WhereClauseImpl.registerConverter(this.getClass());
    }

    public String convertExp2WhereClause(Expression e, RdbAdapter rdbAdapter, Map ctx) throws ExpressionException {
        StringBuffer sb = new StringBuffer();
        this.convertExp2WhereClause(e, rdbAdapter, sb, ctx);
        return sb.toString();
    }

    public void convertExp2WhereClause(Expression exp, RdbAdapter rdbAdapter, StringBuffer sb, Map ctx) throws ExpressionException {
        if (exp instanceof ParameterOperand) {
            sb.append("?");
        } else if (exp instanceof BasicOperand) {
            BasicOperand o = (BasicOperand)exp;
            if (rdbAdapter != null) {
                switch (o.getType().getTypeCode()) {
                    case 0: {
                        sb.append(rdbAdapter.getValueAsSQLString(o.getBoolean()));
                        break;
                    }
                    case 1: {
                        sb.append(rdbAdapter.getValueAsSQLString(o.getChar()));
                        break;
                    }
                    case 2: {
                        sb.append(rdbAdapter.getValueAsSQLString(o.getByte()));
                        break;
                    }
                    case 3: {
                        sb.append(rdbAdapter.getValueAsSQLString(o.getShort()));
                        break;
                    }
                    case 4: {
                        sb.append(rdbAdapter.getValueAsSQLString(o.getInt()));
                        break;
                    }
                    case 5: {
                        sb.append(rdbAdapter.getValueAsSQLString(o.getLong()));
                        break;
                    }
                    case 6: {
                        sb.append(rdbAdapter.getValueAsSQLString(o.getFloat()));
                        break;
                    }
                    case 7: {
                        sb.append(rdbAdapter.getValueAsSQLString(o.getDouble()));
                        break;
                    }
                    default: {
                        sb.append(rdbAdapter.getValueAsSQLString(o.getObject(), o.getType().getTypeCode()));
                        break;
                    }
                }
            } else {
                switch (o.getType().getTypeCode()) {
                    case 0: 
                    case 8: {
                        sb.append(o.getBoolean() ? "1" : "0");
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        sb.append(o.getValueAsString());
                        break;
                    }
                    default: {
                        sb.append("'" + o.getValueAsString() + "'");
                    }
                }
            }
        } else if (exp instanceof Round) {
            Round round = (Round)exp;
            sb.append("ROUND(");
            this.convertExp2WhereClause(round.getExpression(0), rdbAdapter, sb, ctx);
            sb.append(", ");
            sb.append(round.getRound());
            sb.append(")");
        } else if (exp instanceof Like) {
            Like l = (Like)exp;
            sb.append("(");
            this.convertExp2WhereClause(l.getExpression(0), rdbAdapter, sb, ctx);
            sb.append(" ");
            sb.append(l.getOperatorString());
            sb.append(" ");
            this.convertExp2WhereClause(l.getExpression(1), rdbAdapter, sb, ctx);
            if (l.getOperandNumber() == 3) {
                sb.append(" ESCAPE ");
                this.convertExp2WhereClause(l.getExpression(2), rdbAdapter, sb, ctx);
            }
            sb.append(")");
        } else if (exp instanceof FirstLocate) {
            Operator op = (Operator)exp;
            if (rdbAdapter == null) {
                sb.append(this.toSqlOperator(op.getOperatorString()));
                sb.append("(");
                this.convertExp2WhereClause(op.getExpression(0), rdbAdapter, sb, ctx);
                sb.append(", ");
                this.convertExp2WhereClause(op.getExpression(1), rdbAdapter, sb, ctx);
                sb.append(")");
            } else {
                try {
                    sb.append(rdbAdapter.getFirstLocateExpression(this.convertExp2WhereClause(op.getExpression(0), rdbAdapter, ctx), this.convertExp2WhereClause(op.getExpression(1), rdbAdapter, ctx)));
                }
                catch (RdbAdapterException pe) {
                    throw new ExpressionException(pe.getMessage());
                }
            }
        } else if (exp instanceof Concat) {
            Operator op = (Operator)exp;
            if (rdbAdapter == null) {
                sb.append(this.toSqlOperator(op.getOperatorString()));
                sb.append("(");
                this.convertExp2WhereClause(op.getExpression(0), rdbAdapter, sb, ctx);
                sb.append(", ");
                this.convertExp2WhereClause(op.getExpression(1), rdbAdapter, sb, ctx);
                sb.append(")");
            } else {
                rdbAdapter.escapeFunctionOpen(sb);
                sb.append(rdbAdapter.getConcatExpression(this.convertExp2WhereClause(op.getExpression(0), rdbAdapter, ctx), this.convertExp2WhereClause(op.getExpression(1), rdbAdapter, ctx)));
                rdbAdapter.escapeFunctionClose(sb);
            }
        } else if (exp instanceof Length || exp instanceof Abs || exp instanceof Sqrt) {
            Operator op = (Operator)exp;
            if (rdbAdapter != null) {
                rdbAdapter.escapeFunctionOpen(sb);
            }
            sb.append(this.toSqlOperator(op.getOperatorString()));
            sb.append("(");
            this.convertExp2WhereClause(op.getExpression(0), rdbAdapter, sb, ctx);
            sb.append(")");
            if (rdbAdapter != null) {
                rdbAdapter.escapeFunctionClose(sb);
            }
        } else if (exp instanceof Mod) {
            Operator op = (Operator)exp;
            if (rdbAdapter != null) {
                rdbAdapter.escapeFunctionOpen(sb);
            }
            sb.append(this.toSqlOperator(op.getOperatorString()));
            sb.append("(");
            this.convertExp2WhereClause(op.getExpression(0), rdbAdapter, sb, ctx);
            sb.append(", ");
            this.convertExp2WhereClause(op.getExpression(1), rdbAdapter, sb, ctx);
            sb.append(")");
            if (rdbAdapter != null) {
                rdbAdapter.escapeFunctionClose(sb);
            }
        } else if (exp instanceof StringTrim) {
            StringTrim op = (StringTrim)exp;
            sb.append(this.toSqlOperator(op.getOperatorString()));
            sb.append("(");
            sb.append(op.getTrimSpec());
            sb.append(" ");
            sb.append(op.getTrimCharacter());
            sb.append(" FROM ");
            this.convertExp2WhereClause(op.getExpression(0), rdbAdapter, sb, ctx);
            sb.append(")");
        } else if (exp instanceof BinaryOperator) {
            Operator op = (Operator)exp;
            sb.append("(");
            this.convertExp2WhereClause(op.getExpression(0), rdbAdapter, sb, ctx);
            sb.append(" ");
            sb.append(this.toSqlOperator(op.getOperatorString()));
            sb.append(" ");
            this.convertExp2WhereClause(op.getExpression(1), rdbAdapter, sb, ctx);
            sb.append(")");
        } else if (exp instanceof UnaryOperator) {
            Operator op = (Operator)exp;
            sb.append(this.toSqlOperator(op.getOperatorString()));
            sb.append("(");
            this.convertExp2WhereClause(op.getExpression(0), rdbAdapter, sb, ctx);
            sb.append(")");
        } else if (exp instanceof Substring) {
            Operator op = (Operator)exp;
            if (rdbAdapter != null) {
                rdbAdapter.escapeFunctionOpen(sb);
            }
            sb.append(this.toSqlOperator(op.getOperatorString()));
            sb.append("(");
            sb.append(this.convertExp2WhereClause(op.getExpression(0), rdbAdapter, ctx));
            sb.append(", ");
            sb.append(this.convertExp2WhereClause(op.getExpression(1), rdbAdapter, ctx));
            sb.append(", ");
            sb.append(this.convertExp2WhereClause(op.getExpression(2), rdbAdapter, ctx));
            sb.append(")");
            if (rdbAdapter != null) {
                rdbAdapter.escapeFunctionClose(sb);
            }
        } else if (exp instanceof StringUpper || exp instanceof StringLower) {
            Operator op = (Operator)exp;
            sb.append(this.toSqlOperator(op.getOperatorString()));
            sb.append("(");
            sb.append(this.convertExp2WhereClause(op.getExpression(0), rdbAdapter, ctx));
            sb.append(")");
        } else if (exp instanceof StringUpper || exp instanceof StringLower || exp instanceof Length) {
            Operator op = (Operator)exp;
            sb.append(this.toSqlOperator(op.getOperatorString()));
            sb.append("(");
            sb.append(this.convertExp2WhereClause(op.getExpression(0), rdbAdapter, ctx));
            sb.append(")");
        } else if (exp instanceof IndexedLocate) {
            Operator op = (Operator)exp;
            if (rdbAdapter == null) {
                sb.append(this.toSqlOperator(op.getOperatorString()));
                sb.append("(");
                this.convertExp2WhereClause(op.getExpression(0), rdbAdapter, sb, ctx);
                sb.append(", ");
                this.convertExp2WhereClause(op.getExpression(1), rdbAdapter, sb, ctx);
                sb.append(", ");
                this.convertExp2WhereClause(op.getExpression(2), rdbAdapter, sb, ctx);
                sb.append(")");
            } else {
                try {
                    sb.append(rdbAdapter.getIndexedLocateExpression(this.convertExp2WhereClause(op.getExpression(0), rdbAdapter, ctx), this.convertExp2WhereClause(op.getExpression(1), rdbAdapter, ctx), this.convertExp2WhereClause(op.getExpression(2), rdbAdapter, ctx)));
                }
                catch (RdbAdapterException pe) {
                    throw new ExpressionException(pe.getMessage());
                }
            }
        }
    }

    public String toSqlOperator(String in) {
        if (LAND.equals(in) || LCOND_AND.equals(in)) {
            return AND;
        }
        if (LOR.equals(in) || LCOND_OR.equals(in)) {
            return OR;
        }
        if (in.equals(LEQUAL)) {
            return EQUAL;
        }
        if (in.equals("!")) {
            return NOT;
        }
        return in;
    }

    public void convertExp2WhereClauseBuilder(Expression exp, String rdbAdapterVarName, StringBuffer sb, Map ctx) throws ExpressionException {
        if (exp instanceof ParameterOperand) {
            sb.append("?");
        } else if (exp instanceof BasicOperand) {
            sb.append("\" + ");
            sb.append(rdbAdapterVarName);
            sb.append(".getValueAsSQLString(");
            BasicOperand o = (BasicOperand)exp;
            switch (o.getType().getTypeCode()) {
                case 0: 
                case 8: {
                    sb.append(o.getBoolean());
                    break;
                }
                case 1: 
                case 9: {
                    sb.append("'");
                    sb.append(o.getChar());
                    sb.append("'");
                    break;
                }
                case 2: 
                case 10: {
                    sb.append("(byte) ");
                    sb.append(o.getByte());
                    break;
                }
                case 11: {
                    sb.append("(short) ");
                    sb.append(o.getShort());
                    break;
                }
                case 4: 
                case 12: {
                    sb.append(o.getInt());
                    break;
                }
                case 5: 
                case 13: {
                    sb.append(o.getLong());
                    sb.append("l");
                    break;
                }
                case 6: 
                case 14: {
                    sb.append("(float) ");
                    sb.append(o.getFloat());
                    break;
                }
                case 7: 
                case 15: {
                    sb.append("(double) ");
                    sb.append(o.getDouble());
                    break;
                }
                case 16: {
                    sb.append("\"");
                    sb.append(o.getString());
                    sb.append("\", ");
                    sb.append(PTypeSpace.STRING.getProgName());
                    break;
                }
                case 17: {
                    sb.append("new java.util.Date(");
                    sb.append(o.getDate().getTime());
                    sb.append("), ");
                    sb.append(PTypeSpace.DATE.getProgName());
                    break;
                }
                case 21: {
                    sb.append("new java.math.BigInteger(");
                    sb.append(o.getBigInteger().toString());
                    sb.append("), ");
                    sb.append(PTypeSpace.BIGINTEGER.getProgName());
                    break;
                }
                case 22: {
                    sb.append("new java.math.BigDecimal(");
                    sb.append(o.getBigDecimal().toString());
                    sb.append("), ");
                    sb.append(PTypeSpace.BIGDECIMAL.getProgName());
                    break;
                }
                default: {
                    sb.append("null");
                }
            }
            sb.append(") + \"");
        } else if (exp instanceof Round) {
            Round round = (Round)exp;
            sb.append("ROUND(");
            this.convertExp2WhereClauseBuilder(round.getExpression(0), rdbAdapterVarName, sb, ctx);
            sb.append(", ");
            sb.append(round.getRound());
            sb.append(")");
        } else if (exp instanceof Like) {
            Like l = (Like)exp;
            sb.append("(");
            this.convertExp2WhereClauseBuilder(l.getExpression(0), rdbAdapterVarName, sb, ctx);
            sb.append(l.getOperatorString());
            this.convertExp2WhereClauseBuilder(l.getExpression(1), rdbAdapterVarName, sb, ctx);
            if (l.getOperandNumber() == 3) {
                sb.append(" ESCAPE ");
                this.convertExp2WhereClauseBuilder(l.getExpression(2), rdbAdapterVarName, sb, ctx);
                sb.append(")");
            } else {
                sb.append(")");
            }
        } else if (exp instanceof FirstLocate) {
            Operator op = (Operator)exp;
            sb.append("\" + ");
            sb.append(rdbAdapterVarName);
            sb.append(".getFirstLocateExpression(");
            this.convertExp2WhereClauseBuilder(op.getExpression(0), rdbAdapterVarName, sb, ctx);
            sb.append(", ");
            this.convertExp2WhereClauseBuilder(op.getExpression(1), rdbAdapterVarName, sb, ctx);
            sb.append(") + \"");
        } else if (exp instanceof Concat) {
            Operator op = (Operator)exp;
            sb.append("\" + ");
            sb.append(rdbAdapterVarName);
            sb.append(".getConcatExpression(");
            this.convertExp2WhereClauseBuilder(op.getExpression(0), rdbAdapterVarName, sb, ctx);
            sb.append(", ");
            this.convertExp2WhereClauseBuilder(op.getExpression(1), rdbAdapterVarName, sb, ctx);
            sb.append(") + \"");
        } else if (exp instanceof Mod) {
            Operator op = (Operator)exp;
            sb.append(this.toSqlOperator(op.getOperatorString()));
            sb.append("(");
            this.convertExp2WhereClauseBuilder(op.getExpression(0), rdbAdapterVarName, sb, ctx);
            sb.append(", ");
            this.convertExp2WhereClauseBuilder(op.getExpression(1), rdbAdapterVarName, sb, ctx);
            sb.append(")");
        } else if (exp instanceof BinaryOperator) {
            Operator op = (Operator)exp;
            sb.append("(");
            this.convertExp2WhereClauseBuilder(op.getExpression(0), rdbAdapterVarName, sb, ctx);
            sb.append(" ");
            sb.append(this.toSqlOperator(op.getOperatorString()));
            sb.append(" ");
            this.convertExp2WhereClauseBuilder(op.getExpression(1), rdbAdapterVarName, sb, ctx);
            sb.append(")");
        } else if (exp instanceof UnaryOperator) {
            Operator op = (Operator)exp;
            sb.append(this.toSqlOperator(op.getOperatorString()));
            sb.append("(");
            this.convertExp2WhereClauseBuilder(op.getExpression(0), rdbAdapterVarName, sb, ctx);
            sb.append(")");
        } else if (exp instanceof Substring) {
            Operator op = (Operator)exp;
            sb.append("substring");
            sb.append("(");
            this.convertExp2WhereClauseBuilder(op.getExpression(0), rdbAdapterVarName, sb, ctx);
            sb.append(", ");
            this.convertExp2WhereClauseBuilder(op.getExpression(1), rdbAdapterVarName, sb, ctx);
            sb.append(", ");
            this.convertExp2WhereClauseBuilder(op.getExpression(2), rdbAdapterVarName, sb, ctx);
            sb.append(")");
        } else if (exp instanceof Length) {
            Operator op = (Operator)exp;
            sb.append("\" + ");
            sb.append(rdbAdapterVarName);
            sb.append(".getLengthOperator() + \"");
            sb.append("(");
            this.convertExp2WhereClauseBuilder(op.getExpression(0), rdbAdapterVarName, sb, ctx);
            sb.append(")");
        } else if (exp instanceof StringUpper || exp instanceof StringLower) {
            Operator op = (Operator)exp;
            sb.append(this.toSqlOperator(op.getOperatorString()));
            sb.append("(");
            this.convertExp2WhereClauseBuilder(op.getExpression(0), rdbAdapterVarName, sb, ctx);
            sb.append(")");
        } else if (exp instanceof IndexedLocate) {
            Operator op = (Operator)exp;
            sb.append("\" + ");
            sb.append(rdbAdapterVarName);
            sb.append(".getIndexedLocateExpression(");
            this.convertExp2WhereClauseBuilder(op.getExpression(0), rdbAdapterVarName, sb, ctx);
            sb.append(", ");
            this.convertExp2WhereClauseBuilder(op.getExpression(1), rdbAdapterVarName, sb, ctx);
            sb.append(", ");
            this.convertExp2WhereClauseBuilder(op.getExpression(2), rdbAdapterVarName, sb, ctx);
            sb.append(") + \"");
        } else {
            throw new ExpressionException("Umanaged expression element: " + exp);
        }
    }

    static {
        ClassLoader cl = Expression2WhereClauseImpl.class.getClassLoader();
        converterClass = null;
        for (int i = 0; i < knownChildren.length && converterClass == null; ++i) {
            try {
                converterClass = cl.loadClass(knownChildren[i]);
                continue;
            }
            catch (Exception e) {
                converterClass = null;
            }
        }
        if (converterClass == null) {
            converterClass = Expression2WhereClauseImpl.class;
        }
    }
}

