/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.perseus.cache.lib;

import org.objectweb.perseus.cache.api.CacheException;
import org.objectweb.perseus.cache.replacement.api.ReplacementManager;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class BackgroundCleaner
implements Runnable {
    private Object wakeup;
    private boolean runnning;
    private ReplacementManager rm;
    private Thread thread;
    private int size;
    private Logger logger;

    public BackgroundCleaner(ReplacementManager rm, Logger logger) {
        this.rm = rm;
        this.wakeup = new Object();
        this.runnning = true;
        this.logger = logger;
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public Thread getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        if (!this.runnning) {
            Object object = this.wakeup;
            synchronized (object) {
                if (!this.runnning) {
                    if (this.logger != null && this.logger.isLoggable(BasicLevel.INFO)) {
                        this.logger.log(BasicLevel.INFO, (Object)"BackgroundCleaner restart");
                    }
                    this.runnning = true;
                    this.wakeup.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.runnning) {
            Object object = this.wakeup;
            synchronized (object) {
                if (this.runnning) {
                    if (this.logger != null && this.logger.isLoggable(BasicLevel.INFO)) {
                        this.logger.log(BasicLevel.INFO, (Object)"BackgroundCleaner stop");
                    }
                    this.runnning = false;
                    this.wakeup.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backgroungCleanup(int _size) {
        Object object = this.wakeup;
        synchronized (object) {
            this.size = _size;
            this.wakeup.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.runnning) {
            Object object = this.wakeup;
            synchronized (object) {
                try {
                    if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
                        this.logger.log(BasicLevel.DEBUG, (Object)"Wait next wake up");
                    }
                    this.wakeup.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.runnning) continue;
            if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Cleanup the cache in background (" + this.size + ")"));
            }
            try {
                this.rm.forceFree(this.size);
            }
            catch (CacheException e) {
                if (this.logger == null) continue;
                this.logger.log(BasicLevel.ERROR, (Object)("Impossible to cleanup the cache (" + this.size + "): "), (Throwable)e);
            }
        }
        if (this.logger != null && this.logger.isLoggable(BasicLevel.INFO)) {
            this.logger.log(BasicLevel.INFO, (Object)"BackgroundCleaner end");
        }
    }
}

