/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.cxf.CxfSoapBinding;
import org.apache.camel.component.cxf.util.CxfHeaderHelper;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class CamelConduit
extends AbstractConduit
implements Configurable {
    protected static final String BASE_BEAN_NAME_SUFFIX = ".camel-conduit";
    private static final Logger LOG = LogUtils.getL7dLogger(CamelConduit.class);
    private CamelContext camelContext;
    private EndpointInfo endpointInfo;
    private String targetCamelEndpointUri;
    private ProducerTemplate camelTemplate;
    private Bus bus;
    private HeaderFilterStrategy headerFilterStrategy;

    public CamelConduit(CamelContext context, Bus b, EndpointInfo endpointInfo) {
        this(context, b, endpointInfo, null);
    }

    public CamelConduit(CamelContext context, Bus b, EndpointInfo epInfo, EndpointReferenceType targetReference) {
        this(context, b, epInfo, targetReference, null);
    }

    public CamelConduit(CamelContext context, Bus b, EndpointInfo epInfo, EndpointReferenceType targetReference, HeaderFilterStrategy headerFilterStrategy) {
        super(CamelConduit.getTargetReference((EndpointInfo)epInfo, (EndpointReferenceType)targetReference, (Bus)b));
        String address = epInfo.getAddress();
        if (address != null) {
            this.targetCamelEndpointUri = address.substring("camel:".length());
            if (this.targetCamelEndpointUri.startsWith("//")) {
                this.targetCamelEndpointUri = this.targetCamelEndpointUri.substring(2);
            }
        }
        this.camelContext = context;
        this.endpointInfo = epInfo;
        this.bus = b;
        this.initConfig();
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public void setCamelContext(CamelContext context) {
        this.camelContext = context;
    }

    public CamelContext getCamelContext() {
        if (this.camelContext == null) {
            this.getLogger().log(Level.INFO, "No CamelContext injected, create a default one");
            this.camelContext = new DefaultCamelContext();
        }
        return this.camelContext;
    }

    public void prepare(Message message) throws IOException {
        this.getLogger().log(Level.FINE, "CamelConduit send message");
        message.setContent(OutputStream.class, (Object)new CamelOutputStream(message));
    }

    public void close() {
        this.getLogger().log(Level.FINE, "CamelConduit closed ");
    }

    protected Logger getLogger() {
        return LOG;
    }

    public String getBeanName() {
        if (this.endpointInfo == null || this.endpointInfo.getName() == null) {
            return "default.camel-conduit";
        }
        return this.endpointInfo.getName().toString() + BASE_BEAN_NAME_SUFFIX;
    }

    private void initConfig() {
        Configurer configurer;
        if (this.bus != null && null != (configurer = (Configurer)this.bus.getExtension(Configurer.class))) {
            configurer.configureBean((Object)this);
        }
    }

    public ProducerTemplate getCamelTemplate() {
        if (this.camelTemplate == null) {
            this.camelTemplate = this.getCamelContext().createProducerTemplate();
        }
        return this.camelTemplate;
    }

    public void setCamelTemplate(ProducerTemplate template) {
        this.camelTemplate = template;
    }

    protected class DecoupledDestination
    implements Destination {
        protected MessageObserver decoupledMessageObserver;
        private EndpointReferenceType address;

        DecoupledDestination(EndpointReferenceType ref, MessageObserver incomingObserver) {
            this.address = ref;
            this.decoupledMessageObserver = incomingObserver;
        }

        public EndpointReferenceType getAddress() {
            return this.address;
        }

        public Conduit getBackChannel(Message inMessage, Message partialResponse, EndpointReferenceType addr) throws IOException {
            return null;
        }

        public void shutdown() {
        }

        public synchronized void setMessageObserver(MessageObserver observer) {
            this.decoupledMessageObserver = observer;
        }

        public synchronized MessageObserver getMessageObserver() {
            return this.decoupledMessageObserver;
        }
    }

    private class CamelOutputStream
    extends CachedOutputStream {
        private Message outMessage;
        private boolean isOneWay;

        public CamelOutputStream(Message m) {
            this.outMessage = m;
        }

        protected void doFlush() throws IOException {
        }

        protected void doClose() throws IOException {
            this.isOneWay = this.outMessage.getExchange().isOneWay();
            this.commitOutputMessage();
        }

        protected void onWrite() throws IOException {
        }

        private void commitOutputMessage() {
            ExchangePattern pattern = this.isOneWay ? ExchangePattern.InOnly : ExchangePattern.InOut;
            CamelConduit.this.getLogger().log(Level.FINE, "send the message to endpoint" + CamelConduit.this.targetCamelEndpointUri);
            Exchange exchange = CamelConduit.this.getCamelTemplate().send(CamelConduit.this.targetCamelEndpointUri, pattern, new Processor(){

                public void process(Exchange ex) throws IOException {
                    CachedOutputStream outputStream = (CachedOutputStream)CamelOutputStream.this.outMessage.getContent(OutputStream.class);
                    CxfHeaderHelper.propagateCxfToCamel(CamelConduit.this.headerFilterStrategy, CamelOutputStream.this.outMessage, ex.getIn().getHeaders(), ex);
                    ex.getIn().setBody((Object)outputStream.getBytes());
                    CamelConduit.this.getLogger().log(Level.FINE, "template sending request: ", ex.getIn());
                }
            });
            exchange.setProperty("org.apache.cxf.message.exchange", (Object)this.outMessage.getExchange());
            if (!this.isOneWay) {
                this.handleResponse(exchange);
            }
        }

        private void handleResponse(Exchange exchange) {
            Message inMessage = CxfSoapBinding.getCxfInMessage(CamelConduit.this.headerFilterStrategy, exchange, true);
            CamelConduit.this.incomingObserver.onMessage(inMessage);
        }
    }
}

