/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.io.IOException;
import java.util.Map;
import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.mail.MailBinding;
import org.apache.camel.component.mail.MailUtils;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.CollectionHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailMessage
extends DefaultMessage {
    private static final transient Log LOG = LogFactory.getLog(MailMessage.class);
    private javax.mail.Message mailMessage;

    public MailMessage() {
    }

    public MailMessage(javax.mail.Message message) {
        this.mailMessage = message;
    }

    public String toString() {
        if (this.mailMessage != null) {
            return "MailMessage: " + MailUtils.dumpMessage(this.mailMessage);
        }
        return "MailMessage: " + this.getBody();
    }

    public MailMessage copy() {
        MailMessage answer = (MailMessage)super.copy();
        answer.mailMessage = this.mailMessage;
        return answer;
    }

    public javax.mail.Message getMessage() {
        return this.mailMessage;
    }

    public void setMessage(javax.mail.Message mailMessage) {
        this.mailMessage = mailMessage;
    }

    public MailMessage newInstance() {
        return new MailMessage();
    }

    protected Object createBody() {
        if (this.mailMessage != null) {
            MailBinding binding = (MailBinding)ExchangeHelper.getBinding((Exchange)this.getExchange(), MailBinding.class);
            return binding != null ? binding.extractBodyFromMail(this.getExchange(), this.mailMessage) : null;
        }
        return null;
    }

    protected void populateInitialHeaders(Map<String, Object> map) {
        if (this.mailMessage != null) {
            try {
                MailBinding binding = (MailBinding)ExchangeHelper.getBinding((Exchange)this.getExchange(), MailBinding.class);
                if (binding != null) {
                    map.putAll(binding.extractHeadersFromMail(this.mailMessage, this.getExchange()));
                }
            }
            catch (MessagingException e) {
                throw new RuntimeCamelException("Error accessing headers due to: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void populateInitialAttachments(Map<String, DataHandler> map) {
        if (this.mailMessage != null) {
            try {
                MailMessage.extractAttachments(this.mailMessage, map);
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error populating the initial mail message attachments", (Throwable)e);
            }
        }
    }

    public void copyFrom(Message that) {
        super.copyFrom(that);
        if (that instanceof MailMessage) {
            MailMessage mailMessage = (MailMessage)that;
            this.mailMessage = mailMessage.mailMessage;
        }
    }

    protected static void extractAttachments(javax.mail.Message message, Map<String, DataHandler> map) throws MessagingException, IOException {
        LOG.trace((Object)"Extracting attachments +++ start +++");
        Object content = message.getContent();
        if (content instanceof Multipart) {
            MailMessage.extractFromMultipart((Multipart)content, map);
        } else if (content != null) {
            LOG.trace((Object)("No attachments to extract as content is not Multipart: " + content.getClass().getName()));
        }
        LOG.trace((Object)"Extracting attachments +++ done +++");
    }

    protected static void extractFromMultipart(Multipart mp, Map<String, DataHandler> map) throws MessagingException, IOException {
        for (int i = 0; i < mp.getCount(); ++i) {
            String fileName;
            BodyPart part = mp.getBodyPart(i);
            LOG.trace((Object)("Part #" + i + ": " + part));
            if (part.isMimeType("multipart/*")) {
                LOG.trace((Object)("Part #" + i + ": is mimetype: multipart/*"));
                MailMessage.extractFromMultipart((Multipart)part.getContent(), map);
                continue;
            }
            String disposition = part.getDisposition();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Part #" + i + ": Disposition: " + part.getDisposition()));
                LOG.trace((Object)("Part #" + i + ": Description: " + part.getDescription()));
                LOG.trace((Object)("Part #" + i + ": ContentType: " + part.getContentType()));
                LOG.trace((Object)("Part #" + i + ": FileName: " + part.getFileName()));
                LOG.trace((Object)("Part #" + i + ": Size: " + part.getSize()));
                LOG.trace((Object)("Part #" + i + ": LineCount: " + part.getLineCount()));
            }
            if (disposition == null || !disposition.equalsIgnoreCase("attachment") && !disposition.equalsIgnoreCase("inline") || (fileName = part.getFileName()) == null) continue;
            LOG.debug((Object)("Mail contains file attachment: " + fileName));
            CollectionHelper.appendValue(map, (Object)fileName, (Object)part.getDataHandler());
        }
    }
}

