/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.Iterator;
import java.util.List;
import org.hibernate.Hibernate;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.type.Type;

public class DerbyConcatFunction
implements SQLFunction {
    public Type getReturnType(Type columnType, Mapping mapping) throws QueryException {
        return Hibernate.STRING;
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public String render(List args, SessionFactoryImplementor factory) throws QueryException {
        boolean areAllArgsParams = true;
        Iterator itr = args.iterator();
        while (itr.hasNext()) {
            String arg = (String)itr.next();
            if ("?".equals(arg)) continue;
            areAllArgsParams = false;
            break;
        }
        if (areAllArgsParams) {
            return this.join(args.iterator(), new StringTransformer(){

                public String transform(String string) {
                    return "cast( ? as varchar(32672) )";
                }
            }, new StringJoinTemplate(){

                public String getBeginning() {
                    return "varchar( ";
                }

                public String getSeparator() {
                    return " || ";
                }

                public String getEnding() {
                    return " )";
                }
            });
        }
        return this.join(args.iterator(), new StringTransformer(){

            public String transform(String string) {
                return string;
            }
        }, new StringJoinTemplate(){

            public String getBeginning() {
                return "(";
            }

            public String getSeparator() {
                return "||";
            }

            public String getEnding() {
                return ")";
            }
        });
    }

    private String join(Iterator elements, StringTransformer elementTransformer, StringJoinTemplate template) {
        StringBuffer buffer = new StringBuffer(template.getBeginning());
        while (elements.hasNext()) {
            String element = (String)elements.next();
            buffer.append(elementTransformer.transform(element));
            if (!elements.hasNext()) continue;
            buffer.append(template.getSeparator());
        }
        return buffer.append(template.getEnding()).toString();
    }

    private static interface StringJoinTemplate {
        public String getBeginning();

        public String getSeparator();

        public String getEnding();
    }

    private static interface StringTransformer {
        public String transform(String var1);
    }
}

