/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener.serversession;

import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.Session;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.listener.serversession.ListenerSessionManager;
import org.springframework.jms.listener.serversession.ServerSessionFactory;
import org.springframework.jms.support.JmsUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class SimpleServerSessionFactory
implements ServerSessionFactory {
    public static final String DEFAULT_THREAD_NAME_PREFIX = ClassUtils.getShortName((Class)SimpleServerSessionFactory.class) + "-";
    private TaskExecutor taskExecutor = new SimpleAsyncTaskExecutor(DEFAULT_THREAD_NAME_PREFIX);

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        Assert.notNull((Object)taskExecutor, (String)"taskExecutor is required");
        this.taskExecutor = taskExecutor;
    }

    protected TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public ServerSession getServerSession(ListenerSessionManager sessionManager) throws JMSException {
        return new SimpleServerSession(sessionManager);
    }

    public void close(ListenerSessionManager sessionManager) {
    }

    private class SimpleServerSession
    implements ServerSession {
        private final ListenerSessionManager sessionManager;
        private final Session session;

        public SimpleServerSession(ListenerSessionManager sessionManager) throws JMSException {
            this.sessionManager = sessionManager;
            this.session = sessionManager.createListenerSession();
        }

        public Session getSession() {
            return this.session;
        }

        public void start() {
            SimpleServerSessionFactory.this.getTaskExecutor().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        SimpleServerSession.this.sessionManager.executeListenerSession(SimpleServerSession.this.session);
                    }
                    finally {
                        JmsUtils.closeSession(SimpleServerSession.this.session);
                    }
                }
            });
        }
    }
}

