/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.discovery.jgroups.utils;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.management.MBeanServer;
import org.jgroups.Address;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelListener;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolData;
import org.jgroups.conf.ProtocolParameter;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.discovery.base.DiscHelper;
import org.ow2.jonas.discovery.base.comm.ClusterdDiscoveryEvent;
import org.ow2.jonas.discovery.base.comm.DiscEvent;
import org.ow2.jonas.discovery.base.comm.DiscGreeting;
import org.ow2.jonas.discovery.jgroups.utils.Data;
import org.ow2.jonas.discovery.jgroups.utils.DiscoveryUtils;
import org.ow2.jonas.discovery.jgroups.utils.IDiscoveryChannel;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.util.Log;
import org.ow2.util.cluster.jgroups.ConnectionManager;
import org.ow2.util.cluster.jgroups.IChannel;
import org.ow2.util.cluster.jgroups.JChannelWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JGroupsDiscoveryUtils
extends DiscHelper {
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.discovery");
    public static boolean duplicateExceptionName = false;
    private static final String DEFAULT_GROUP_NAME_KEY = "jonas.discovery.jgroups.group.name";
    private static final String DAFAULT_GROUP_NAME = "jgroups-discovery";
    public static final String JGROUPS_CONFIG_PROPERTY = "jonas.service.discovery.jgroups.conf";
    public static final String DEFAULT_STACK_FILENAME = "jgroups-discovery.xml";
    public static final String DEFAULT_JONAS_NAME = "jonas";
    public static final String DEFAULT_DOMAIN_NAME = "jonas";
    public static final String DEFAULT_SERVER_ID = "jonas";
    public static final String DISCOVERY_GREETING_PORT_DEFAULT = "9080";
    public static final String DISCOVERY_GREETING_IP = "localhost";
    public static final String DISCOVERY_PROTOCOL_VERSION = "1.3";
    public static final String DISCOVERY_GREETING_TIMEOUT_DEFAULT = "5000";
    public static final String DISCOVERY_IS_MASTER = "MASTER";
    public static final String DISCOVERY_IS_SLAVE = "SLAVE";
    public static final String DISCOVERY_IS_CLUSTERD = "CLUSTERD";
    private static final String FD_PROTOCOL = "FD";
    private static final String FD_TIMEOUT = "timeout";
    private static final String COMM_TTL = "ip_ttl";
    private static final String COMM_MCAST_ADDRESS = "mcast_addr";
    private static final String COMM_MCAST_PORT = "mcast_port";
    public static final String DEF_GROUP_NAME = "JGroupsDiscovery";
    private static DiscoveryUtils unique = null;

    public static void init(String srvName, String domain, String discoveryType, String confFileName, String discoveryGroup, MBeanServer beanServer, String[] connUrls, long reconnectionTimeout) throws Throwable {
        try {
            unique = unique == null ? new DiscoveryUtils() : unique;
            unique.setGroupName(discoveryGroup);
            unique = new DiscoveryUtils();
            unique.setUrls(connUrls);
            unique.setJonasName(srvName);
            unique.setDomainName(domain);
            unique.setServerId(connUrls.toString());
            unique.setDiscType(discoveryType);
            URL confile = null;
            try {
                File conf = new File(JProp.getJonasBase(), "conf");
                confile = new File(conf, confFileName).toURL();
                if (confile == null) {
                    logger.log(BasicLevel.DEBUG, (Object)(" Unable to get JGroups stack file named: " + confFileName + " from JONAS_BASE " + JProp.getJonasBase() + " using JProp "));
                    confile = ClassLoader.getSystemClassLoader().getResource(confFileName);
                    if (confile == null) {
                        logger.log(BasicLevel.DEBUG, (Object)("Unable to get JGroups stack file named: " + confFileName + " from class loader: " + ClassLoader.getSystemClassLoader().getClass()));
                        confile = Thread.currentThread().getContextClassLoader().getResource(confFileName);
                        if (confile == null) {
                            logger.log(BasicLevel.DEBUG, (Object)(" Unable to get JGroups stack file named: " + confFileName + " from class loader: " + Thread.currentThread().getContextClassLoader().getClass()));
                            logger.log(BasicLevel.DEBUG, (Object)(" Load default stack file : jgroups-discovery.xml with class loader " + JGroupsDiscoveryUtils.class.getClassLoader().getClass().getName()));
                            confile = JGroupsDiscoveryUtils.class.getResource(unique.getConfigurationFile());
                            logger.log(BasicLevel.INFO, (Object)"Default JGroups stack file retrieved successfully");
                        } else {
                            logger.log(BasicLevel.DEBUG, (Object)(" JGroups stack file named: " + confFileName + " successfully retrieved from class loader: " + Thread.currentThread().getContextClassLoader().getClass()));
                        }
                    } else {
                        logger.log(BasicLevel.DEBUG, (Object)(" JGroups stack file named: " + confFileName + " successfully retrieved from class loader: " + ClassLoader.getSystemClassLoader().getClass()));
                    }
                } else {
                    logger.log(BasicLevel.DEBUG, (Object)("JGroups stack file named: " + confFileName + " successfully retrieved from JONAS_BASE " + JProp.getJonasBase() + " using JProp "));
                }
                unique.setConfigurationFile(confile.getFile());
            }
            catch (Throwable e1) {
                e1.printStackTrace();
                logger.log(BasicLevel.ERROR, (Object)"Unable to get communication protocol configuration: ", e1);
                throw e1;
            }
            try {
                unique.setStackConfigurator(ConfiguratorFactory.getStackConfigurator((String)unique.getConfigurationFile()));
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)" Unable to get JGroups stack configuration: \n", (Throwable)e);
                throw e;
            }
            try {
                JChannelWrapper channel = new JChannelWrapper(unique.getStackConfigurator().getProtocolStackString());
                channel.setOpt(3, (Object)false);
                channel.setOpt(5, (Object)true);
                channel.connect(unique.getGroupName());
                ConnectionManager invocationHandler = new ConnectionManager(reconnectionTimeout, (Object)channel, IDiscoveryChannel.class);
                channel.addChannelListener((ChannelListener)invocationHandler);
                IChannel chan = (IChannel)Proxy.newProxyInstance(IChannel.class.getClassLoader(), new Class[]{IChannel.class}, (InvocationHandler)invocationHandler);
                unique.setComChannel(chan);
                logger.log(BasicLevel.DEBUG, (Object)(" JGroups channel created from file " + confFileName + " successfully connected: \n"));
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)" Unable to connect JGroups channel: \n", (Throwable)e);
                throw e;
            }
            try {
                JGroupsDiscoveryUtils.getCommProtocolConf(unique.getStackConfigurator());
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)" Unable to get communication protocol \n", (Throwable)e);
                throw e;
            }
            try {
                unique.setGreetingAckTimeOut(new Integer((String)JGroupsDiscoveryUtils.getParamValueForProtoParam(JGroupsDiscoveryUtils.getProtocolParam(unique.getStackConfigurator(), FD_PROTOCOL), FD_TIMEOUT)));
            }
            catch (Exception e) {
                logger.log(BasicLevel.DEBUG, (Object)" Unable to get greeting ack timeout from JGroups configuration file \n");
                logger.log(BasicLevel.INFO, (Object)" Greeting ack timeout is set to default value :5000");
            }
            try {
                unique.setTtl(new Integer(JGroupsDiscoveryUtils.getParamValueForCommParam(COMM_TTL)));
            }
            catch (Exception e) {
                logger.log(BasicLevel.DEBUG, (Object)" Unable to get IP ttl from stack configuration \n");
                logger.log(BasicLevel.INFO, (Object)(" IP ttl is set to " + unique.getTtl()));
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)" Cannot get file named jgroups-discovery.xml in current environment");
            return;
        }
    }

    public static DiscGreeting createDiscGreeting(boolean startup) throws UnknownHostException {
        return new DiscGreeting(unique.getComChannel().getLocalAddress().toString(), unique.getDiscPort().intValue(), unique.getJonasName(), unique.getDomainName(), startup, unique.getServerId());
    }

    private static void getCommProtocolConf(ProtocolStackConfigurator stackconfigurator) throws Exception {
        ProtocolData[] proto = stackconfigurator.getProtocolStack();
        try {
            boolean stop = false;
            int i = 0;
            while (!stop && i < proto.length) {
                String protoName = proto[i].getProtocolName();
                if (protoName.equals("UDP") || protoName.equals("TCP")) {
                    stop = true;
                    unique.setCommProtoName(protoName);
                    unique.setCommProtoParams(proto[i].getParameters());
                    continue;
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new Exception("Unable to get value for parameter. Current stack is: " + stackconfigurator + " Following exceptions occurred " + e);
        }
    }

    private static HashMap<?, ?> getProtocolParam(ProtocolStackConfigurator stackconfigurator, String protocolName) throws Exception {
        ProtocolData[] proto = stackconfigurator.getProtocolStack();
        HashMap protoConf = null;
        try {
            boolean stop = false;
            int i = 0;
            while (!stop && i < proto.length) {
                String protoName = proto[i].getProtocolName();
                if (protoName.equals(protocolName)) {
                    stop = true;
                    protoConf = proto[i].getParameters();
                    continue;
                }
                ++i;
            }
            if (!stop) {
                throw new Exception("The " + protocolName + " protocol is not defined in jgroups stack. Current stack configuration is: " + stackconfigurator);
            }
        }
        catch (Exception e) {
            throw new Exception("Unable to get configuration for " + protocolName + " protocol. Current stack is " + stackconfigurator + ". Following exception occurred " + e);
        }
        return protoConf;
    }

    private static String getParamValueForCommParam(String paramName) throws Exception {
        ProtocolParameter ret = (ProtocolParameter)unique.getCommProtoParams().get(paramName);
        if (ret == null) {
            logger.log(BasicLevel.DEBUG, (Object)("Cannot get value for communication parameter " + paramName));
            throw new Exception("Cannot get value for communication parameter " + paramName);
        }
        return ret.getValue();
    }

    private static Object getParamValueForProtoParam(HashMap<?, ?> protoConf, String paramName) throws Exception {
        ProtocolParameter ret = (ProtocolParameter)protoConf.get(paramName);
        if (ret == null) {
            logger.log(BasicLevel.DEBUG, (Object)(" Can't get value for communication parameter " + paramName));
            throw new Exception(" Can't get value for parameter " + paramName);
        }
        return ret.getValue();
    }

    public static Object bytesToObject(Data data) throws IOException, ClassNotFoundException {
        if (data.getType() == Data.DISC_GREETING) {
            return data.getPayload();
        }
        if (data.getType() == Data.DISC_EVENT) {
            return data.getPayload();
        }
        if (data.getType() == Data.DISC_MESSAGE) {
            return data.getPayload();
        }
        logger.log(BasicLevel.DEBUG, (Object)"Undefined type of message received by JGroups discovery \n");
        logger.log(BasicLevel.DEBUG, (Object)("Expected type are\n " + Data.DISC_GREETING + ": DISC_GREETING\n" + Data.DISC_EVENT + ": DISC_EVENT\n" + Data.DISC_MESSAGE + ": DISC_MESSAGE\n But received: " + data.getType()));
        return null;
    }

    public static Data objectToBytes(Serializable obj) throws IOException {
        if (obj instanceof DiscEvent) {
            return new Data(Data.DISC_EVENT, obj);
        }
        if (obj instanceof DiscGreeting) {
            return new Data(Data.DISC_GREETING, obj);
        }
        return new Data(Data.DISC_MESSAGE, obj);
    }

    public static DiscEvent createNotifMessage(String state) throws Exception {
        logger.log(BasicLevel.DEBUG, (Object)("Creating a discovery notification with state:" + state + " \n"));
        if (!state.equals("running") && !state.equals("starting up")) {
            unique.setUrls(null);
        }
        DiscEvent resp = new DiscEvent(unique.getLocalAddress().getIpAddress().toString(), unique.getDiscPort().intValue(), unique.getJonasName(), unique.getDomainName(), unique.getServerId(), unique.getUrls(), unique.getDiscType().equals(DISCOVERY_IS_MASTER));
        resp.setState(state);
        logger.log(BasicLevel.DEBUG, (Object)" Discovery notification successfully created. \n");
        return resp;
    }

    public static DiscEvent createNotifMessageForClusterd(String state) throws Exception {
        logger.log(BasicLevel.DEBUG, (Object)"Cluster daemon is creating a discovery notification on startup \n");
        if (!state.equals("running") && !state.equals("starting up")) {
            unique.setUrls(null);
        }
        ClusterdDiscoveryEvent resp = new ClusterdDiscoveryEvent(unique.getLocalAddress().getIpAddress().toString(), unique.getDiscPort(), unique.getJonasName(), unique.getDomainName(), unique.getServerId(), unique.getUrls());
        resp.setState(state);
        resp.setDiscoveryMaster(unique.getDiscType().equals(DISCOVERY_IS_MASTER));
        logger.log(BasicLevel.DEBUG, (Object)"Cluster daemon has successfully created a discovery notification on startup \n");
        return resp;
    }

    public static synchronized void send(Address dest, Serializable msg) throws Exception {
        String destString = null;
        try {
            destString = dest == null ? " All members " : dest.toString();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" My name is " + unique.getJonasName() + " Sending a message to " + destString));
            }
            unique.getComChannel().send(dest, (Address)unique.getLocalAddress(), msg);
        }
        catch (ChannelClosedException e) {
            logger.log(BasicLevel.DEBUG, (Object)(" Channel closed report when sending a message to " + destString + "\n"), (Throwable)e);
            throw new Exception(" Channel closed report when sending a message to  " + destString + "\n" + (Object)((Object)e));
        }
    }

    public static void closeChannel() {
        if (unique.getComChannel() != null && unique.getComChannel().isOpen()) {
            unique.getComChannel().close();
        }
    }

    public static String getMulticastAddress() throws Exception {
        return JGroupsDiscoveryUtils.getParamValueForCommParam(COMM_MCAST_ADDRESS);
    }

    public static String getMulticastPort() throws Exception {
        return JGroupsDiscoveryUtils.getParamValueForCommParam(COMM_MCAST_PORT);
    }

    public static DiscoveryUtils getInstance() {
        return unique;
    }
}

