/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.List;
import org.apache.camel.Processor;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderSupport;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

public class ErrorHandlerBuilderRef
extends ErrorHandlerBuilderSupport {
    public static final String DEFAULT_ERROR_HANDLER_BUILDER = "CamelDefaultErrorHandlerBuilder";
    private final String ref;
    private ErrorHandlerBuilder handler;
    private boolean supportTransacted;

    public ErrorHandlerBuilderRef(String ref) {
        this.ref = ref;
    }

    public void addErrorHandlers(OnExceptionDefinition exception) {
        if (this.handler != null) {
            this.handler.addErrorHandlers(exception);
        }
        super.addErrorHandlers(exception);
    }

    public Processor createErrorHandler(RouteContext routeContext, Processor processor) throws Exception {
        if (this.handler == null) {
            this.handler = this.lookupErrorHandlerBuilder(routeContext);
        }
        return this.handler.createErrorHandler(routeContext, processor);
    }

    public boolean isErrorHandlerBuilderConfigued() {
        return !DEFAULT_ERROR_HANDLER_BUILDER.equals(this.getRef());
    }

    public boolean supportTransacted() {
        return this.supportTransacted;
    }

    public ErrorHandlerBuilder lookupErrorHandlerBuilder(RouteContext routeContext) {
        if (this.handler == null) {
            if (!this.isErrorHandlerBuilderConfigued()) {
                ErrorHandlerBuilderRef other;
                this.handler = routeContext.getRoute().getErrorHandlerBuilder();
                if (this.handler == null) {
                    this.handler = routeContext.lookup(routeContext.getRoute().getErrorHandlerRef(), ErrorHandlerBuilder.class);
                }
                if (this.handler == null) {
                    this.handler = new DefaultErrorHandlerBuilder();
                }
                if (this.handler instanceof ErrorHandlerBuilderRef && !(other = (ErrorHandlerBuilderRef)this.handler).isErrorHandlerBuilderConfigued()) {
                    this.handler = new DefaultErrorHandlerBuilder();
                    this.handler.setErrorHandlers(other.getErrorHandlers());
                }
            } else {
                this.handler = routeContext.lookup(this.ref, ErrorHandlerBuilder.class);
            }
            ObjectHelper.notNull(this.handler, "error handler '" + this.ref + "'");
            this.supportTransacted = this.handler.supportTransacted();
            List<OnExceptionDefinition> list = this.getErrorHandlers();
            for (OnExceptionDefinition exceptionType : list) {
                this.handler.addErrorHandlers(exceptionType);
            }
        }
        return this.handler;
    }

    public String getRef() {
        return this.ref;
    }

    public String toString() {
        return "ErrorHandlerBuilderRef[" + this.ref + "]";
    }
}

