/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.scan;

import java.util.HashSet;
import java.util.Set;
import org.apache.camel.spi.PackageScanFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignableToPackageScanFilter
implements PackageScanFilter {
    private final Set<Class> parents = new HashSet<Class>();

    public AssignableToPackageScanFilter() {
    }

    public AssignableToPackageScanFilter(Class parentType) {
        this.parents.add(parentType);
    }

    public AssignableToPackageScanFilter(Set<Class> parents) {
        this.parents.addAll(parents);
    }

    public void addParentType(Class parentType) {
        this.parents.add(parentType);
    }

    @Override
    public boolean matches(Class type) {
        if (this.parents != null && this.parents.size() > 0) {
            for (Class parent : this.parents) {
                if (!parent.isAssignableFrom(type)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Class parent : this.parents) {
            sb.append(parent.getSimpleName()).append(", ");
        }
        sb.setLength(sb.length() > 0 ? sb.length() - 2 : 0);
        return "is assignable to any of " + sb;
    }
}

