/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.perseus.concurrency.pessimistic;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.perseus.concurrency.api.ConcurrencyException;
import org.objectweb.perseus.concurrency.api.ConcurrencyManager;
import org.objectweb.perseus.concurrency.pessimistic.Lock;
import org.objectweb.perseus.concurrency.pessimistic.MutexLock;
import org.objectweb.perseus.concurrency.pessimistic.PessimisticConcurrencyManagerAC;
import org.objectweb.perseus.concurrency.pessimistic.RWFifoLock;
import org.objectweb.perseus.concurrency.pessimistic.RWPri2RLock;
import org.objectweb.perseus.dependency.api.DependencyGraph;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class PessimisticConcurrencyManager
implements ConcurrencyManager,
BindingController,
PessimisticConcurrencyManagerAC,
LifeCycleController {
    public static final short POLICY_UNDEFINED = 0;
    public static final short POLICY_MUTEX = 1;
    public static final short POLICY_RW_PRIORITY2READERS = 2;
    public static final short POLICY_RW_FIFO = 3;
    public static final String[] policyStringVal = new String[]{"POLICY_UNDEFINED", "POLICY_MUTEX", "POLICY_RW_PRIORITY2READERS", "POLICY_RW_FIFO"};
    public static final String DEPENDENCY_GRAPH_BINDING = "dependency-graph";
    private String state = "STOPPED";
    private short policy = (short)3;
    private static final short POLICY_LAST = 3;
    protected Map locks;
    protected DependencyGraph dg = null;
    protected Map contextInfos;
    protected Logger logger = null;
    protected boolean thinLockAllowed = true;

    public String[] listFc() {
        return new String[]{DEPENDENCY_GRAPH_BINDING};
    }

    public Object lookupFc(String s) throws NoSuchInterfaceException {
        if (DEPENDENCY_GRAPH_BINDING.equals(s)) {
            return this.dg;
        }
        throw new NoSuchInterfaceException(s);
    }

    public void bindFc(String s, Object o) throws IllegalBindingException, NoSuchInterfaceException {
        block5: {
            try {
                if ("logger".equals(s)) {
                    this.logger = (Logger)o;
                    break block5;
                }
                if (DEPENDENCY_GRAPH_BINDING.equals(s)) {
                    if (this.dg != null) {
                        throw new IllegalBindingException(s + ": Already bound");
                    }
                    this.dg = (DependencyGraph)o;
                    break block5;
                }
                throw new NoSuchInterfaceException(s);
            }
            catch (ClassCastException e) {
                throw new IllegalBindingException(s + ":" + e.getMessage());
            }
        }
    }

    public void unbindFc(String s) throws NoSuchInterfaceException {
        if (!DEPENDENCY_GRAPH_BINDING.equals(s)) {
            throw new NoSuchInterfaceException(s);
        }
        this.dg = null;
    }

    public String getFcState() {
        return this.state;
    }

    public void startFc() throws IllegalLifeCycleException {
        if (this.state == "STARTED") {
            return;
        }
        this.locks = new HashMap();
        this.contextInfos = new HashMap();
        this.state = "STARTED";
        switch (this.policy) {
            case 1: {
                this.logger.log(BasicLevel.INFO, (Object)"Pessimistic Concurrency Manager runs with POLICY_MUTEX.");
                break;
            }
            case 2: {
                this.logger.log(BasicLevel.INFO, (Object)"Pessimistic Concurrency Manager runs with POLICY_RW_PRIORITY2READERS.");
                break;
            }
            case 3: {
                this.logger.log(BasicLevel.INFO, (Object)"Pessimistic Concurrency Manager runs with POLICY_RW_FIFO.");
            }
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        if (this.state == "STOPPED") {
            return;
        }
        this.contextInfos = null;
        this.locks = null;
        this.state = "STOPPED";
    }

    public void begin(Object ctx) {
        this.getContextInfo((Object)ctx).rollback = false;
    }

    public boolean validate(Object ctx) {
        ContextInfo info = (ContextInfo)this.contextInfos.get(ctx);
        return info == null || !info.rollback;
    }

    public void finalize(Object ctx) {
        this.freeLocks(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeLocks(Object ctx) {
        boolean debug;
        boolean bl = debug = this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Finalize the context: " + ctx));
        }
        Map map = this.locks;
        synchronized (map) {
            Iterator entries = this.locks.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Lock lock = (Lock)entry.getValue();
                if (!lock.close(ctx)) continue;
                this.closeLock(lock, ctx);
                entries.remove();
            }
        }
        this.contextInfos.remove(ctx);
    }

    public void closeLock(Lock lock, Object ctx) {
    }

    public void abort(Object ctx) {
        this.freeLocks(ctx);
    }

    public Object readIntention(Object ctx, Object resourceId, Object thinLock, ConcurrencyManager.ResourceProvider resProv, Object resourceHints) throws ConcurrencyException {
        Lock lock = this.getLock(resourceId, null);
        try {
            lock.readIntention(ctx);
        }
        catch (ConcurrencyException e) {
            this.getContextInfo((Object)ctx).rollback = true;
            throw e;
        }
        if (resProv == null) {
            return null;
        }
        try {
            return resProv.getResource(ctx, resourceId, resourceHints, thinLock, false, null, lock.oid);
        }
        catch (ConcurrencyException e) {
            this.removeUnavailableResource(ctx, lock);
            throw e;
        }
    }

    public Object writeIntention(Object ctx, Object resourceId, Object thinLock, ConcurrencyManager.ResourceProvider resProv, Object resourceHints) throws ConcurrencyException {
        Lock lock;
        if (this.thinLockAllowed && thinLock != null) {
            lock = this.getLock(resourceId, null);
            try {
                lock.readIntention(ctx);
            }
            catch (ConcurrencyException e) {
                this.getContextInfo((Object)ctx).rollback = true;
                throw e;
            }
            if (lock.getMax() >= 2) {
                if (resProv == null) {
                    return null;
                }
                try {
                    return resProv.getResource(ctx, resourceId, resourceHints, null, false, null, lock.oid);
                }
                catch (ConcurrencyException e) {
                    this.removeUnavailableResource(ctx, lock);
                    throw e;
                }
            }
            if (thinLock instanceof Collection) {
                Iterator it = ((Collection)thinLock).iterator();
                while (it.hasNext()) {
                    lock = this.getLock(resourceId, it.next());
                    try {
                        lock.writeIntention(ctx);
                    }
                    catch (ConcurrencyException e) {
                        this.getContextInfo((Object)ctx).rollback = true;
                        throw e;
                    }
                }
                if (resProv == null) {
                    return null;
                }
                try {
                    return resProv.getResource(ctx, resourceId, resourceHints, thinLock, false, null, lock.oid);
                }
                catch (ConcurrencyException e) {
                    this.removeUnavailableResource(ctx, lock);
                    throw e;
                }
            }
            this.logger.log(BasicLevel.WARN, (Object)("Thin locking is not applicable with this lock hints: " + thinLock + "\nNormal locking is used."));
        }
        lock = this.getLock(resourceId, this.thinLockAllowed ? thinLock : null);
        try {
            lock.writeIntention(ctx);
        }
        catch (ConcurrencyException e) {
            this.getContextInfo((Object)ctx).rollback = true;
            throw e;
        }
        if (resProv == null) {
            return null;
        }
        try {
            return resProv.getResource(ctx, resourceId, resourceHints, thinLock, false, null, lock.oid);
        }
        catch (ConcurrencyException e) {
            this.removeUnavailableResource(ctx, lock);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnavailableResource(Object ctx, Lock lock) {
        Map map = this.locks;
        synchronized (map) {
            if (lock.close(ctx)) {
                this.locks.remove(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Lock getLock(Object oid, Object hints) {
        if (this.thinLockAllowed && hints != null) {
            oid = new OID(oid, hints);
        }
        Map map = this.locks;
        synchronized (map) {
            Lock lock = (Lock)this.locks.get(oid);
            if (lock == null) {
                switch (this.policy) {
                    case 1: {
                        lock = new MutexLock(hints, this.dg);
                        break;
                    }
                    case 2: {
                        lock = new RWPri2RLock(hints, this.dg);
                        break;
                    }
                    case 3: {
                        lock = new RWFifoLock(hints, this.dg);
                    }
                }
                lock.oid = oid;
                this.locks.put(oid, lock);
                if (this.logger != null) {
                    lock.logger = this.logger;
                    if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                        this.logger.log(BasicLevel.DEBUG, (Object)("Allocate a Lock for the oid: " + oid));
                    }
                }
            }
            lock.reserve();
            return lock;
        }
    }

    protected ContextInfo getContextInfo(Object ctxt) {
        ContextInfo info = (ContextInfo)this.contextInfos.get(ctxt);
        if (info == null) {
            info = new ContextInfo();
            this.contextInfos.put(ctxt, info);
        }
        return info;
    }

    public String getPolicy() {
        return policyStringVal[this.policy];
    }

    public void setPolicy(String policy) throws IllegalLifeCycleException {
        if (!"STOPPED".equals(this.state)) {
            throw new IllegalLifeCycleException("Cannot change lock policy of started pessimistic component");
        }
        for (int p = 0; p <= 3; p = (int)((short)(p + 1))) {
            if (!policyStringVal[p].equals(policy)) continue;
            this.policy = (short)p;
            return;
        }
        throw new IllegalArgumentException("unrecognized locking policy: " + policy);
    }

    public boolean getThinkLockAllowed() {
        return this.thinLockAllowed;
    }

    public void setThinkLockAllowed(boolean val) {
        this.thinLockAllowed = val;
    }

    protected static class ContextInfo {
        public boolean rollback;

        protected ContextInfo() {
        }
    }

    private static class OID {
        public Object oid;
        public Object lockHints;

        public OID(Object _oid, Object _lockHints) {
            this.oid = _oid;
            this.lockHints = _lockHints;
        }

        public boolean equals(Object o) {
            return o instanceof OID && ((OID)o).oid.equals(this.oid) && ((OID)o).lockHints.equals(this.lockHints);
        }
    }
}

