/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.perseus.concurrency.pessimistic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.perseus.concurrency.api.ConcurrencyException;
import org.objectweb.perseus.concurrency.api.RolledBackConcurrencyException;
import org.objectweb.perseus.concurrency.pessimistic.Lock;
import org.objectweb.perseus.dependency.api.DependencyGraph;

public final class RWPri2RLock
extends Lock {
    protected Object writer = null;
    int waiter = 0;
    protected Set readers = new HashSet();

    public RWPri2RLock() {
    }

    public RWPri2RLock(Object hints, DependencyGraph dg) {
        super(hints, dg);
    }

    public synchronized void readIntention(Object ctxt) throws ConcurrencyException {
        boolean ok;
        do {
            boolean bl = ok = this.writer == null || this.writer.equals(ctxt);
            if (ok) continue;
            ++this.waiter;
            Object w = this.writer;
            try {
                if (!this.dg.addVertex(ctxt, w)) {
                    throw new RolledBackConcurrencyException("Deadlock");
                }
                this.wait();
            }
            catch (InterruptedException e) {
                throw new ConcurrencyException("Waiting of a read intention has been interupted:", e);
            }
            finally {
                --this.waiter;
                this.dg.removeVertex(ctxt, w);
            }
        } while (!ok);
        --this.reservations;
        this.readers.add(ctxt);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void writeIntention(Object ctxt) throws ConcurrencyException {
        boolean ok;
        do {
            int i;
            Object var6_7;
            int r;
            if (ok = this.writer == null ? (r = this.readers.size()) == 0 || r == 1 && this.readers.contains(ctxt) : this.writer.equals(ctxt)) continue;
            ArrayList<Object> l = new ArrayList<Object>();
            if (this.writer == null) {
                l.addAll(this.readers);
            } else {
                l.add(this.writer);
            }
            ++this.waiter;
            try {
                try {
                    for (int i2 = 0; i2 < l.size(); ++i2) {
                        if (this.dg.addVertex(ctxt, l.get(i2))) continue;
                        throw new RolledBackConcurrencyException("Deadlock");
                    }
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new ConcurrencyException("Waiting of a write intention has been interupted:", e);
                }
                var6_7 = null;
                --this.waiter;
            }
            catch (Throwable throwable) {
                var6_7 = null;
                --this.waiter;
                i = 0;
                while (true) {
                    if (i >= l.size()) {
                        throw throwable;
                    }
                    this.dg.removeVertex(ctxt, l.get(i));
                    ++i;
                }
            }
            for (i = 0; i < l.size(); ++i) {
                this.dg.removeVertex(ctxt, l.get(i));
            }
        } while (!ok);
        --this.reservations;
        this.writer = ctxt;
    }

    public synchronized boolean close(Object ctxt) {
        boolean res;
        this.readers.remove(ctxt);
        if (this.writer != null && this.writer.equals(ctxt)) {
            this.writer = null;
        }
        boolean bl = res = this.reservations == 0 && this.waiter == 0 && this.readers.isEmpty() && this.writer == null;
        if (!res) {
            this.notifyAll();
        }
        return res;
    }

    public synchronized byte getMax() {
        if (this.writer != null) {
            return 3;
        }
        if (!this.readers.isEmpty()) {
            return 1;
        }
        return 0;
    }
}

