/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.FactoryStateListener;
import org.apache.felix.ipojo.IPojoFactory;
import org.apache.felix.ipojo.MissingHandlerException;
import org.apache.felix.ipojo.UnacceptableConfiguration;
import org.apache.felix.ipojo.util.Logger;
import org.osgi.framework.BundleContext;

public class InstanceCreator
implements FactoryStateListener {
    private Logger m_logger;
    private List m_idle = new ArrayList();
    private Map m_attached = new HashMap();
    private List m_factories = new ArrayList();

    public InstanceCreator(BundleContext context) {
        this.m_logger = new Logger(context, "iPOJO Instance Creator");
    }

    synchronized void addInstance(Dictionary instance, long bundle) {
        this.m_logger.log(4, "New instance to managed, looking for " + instance.get("component"));
        ManagedInstance managed = new ManagedInstance(instance, bundle);
        for (int i = 0; i < this.m_factories.size(); ++i) {
            IPojoFactory factory = (IPojoFactory)this.m_factories.get(i);
            if (!managed.matchName(factory)) continue;
            this.m_logger.log(4, "Listen factory " + factory.getName() + " events");
            factory.addFactoryStateListener(this);
            if (factory.getState() != 1 || !managed.match(factory)) continue;
            managed.create(factory);
            ArrayList<ManagedInstance> list = (ArrayList<ManagedInstance>)this.m_attached.get(factory);
            if (list == null) {
                list = new ArrayList<ManagedInstance>();
                list.add(managed);
                this.m_attached.put(factory, list);
            } else {
                list.add(managed);
            }
            return;
        }
        this.m_idle.add(managed);
    }

    void removeInstancesFromBundle(long bundle) {
        int i;
        Set col = this.m_attached.keySet();
        Iterator iterator = col.iterator();
        ArrayList<ManagedInstance> instanceToRemove = new ArrayList<ManagedInstance>();
        ArrayList<IPojoFactory> factoryToRemove = new ArrayList<IPojoFactory>();
        while (iterator.hasNext()) {
            IPojoFactory factory = (IPojoFactory)iterator.next();
            List list = (List)this.m_attached.get(factory);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ManagedInstance managed = (ManagedInstance)list.get(i2);
                if (managed.m_bundleId != bundle) continue;
                managed.dispose();
                instanceToRemove.add(managed);
            }
            if (instanceToRemove.isEmpty()) continue;
            list.removeAll(instanceToRemove);
            if (!list.isEmpty()) continue;
            factory.removeFactoryStateListener(this);
            factoryToRemove.add(factory);
        }
        for (i = 0; i < factoryToRemove.size(); ++i) {
            this.m_attached.remove(factoryToRemove.get(i));
        }
        instanceToRemove.clear();
        for (i = 0; i < this.m_idle.size(); ++i) {
            ManagedInstance managed = (ManagedInstance)this.m_idle.get(i);
            if (managed.m_bundleId != bundle) continue;
            instanceToRemove.add(managed);
        }
        this.m_idle.removeAll(instanceToRemove);
    }

    public synchronized void addFactory(IPojoFactory factory) {
        ArrayList<ManagedInstance> createdInstances = new ArrayList<ManagedInstance>(1);
        this.m_logger.log(4, "Add the factory " + factory.getName());
        this.m_factories.add(factory);
        for (int i = 0; i < this.m_idle.size(); ++i) {
            ManagedInstance managed = (ManagedInstance)this.m_idle.get(i);
            if (!managed.matchName(factory)) continue;
            factory.addFactoryStateListener(this);
            if (factory.getState() != 1 || !managed.match(factory)) continue;
            managed.create(factory);
            ArrayList<ManagedInstance> list = (ArrayList<ManagedInstance>)this.m_attached.get(factory);
            if (list == null) {
                list = new ArrayList<ManagedInstance>();
                list.add(managed);
                this.m_attached.put(factory, list);
            } else {
                list.add(managed);
            }
            createdInstances.add(managed);
        }
        if (!createdInstances.isEmpty()) {
            this.m_idle.removeAll(createdInstances);
        }
    }

    void removeFactory(IPojoFactory factory) {
        factory.removeFactoryStateListener(this);
        this.m_factories.remove(factory);
        this.onInvalidation(factory);
        this.m_attached.remove(factory);
    }

    private void onValidation(IPojoFactory factory) {
        ArrayList<ManagedInstance> toRemove = new ArrayList<ManagedInstance>();
        for (int i = 0; i < this.m_idle.size(); ++i) {
            ManagedInstance managed = (ManagedInstance)this.m_idle.get(i);
            if (!managed.match(factory)) continue;
            managed.create(factory);
            ArrayList<ManagedInstance> list = (ArrayList<ManagedInstance>)this.m_attached.get(factory);
            if (list == null) {
                list = new ArrayList<ManagedInstance>();
                list.add(managed);
                this.m_attached.put(factory, list);
            } else {
                list.add(managed);
            }
            toRemove.add(managed);
        }
        if (!toRemove.isEmpty()) {
            this.m_idle.removeAll(toRemove);
        }
    }

    private void onInvalidation(IPojoFactory factory) {
        List instances = (List)this.m_attached.remove(factory);
        if (instances != null) {
            for (int i = 0; i < instances.size(); ++i) {
                ManagedInstance managed = (ManagedInstance)instances.get(i);
                managed.dispose();
                this.m_idle.add(managed);
            }
        }
    }

    public void stateChanged(Factory factory, int newState) {
        if (newState == 1) {
            this.m_logger.log(4, "A factory is becoming valid : " + factory.getName());
            this.onValidation((IPojoFactory)factory);
        } else {
            this.m_logger.log(4, "A factory is bocoming invalid : " + factory.getName());
            this.onInvalidation((IPojoFactory)factory);
        }
    }

    private class ManagedInstance {
        private Dictionary m_configuration;
        private long m_bundleId;
        private IPojoFactory m_factory;
        private ComponentInstance m_instance;

        ManagedInstance(Dictionary conf, long bundle) {
            this.m_configuration = conf;
            this.m_bundleId = bundle;
        }

        IPojoFactory getFactory() {
            return this.m_factory;
        }

        ComponentInstance getInstance() {
            return this.m_instance;
        }

        public boolean matchName(IPojoFactory factory) {
            String component = (String)this.m_configuration.get("component");
            return factory.getName().equals(component) || factory.getClassName().equalsIgnoreCase(component);
        }

        public boolean match(IPojoFactory factory) {
            if (this.matchName(factory) && (factory.m_isPublic || factory.getBundleContext().getBundle().getBundleId() == this.m_bundleId)) {
                try {
                    factory.checkAcceptability(this.m_configuration);
                    return true;
                }
                catch (UnacceptableConfiguration e) {
                    InstanceCreator.this.m_logger.log(1, "An instance can be bound to a matching factory, however the configuration seems unacceptable : " + e.getMessage());
                    return false;
                }
                catch (MissingHandlerException e) {
                    InstanceCreator.this.m_logger.log(1, "An instance can be bound to a matching factory, but this factory cannot be used : " + e.getMessage());
                    return false;
                }
            }
            return false;
        }

        public void create(IPojoFactory factory) {
            try {
                this.m_factory = factory;
                this.m_instance = this.m_factory.createComponentInstance(this.m_configuration);
            }
            catch (UnacceptableConfiguration e) {
                InstanceCreator.this.m_logger.log(1, "A matching factory was found for " + this.m_configuration + ", but the instantiation failed : " + e.getMessage());
            }
            catch (MissingHandlerException e) {
                InstanceCreator.this.m_logger.log(1, "A matching factory was found for " + this.m_configuration + ", but the instantiation failed : " + e.getMessage());
            }
            catch (ConfigurationException e) {
                InstanceCreator.this.m_logger.log(1, "A matching factory was found for " + this.m_configuration + ", but the instantiation failed : " + e.getMessage());
            }
        }

        public void dispose() {
            if (this.m_instance != null) {
                this.m_instance.dispose();
            }
            this.m_instance = null;
            this.m_factory = null;
        }
    }
}

