/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Converter
public final class ObjectConverter {
    private static final transient Log LOG = LogFactory.getLog(ObjectConverter.class);

    private ObjectConverter() {
    }

    public static boolean isCollection(Object value) {
        return value instanceof Collection || value != null && value.getClass().isArray();
    }

    @Converter
    public static boolean toBool(Object value) {
        Boolean answer = ObjectConverter.toBoolean(value);
        return answer != null && answer != false;
    }

    @Converter
    public static Boolean toBoolean(Object value) {
        return ObjectHelper.toBoolean(value);
    }

    @Converter
    public static Boolean toBoolean(Boolean value) {
        if (value != null) {
            return value;
        }
        return Boolean.FALSE;
    }

    @Converter
    public static Iterator iterator(Object value) {
        return ObjectHelper.createIterator(value);
    }

    @Converter
    public static Byte toByte(Object value) {
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.byteValue();
        }
        if (value instanceof String) {
            return Byte.valueOf((String)value);
        }
        return null;
    }

    @Converter
    public static byte[] toByteArray(String value, Exchange exchange) {
        String charsetName;
        byte[] bytes = null;
        if (exchange != null && (charsetName = exchange.getProperty("CamelCharsetName", String.class)) != null) {
            try {
                bytes = value.getBytes(charsetName);
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn((Object)("Cannot convert the byte to String with the charset " + charsetName), (Throwable)e);
            }
        }
        if (bytes == null) {
            bytes = value.getBytes();
        }
        return bytes;
    }

    @Converter
    public static char[] toCharArray(String value) {
        return value.toCharArray();
    }

    @Converter
    public static String fromCharArray(char[] value) {
        return new String(value);
    }

    @Converter
    public static Short toShort(Object value) {
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.shortValue();
        }
        if (value instanceof String) {
            return Short.valueOf((String)value);
        }
        return null;
    }

    @Converter
    public static Integer toInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        return null;
    }

    @Converter
    public static Long toLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.longValue();
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        return null;
    }

    @Converter
    public static Float toFloat(Object value) {
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return Float.valueOf(number.floatValue());
        }
        if (value instanceof String) {
            return Float.valueOf((String)value);
        }
        return null;
    }

    @Converter
    public static Double toDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        if (value instanceof String) {
            return Double.valueOf((String)value);
        }
        return null;
    }

    @Converter
    public static String toString(Integer value) {
        return value.toString();
    }

    @Converter
    public static String toString(Long value) {
        return value.toString();
    }

    @Converter
    public static String toString(Boolean value) {
        return value.toString();
    }
}

