/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ProducerCallback;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.ServicePool;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerCache
extends ServiceSupport {
    private static final transient Log LOG = LogFactory.getLog(ProducerCache.class);
    private final Map<String, Producer> producers;
    private final ServicePool<Endpoint, Producer> pool;

    public ProducerCache(ServicePool<Endpoint, Producer> producerServicePool) {
        this.pool = producerServicePool;
        this.producers = new LRUCache<String, Producer>(1000);
    }

    public ProducerCache(ServicePool<Endpoint, Producer> producerServicePool, Map<String, Producer> cache) {
        this.pool = producerServicePool;
        this.producers = cache;
    }

    public Producer getProducer(Endpoint endpoint) {
        return this.doGetProducer(endpoint, false);
    }

    public void send(Endpoint endpoint, Exchange exchange) {
        try {
            this.sendExchange(endpoint, null, null, exchange);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    public Exchange send(Endpoint endpoint, Processor processor) {
        try {
            return this.sendExchange(endpoint, null, processor, null);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    public Exchange send(Endpoint endpoint, ExchangePattern pattern, Processor processor) {
        try {
            return this.sendExchange(endpoint, pattern, processor, null);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doInProducer(Endpoint endpoint, Exchange exchange, ExchangePattern pattern, ProducerCallback<T> callback) throws Exception {
        Producer producer = this.doGetProducer(endpoint, true);
        if (producer == null) {
            if (this.isStopped()) {
                LOG.warn((Object)("Ignoring exchange sent after processor is stopped: " + exchange));
                return null;
            }
            throw new IllegalStateException("No producer, this processor has not been started: " + this);
        }
        try {
            T t = callback.doInProducer(producer, exchange, pattern);
            return t;
        }
        finally {
            if (producer instanceof ServicePoolAware) {
                this.pool.release(endpoint, producer);
            } else if (!producer.isSingleton()) {
                producer.stop();
            }
        }
    }

    protected Exchange sendExchange(final Endpoint endpoint, ExchangePattern pattern, final Processor processor, Exchange exchange) throws Exception {
        return this.doInProducer(endpoint, exchange, pattern, new ProducerCallback<Exchange>(){

            @Override
            public Exchange doInProducer(Producer producer, Exchange exchange, ExchangePattern pattern) throws Exception {
                if (exchange == null) {
                    Exchange exchange2 = exchange = pattern != null ? producer.createExchange(pattern) : producer.createExchange();
                }
                if (processor != null) {
                    processor.process(exchange);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(">>>> " + endpoint + " " + exchange));
                }
                producer.process(exchange);
                return exchange;
            }
        });
    }

    protected synchronized Producer doGetProducer(Endpoint endpoint, boolean pooled) {
        String key = endpoint.getEndpointUri();
        Producer answer = this.producers.get(key);
        if (pooled && answer == null) {
            answer = this.pool.acquire(endpoint);
        }
        if (answer == null) {
            try {
                answer = endpoint.createProducer();
                answer.start();
            }
            catch (Exception e) {
                throw new FailedToCreateProducerException(endpoint, (Throwable)e);
            }
            if (pooled && answer instanceof ServicePoolAware) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding to producer service pool with key: " + endpoint + " for producer: " + answer));
                }
                answer = this.pool.addAndAcquire(endpoint, answer);
            } else if (answer.isSingleton()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding to producer cache with key: " + endpoint + " for producer: " + answer));
                }
                this.producers.put(key, answer);
            }
        }
        return answer;
    }

    @Override
    protected void doStop() throws Exception {
        this.producers.clear();
        ServiceHelper.stopServices(this.pool);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.pool);
    }

    int size() {
        return this.producers.size();
    }
}

