/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.discovery.internal.comm;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.discovery.base.comm.DiscGreeting;
import org.ow2.jonas.discovery.base.comm.DiscMessage;
import org.ow2.jonas.discovery.internal.comm.DiscoveryGreetingResponder;
import org.ow2.jonas.discovery.internal.manager.DiscoveryManager;
import org.ow2.jonas.discovery.internal.utils.DiscoveryHelper;
import org.ow2.jonas.lib.util.Log;

public class DiscoveryGreetingListener
extends DiscoveryGreetingResponder {
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.discovery");
    private int mesgsSameServerIDCount = 0;

    public DiscoveryGreetingListener(DiscoveryManager dm) {
        super(dm);
    }

    public void run() {
        this.mesgsSameServerIDCount = 0;
        this.join();
        try {
            this.unicastSocket = new DatagramSocket();
        }
        catch (SocketException e3) {
            logger.log(BasicLevel.ERROR, (Object)"Socket exception", (Throwable)e3);
            return;
        }
        try {
            while (this.notStopped) {
                DatagramPacket datagram = null;
                Object objReceived = null;
                try {
                    datagram = this.getDatagram(1024);
                    this.multicastSocket.receive(datagram);
                    objReceived = DiscoveryHelper.bytesToObject((byte[])datagram.getData());
                }
                catch (RuntimeException e) {
                    logger.log(BasicLevel.DEBUG, (Object)("Host received other packet than DataGramSocket packet. That caused following Exception: \n" + e));
                    objReceived = null;
                }
                catch (IOException e) {
                    logger.log(BasicLevel.DEBUG, (Object)("Host received other packet than DataGramSocket packet. That caused following Exception: \n" + e));
                    objReceived = null;
                }
                if (objReceived != null && objReceived instanceof DiscGreeting) {
                    DiscGreeting request = (DiscGreeting)objReceived;
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("DiscGreeting received on multicast:\n" + request));
                    }
                    if (request != null && request.getServerId().equals(this.serverId) && request.getDomainName().equals(this.domainName)) {
                        ++this.mesgsSameServerIDCount;
                        if (this.mesgsSameServerIDCount > 1) {
                            InetAddress destAddress = datagram.getAddress();
                            int destPort = request.getSourcePort();
                            DiscGreeting msg = this.createDiscGreeting(false);
                            this.sendResponse((DiscMessage)msg, destAddress, destPort);
                        }
                    }
                }
                datagram = null;
            }
        }
        catch (ClassNotFoundException e) {
            logger.log(BasicLevel.ERROR, (Object)e);
        }
    }

    public void stop() {
        Thread.interrupted();
    }
}

