/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.component.dataset.DataSet;
import org.apache.camel.component.dataset.DataSetConsumer;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.ThroughputLogger;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSetEndpoint
extends MockEndpoint
implements Service {
    private final transient Log log;
    private DataSet dataSet;
    private AtomicInteger receivedCounter = new AtomicInteger();
    private int minRate;
    private long produceDelay;
    private long consumeDelay;
    private long preloadSize;
    private Processor reporter;

    public DataSetEndpoint() {
        this.log = LogFactory.getLog(DataSetEndpoint.class);
    }

    public DataSetEndpoint(String endpointUri, Component component, DataSet dataSet) {
        super(endpointUri, component);
        this.dataSet = dataSet;
        this.log = LogFactory.getLog((String)endpointUri);
    }

    public DataSetEndpoint(String endpointUri, DataSet dataSet) {
        super(endpointUri);
        this.dataSet = dataSet;
        this.log = LogFactory.getLog((String)endpointUri);
    }

    public static void assertEquals(String description, Object expected, Object actual, Exchange exchange) {
        if (!ObjectHelper.equal(expected, actual)) {
            throw new AssertionError((Object)(description + " does not match. Expected: " + expected + " but was: " + actual + " on " + exchange + " with headers: " + exchange.getIn().getHeaders()));
        }
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new DataSetConsumer(this, processor);
    }

    public void reset() {
        super.reset();
        this.receivedCounter.set(0);
    }

    public int getReceivedCounter() {
        return this.receivedCounter.get();
    }

    public Exchange createExchange(long messageIndex) throws Exception {
        Exchange exchange = this.createExchange();
        this.getDataSet().populateMessage(exchange, messageIndex);
        Message in = exchange.getIn();
        in.setHeader("CamelDataSetIndex", messageIndex);
        return exchange;
    }

    public int getMinRate() {
        return this.minRate;
    }

    public void setMinRate(int minRate) {
        this.minRate = minRate;
    }

    protected void waitForCompleteLatch(long timeout) throws InterruptedException {
        super.waitForCompleteLatch(timeout);
        if (this.minRate > 0) {
            int count = this.getReceivedCounter();
            do {
                super.waitForCompleteLatch(1000L);
            } while ((count = this.getReceivedCounter() - count) >= this.minRate);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public long getPreloadSize() {
        return this.preloadSize;
    }

    public void setPreloadSize(long preloadSize) {
        this.preloadSize = preloadSize;
    }

    public long getConsumeDelay() {
        return this.consumeDelay;
    }

    public void setConsumeDelay(long consumeDelay) {
        this.consumeDelay = consumeDelay;
    }

    public long getProduceDelay() {
        return this.produceDelay;
    }

    public void setProduceDelay(long produceDelay) {
        this.produceDelay = produceDelay;
    }

    public void setReporter(Processor reporter) {
        this.reporter = reporter;
    }

    protected void performAssertions(Exchange actual) throws Exception {
        int receivedCount = this.receivedCounter.incrementAndGet();
        long index = receivedCount - 1;
        Exchange expected = this.createExchange(index);
        if (this.log.isDebugEnabled()) {
            Integer dsi = actual.getIn().getHeader("CamelDataSetIndex", Integer.class);
            this.log.debug((Object)("Received message: " + index + " (DataSet index=" + dsi + ") = " + actual));
        }
        this.assertMessageExpected(index, expected, actual);
        if (this.reporter != null) {
            this.reporter.process(actual);
        }
        if (this.consumeDelay > 0L) {
            Thread.sleep(this.consumeDelay);
        }
    }

    protected void assertMessageExpected(long index, Exchange expected, Exchange actual) throws Exception {
        long actualCounter = ExchangeHelper.getMandatoryHeader(actual, "CamelDataSetIndex", Long.class);
        DataSetEndpoint.assertEquals("Header: CamelDataSetIndex", index, actualCounter, actual);
        this.getDataSet().assertMessageExpected(this, expected, actual, index);
    }

    protected ThroughputLogger createReporter() {
        ThroughputLogger answer = new ThroughputLogger(this.getEndpointUri(), (int)this.getDataSet().getReportCount());
        answer.setAction("Received");
        return answer;
    }

    public void start() throws Exception {
        long size = this.getDataSet().getSize();
        this.expectedMessageCount((int)size);
        if (this.reporter == null) {
            this.reporter = this.createReporter();
        }
        this.log.info((Object)("Start: " + this + " expecting " + size + " messages"));
    }

    public void stop() throws Exception {
        this.log.info((Object)("Stop: " + this));
    }
}

