/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Collection;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteService
extends ServiceSupport {
    private final DefaultCamelContext camelContext;
    private final RouteDefinition routeDefinition;
    private final List<RouteContext> routeContexts;
    private final Collection<Route> routes;
    private final String id;

    public RouteService(DefaultCamelContext camelContext, RouteDefinition routeDefinition, List<RouteContext> routeContexts, Collection<Route> routes) {
        this.camelContext = camelContext;
        this.routeDefinition = routeDefinition;
        this.routeContexts = routeContexts;
        this.routes = routes;
        this.id = routeDefinition.idOrCreate(camelContext.getNodeIdFactory());
    }

    public String getId() {
        return this.id;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public List<RouteContext> getRouteContexts() {
        return this.routeContexts;
    }

    public RouteDefinition getRouteDefinition() {
        return this.routeDefinition;
    }

    public Collection<Route> getRoutes() {
        return this.routes;
    }

    @Override
    protected void doStart() throws Exception {
        this.camelContext.addRouteCollection(this.routes);
        this.getLifecycleStrategy().onRoutesAdd(this.routes);
        for (Route route : this.routes) {
            List<Service> services = route.getServicesForRoute();
            for (Service service : services) {
                this.startChildService(service);
            }
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.camelContext.removeRouteCollection(this.routes);
    }

    protected LifecycleStrategy getLifecycleStrategy() {
        return this.camelContext.getLifecycleStrategy();
    }

    protected void startChildService(Service service) throws Exception {
        this.getLifecycleStrategy().onServiceAdd(this.camelContext, service);
        service.start();
        this.addChildService(service);
    }

    protected void stopChildService(Service service) throws Exception {
        service.stop();
        this.removeChildService(service);
    }
}

