/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.StreamCache;
import org.apache.camel.TypeConverter;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Converter
public final class FutureTypeConverter
implements TypeConverter {
    private static final Log LOG = LogFactory.getLog(FutureTypeConverter.class);
    private final TypeConverter converter;

    public FutureTypeConverter(TypeConverter converter) {
        this.converter = converter;
    }

    private <T> T doConvertTo(Class<T> type, Exchange exchange, Object value) throws Exception {
        if (StreamCache.class.isAssignableFrom(value.getClass())) {
            return null;
        }
        if (Future.class.isAssignableFrom(value.getClass())) {
            Object body;
            Future future = (Future)value;
            if (future.isCancelled()) {
                return null;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Getting future response");
            }
            try {
                body = future.get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw e;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Got future response");
            }
            if (body == null) {
                return null;
            }
            if (type.isAssignableFrom(body.getClass())) {
                return type.cast(body);
            }
            if (body instanceof Exchange) {
                Exchange result = (Exchange)body;
                body = ExchangeHelper.extractResultBody(result, result.getPattern());
            }
            return this.converter.convertTo(type, exchange, body);
        }
        return null;
    }

    @Override
    public <T> T convertTo(Class<T> type, Object value) {
        return this.convertTo(type, null, value);
    }

    @Override
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        try {
            return this.doConvertTo(type, exchange, value);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public <T> T mandatoryConvertTo(Class<T> type, Object value) throws NoTypeConversionAvailableException {
        return this.mandatoryConvertTo(type, null, value);
    }

    @Override
    public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange, Object value) throws NoTypeConversionAvailableException {
        T answer;
        try {
            answer = this.doConvertTo(type, exchange, value);
        }
        catch (Exception e) {
            throw new NoTypeConversionAvailableException(value, type, e);
        }
        if (answer == null) {
            throw new NoTypeConversionAvailableException(value, type);
        }
        return answer;
    }
}

