/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.Serializable;
import java.util.Random;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RedeliveryPolicy
implements Cloneable,
Serializable {
    protected static transient Random randomNumberGenerator;
    private static final transient Log LOG;
    protected long redeliverDelay = 1000L;
    protected int maximumRedeliveries;
    protected long maximumRedeliveryDelay = 60000L;
    protected double backOffMultiplier = 2.0;
    protected boolean useExponentialBackOff;
    protected double collisionAvoidanceFactor = 0.15;
    protected boolean useCollisionAvoidance;
    protected LoggingLevel retriesExhaustedLogLevel = LoggingLevel.DEBUG;
    protected LoggingLevel retryAttemptedLogLevel = LoggingLevel.DEBUG;
    protected boolean logStackTrace;
    protected String delayPattern;

    public String toString() {
        return "RedeliveryPolicy[maximumRedeliveries=" + this.maximumRedeliveries + ", redeliverDelay=" + this.redeliverDelay + ", maximumRedeliveryDelay=" + this.maximumRedeliveryDelay + ", retriesExhaustedLogLevel=" + (Object)((Object)this.retriesExhaustedLogLevel) + ", retryAttemptedLogLevel=" + (Object)((Object)this.retryAttemptedLogLevel) + ", logTraceStace=" + this.logStackTrace + ", useExponentialBackOff=" + this.useExponentialBackOff + ", backOffMultiplier=" + this.backOffMultiplier + ", useCollisionAvoidance=" + this.useCollisionAvoidance + ", collisionAvoidanceFactor=" + this.collisionAvoidanceFactor + ", delayPattern=" + this.delayPattern + "]";
    }

    public RedeliveryPolicy copy() {
        try {
            return (RedeliveryPolicy)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Could not clone: " + e, e);
        }
    }

    public boolean shouldRedeliver(Exchange exchange, int redeliveryCounter, Predicate retryUntil) {
        if (retryUntil != null) {
            return retryUntil.matches(exchange);
        }
        if (this.getMaximumRedeliveries() < 0) {
            return true;
        }
        return redeliveryCounter <= this.getMaximumRedeliveries();
    }

    public long sleep(long redeliveryDelay, int redeliveryCounter) throws InterruptedException {
        if ((redeliveryDelay = this.calculateRedeliveryDelay(redeliveryDelay, redeliveryCounter)) > 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sleeping for: " + redeliveryDelay + " millis until attempting redelivery"));
            }
            Thread.sleep(redeliveryDelay);
        }
        return redeliveryDelay;
    }

    protected long calculateRedeliveryDelay(long previousDelay, int redeliveryCounter) {
        if (ObjectHelper.isNotEmpty(this.delayPattern)) {
            return RedeliveryPolicy.calculateRedeliverDelayUsingPattern(this.delayPattern, redeliveryCounter);
        }
        long redeliveryDelay = previousDelay == 0L ? this.redeliverDelay : (this.useExponentialBackOff && this.backOffMultiplier > 1.0 ? Math.round(this.backOffMultiplier * (double)previousDelay) : previousDelay);
        if (this.useCollisionAvoidance) {
            Random random = RedeliveryPolicy.getRandomNumberGenerator();
            double variance = (random.nextBoolean() ? this.collisionAvoidanceFactor : -this.collisionAvoidanceFactor) * random.nextDouble();
            redeliveryDelay = (long)((double)redeliveryDelay + (double)redeliveryDelay * variance);
        }
        if (this.maximumRedeliveryDelay > 0L && redeliveryDelay > this.maximumRedeliveryDelay) {
            redeliveryDelay = this.maximumRedeliveryDelay;
        }
        return redeliveryDelay;
    }

    protected static long calculateRedeliverDelayUsingPattern(String delayPattern, int redeliveryCounter) {
        String[] groups = delayPattern.split(";");
        long answer = 0L;
        for (String group : groups) {
            long delay = Long.valueOf(ObjectHelper.after(group, ":"));
            int count = Integer.valueOf(ObjectHelper.before(group, ":"));
            if (count > redeliveryCounter) break;
            answer = delay;
        }
        return answer;
    }

    public RedeliveryPolicy redeliverDelay(long delay) {
        this.setRedeliverDelay(delay);
        return this;
    }

    public RedeliveryPolicy maximumRedeliveries(int maximumRedeliveries) {
        this.setMaximumRedeliveries(maximumRedeliveries);
        return this;
    }

    public RedeliveryPolicy useCollisionAvoidance() {
        this.setUseCollisionAvoidance(true);
        return this;
    }

    public RedeliveryPolicy useExponentialBackOff() {
        this.setUseExponentialBackOff(true);
        return this;
    }

    public RedeliveryPolicy backOffMultiplier(double multiplier) {
        this.useExponentialBackOff();
        this.setBackOffMultiplier(multiplier);
        return this;
    }

    public RedeliveryPolicy collisionAvoidancePercent(double collisionAvoidancePercent) {
        this.useCollisionAvoidance();
        this.setCollisionAvoidancePercent(collisionAvoidancePercent);
        return this;
    }

    public RedeliveryPolicy maximumRedeliveryDelay(long maximumRedeliveryDelay) {
        this.setMaximumRedeliveryDelay(maximumRedeliveryDelay);
        return this;
    }

    public RedeliveryPolicy retriesExhaustedLogLevel(LoggingLevel retriesExhaustedLogLevel) {
        this.setRetriesExhaustedLogLevel(retriesExhaustedLogLevel);
        return this;
    }

    public RedeliveryPolicy retryAttemptedLogLevel(LoggingLevel retryAttemptedLogLevel) {
        this.setRetryAttemptedLogLevel(retryAttemptedLogLevel);
        return this;
    }

    public RedeliveryPolicy logStackTrace(boolean logStackTrace) {
        this.setLogStackTrace(logStackTrace);
        return this;
    }

    public RedeliveryPolicy delayPattern(String delayPattern) {
        this.setDelayPattern(delayPattern);
        return this;
    }

    public RedeliveryPolicy disableRedelivery() {
        this.setMaximumRedeliveries(0);
        return this;
    }

    public long getRedeliverDelay() {
        return this.redeliverDelay;
    }

    public void setRedeliverDelay(long redeliverDelay) {
        this.redeliverDelay = redeliverDelay;
    }

    public double getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public void setBackOffMultiplier(double backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    public long getCollisionAvoidancePercent() {
        return Math.round(this.collisionAvoidanceFactor * 100.0);
    }

    public void setCollisionAvoidancePercent(double collisionAvoidancePercent) {
        this.collisionAvoidanceFactor = collisionAvoidancePercent * 0.01;
    }

    public double getCollisionAvoidanceFactor() {
        return this.collisionAvoidanceFactor;
    }

    public void setCollisionAvoidanceFactor(double collisionAvoidanceFactor) {
        this.collisionAvoidanceFactor = collisionAvoidanceFactor;
    }

    public int getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    public void setMaximumRedeliveries(int maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public long getMaximumRedeliveryDelay() {
        return this.maximumRedeliveryDelay;
    }

    public void setMaximumRedeliveryDelay(long maximumRedeliveryDelay) {
        this.maximumRedeliveryDelay = maximumRedeliveryDelay;
    }

    public boolean isUseCollisionAvoidance() {
        return this.useCollisionAvoidance;
    }

    public void setUseCollisionAvoidance(boolean useCollisionAvoidance) {
        this.useCollisionAvoidance = useCollisionAvoidance;
    }

    public boolean isUseExponentialBackOff() {
        return this.useExponentialBackOff;
    }

    public void setUseExponentialBackOff(boolean useExponentialBackOff) {
        this.useExponentialBackOff = useExponentialBackOff;
    }

    protected static synchronized Random getRandomNumberGenerator() {
        if (randomNumberGenerator == null) {
            randomNumberGenerator = new Random();
        }
        return randomNumberGenerator;
    }

    public void setRetriesExhaustedLogLevel(LoggingLevel retriesExhaustedLogLevel) {
        this.retriesExhaustedLogLevel = retriesExhaustedLogLevel;
    }

    public LoggingLevel getRetriesExhaustedLogLevel() {
        return this.retriesExhaustedLogLevel;
    }

    public void setRetryAttemptedLogLevel(LoggingLevel retryAttemptedLogLevel) {
        this.retryAttemptedLogLevel = retryAttemptedLogLevel;
    }

    public LoggingLevel getRetryAttemptedLogLevel() {
        return this.retryAttemptedLogLevel;
    }

    public String getDelayPattern() {
        return this.delayPattern;
    }

    public void setDelayPattern(String delayPattern) {
        this.delayPattern = delayPattern;
    }

    public boolean isLogStackTrace() {
        return this.logStackTrace;
    }

    public void setLogStackTrace(boolean logStackTrace) {
        this.logStackTrace = logStackTrace;
    }

    static {
        LOG = LogFactory.getLog(RedeliveryPolicy.class);
    }
}

