/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.ServiceDesc;
import fr.dyade.aaa.common.Strings;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class ServiceManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    static ServiceManager manager;
    static Logger xlogmon;
    private static String name;
    Hashtable registry = new Hashtable();

    public static final String getName() {
        if (name == null) {
            name = AgentServer.getName() + ".ServiceManager";
        }
        return name;
    }

    static void init() throws Exception {
        xlogmon = Debug.getLogger("fr.dyade.aaa.agent.Service");
        manager = ServiceManager.load();
        if (manager == null) {
            manager = new ServiceManager();
        }
    }

    static ServiceManager load() throws IOException, ClassNotFoundException {
        return (ServiceManager)AgentServer.getTransaction().load("serviceManager");
    }

    static void save() throws IOException {
        AgentServer.getTransaction().save(manager, "serviceManager");
    }

    private ServiceManager() {
    }

    public static void start(ServiceDesc desc) throws Exception {
        xlogmon.log(BasicLevel.DEBUG, (Object)(ServiceManager.getName() + " start service: " + desc));
        if (desc.running) {
            throw new Exception("Service already running");
        }
        Class[] ptypes = new Class[2];
        Object[] args = new Object[2];
        ptypes[0] = String.class;
        ptypes[1] = Boolean.TYPE;
        Class service = null;
        try {
            service = Class.forName(desc.getClassName());
        }
        catch (ClassNotFoundException cnfe) {
            service = AgentServer.getResolverRepository().resolveClass(desc.getClassName());
        }
        Method init = service.getMethod("init", ptypes);
        args[0] = desc.getArguments();
        args[1] = new Boolean(!desc.isInitialized());
        init.invoke(null, args);
        desc.running = true;
        desc.initialized = true;
        xlogmon.log(BasicLevel.DEBUG, (Object)(ServiceManager.getName() + " service started"));
    }

    static void start(String scname) throws Exception {
        ServiceDesc desc = (ServiceDesc)ServiceManager.manager.registry.get(scname);
        if (desc == null) {
            throw new NoSuchElementException("Unknown service: " + scname);
        }
        ServiceManager.start(desc);
    }

    static void start() throws Exception {
        Enumeration e = ServiceManager.manager.registry.elements();
        while (e.hasMoreElements()) {
            ServiceDesc desc = (ServiceDesc)e.nextElement();
            try {
                ServiceManager.start(desc);
            }
            catch (Exception exc) {
                xlogmon.log(BasicLevel.ERROR, (Object)(ServiceManager.getName() + ", cannot start service:" + desc.getClassName()), (Throwable)exc);
            }
        }
    }

    static void stop(ServiceDesc desc) throws Exception {
        Class service;
        if (!desc.running) {
            return;
        }
        try {
            service = Class.forName(desc.getClassName());
        }
        catch (ClassNotFoundException cnfe) {
            service = AgentServer.getResolverRepository().resolveClass(desc.getClassName());
        }
        Method stop = service.getMethod("stopService", new Class[0]);
        stop.invoke(null, new Object[0]);
        desc.running = false;
    }

    public static void stop(String scname) throws Exception {
        ServiceDesc desc = (ServiceDesc)ServiceManager.manager.registry.get(scname);
        if (desc == null) {
            throw new NoSuchElementException("Unknown service: " + scname);
        }
        ServiceManager.stop(desc);
    }

    static void stop() {
        if (manager == null || ServiceManager.manager.registry == null) {
            return;
        }
        Enumeration e = ServiceManager.manager.registry.elements();
        while (e.hasMoreElements()) {
            ServiceDesc desc = (ServiceDesc)e.nextElement();
            try {
                if (xlogmon.isLoggable(BasicLevel.DEBUG)) {
                    xlogmon.log(BasicLevel.DEBUG, (Object)(ServiceManager.getName() + ", stops: " + desc));
                }
                if (desc.running) {
                    ServiceManager.stop(desc);
                }
                if (!xlogmon.isLoggable(BasicLevel.DEBUG)) continue;
                xlogmon.log(BasicLevel.DEBUG, (Object)(ServiceManager.getName() + ", service stopped"));
            }
            catch (Throwable exc) {
                xlogmon.log(BasicLevel.WARN, (Object)(ServiceManager.getName() + ", cannot stop service: " + desc), exc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String scname, String args) {
        ServiceManager serviceManager = manager;
        synchronized (serviceManager) {
            ServiceDesc desc = (ServiceDesc)ServiceManager.manager.registry.get(scname);
            xlogmon.log(BasicLevel.DEBUG, (Object)(ServiceManager.getName() + ", register " + scname + " -> " + desc));
            if (desc == null) {
                desc = new ServiceDesc(scname, args);
                ServiceManager.manager.registry.put(scname, desc);
            } else {
                desc.args = args;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregister(String scname) {
        ServiceManager serviceManager = manager;
        synchronized (serviceManager) {
            ServiceManager.manager.registry.remove(scname);
        }
    }

    public static ServiceDesc getService(String serviceClassName) {
        return (ServiceDesc)ServiceManager.manager.registry.get(serviceClassName);
    }

    static ServiceDesc[] getServices() {
        ServiceDesc[] services = new ServiceDesc[ServiceManager.manager.registry.size()];
        int i = 0;
        Enumeration e = ServiceManager.manager.registry.elements();
        while (e.hasMoreElements()) {
            services[i++] = (ServiceDesc)e.nextElement();
        }
        return services;
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append('(');
        output.append(super.toString());
        output.append(",registry=").append(Strings.toString(this.registry));
        output.append(')');
        return output.toString();
    }

    static {
        xlogmon = null;
        name = null;
    }
}

