/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common;

public class Arrays {
    public static void sort(short[] a) {
        Arrays.sort1(a, 0, a.length);
    }

    public static void sort(short[] a, int fromIndex, int toIndex) {
        Arrays.rangeCheck(a.length, fromIndex, toIndex);
        Arrays.sort1(a, fromIndex, toIndex - fromIndex);
    }

    private static void sort1(short[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    Arrays.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Arrays.med3(x, l, l + s, l + 2 * s);
                m = Arrays.med3(x, m - s, m, m + s);
                n = Arrays.med3(x, n - 2 * s, n - s, n);
            }
            m = Arrays.med3(x, l, m, n);
        }
        short v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    Arrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    Arrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Arrays.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Arrays.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Arrays.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            Arrays.sort1(x, n - s, s);
        }
    }

    private static void swap(short[] x, int a, int b) {
        short t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(short[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Arrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(short[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void rangeCheck(int arrayLen, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLen) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    public static int binarySearch(short[] a, int key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            short midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static boolean equals(short[] a, short[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }
}

