/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import com.sun.xml.fastinfoset.stax.factory.StAXOutputFactory;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIStaxOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String FI_ENABLED = "org.apache.cxf.fastinfoset.enabled";
    boolean force;
    XMLOutputFactory factory = new StAXOutputFactory();

    public FIStaxOutInterceptor() {
        super("pre-stream");
        this.addAfter(AttachmentOutInterceptor.class.getName());
        this.addBefore(StaxOutInterceptor.class.getName());
    }

    public FIStaxOutInterceptor(boolean f) {
        this();
        this.force = f;
    }

    @Override
    protected boolean isRequestor(Message message) {
        return Boolean.TRUE.equals(message.containsKey("org.apache.cxf.client"));
    }

    @Override
    public void handleMessage(Message message) {
        String s;
        XMLStreamWriter writer = message.getContent(XMLStreamWriter.class);
        if (writer != null) {
            return;
        }
        boolean req = this.isRequestor(message);
        Object o = message.getContextualProperty(FI_ENABLED);
        if (!req) {
            if (message.getExchange().getInMessage() != null && (s = (String)message.getExchange().getInMessage().get("Accept")) != null && s.contains("fastinfoset")) {
                o = Boolean.TRUE;
            }
        } else {
            Map headers = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS));
            ArrayList<String> accepts = (ArrayList<String>)headers.get("Accept");
            if (accepts == null) {
                accepts = new ArrayList<String>();
                headers.put("Accept", accepts);
            }
            String a = "application/fastinfoset";
            if (!accepts.isEmpty()) {
                a = a + ", " + (String)accepts.get(0);
                accepts.set(0, a);
            } else {
                accepts.add(a);
            }
        }
        if (this.force || Boolean.TRUE.equals(o)) {
            message.put(XMLOutputFactory.class.getName(), this.factory);
            s = (String)message.get("Content-Type");
            if (s.contains("application/soap+xml")) {
                s = s.replace("application/soap+xml", "application/soap+fastinfoset");
                message.put("Content-Type", s);
            } else {
                message.put("Content-Type", "application/fastinfoset");
            }
        }
    }
}

