/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.wrapper;

import java.io.InputStream;
import java.util.List;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.osgi.CamelContextFactory;
import org.apache.camel.spi.Registry;
import org.ow2.jonas.camel.registry.impl.file.FileRegistryComponent;
import org.ow2.jonas.camel.registry.osgi.OSGiRegistry;
import org.ow2.jonas.camel.wrapper.ICamelWrapper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelWrapper
implements ICamelWrapper {
    private Log logger = LogFactory.getLog(this.getClass());
    private CamelContext camel = null;
    private FileRegistryComponent registry = null;
    private String name;

    public CamelWrapper(CamelContextFactory factory) {
        DefaultCamelContext ctx = factory.createContext();
        ctx.setRegistry((Registry)new OSGiRegistry(factory.getBundleContext()));
        this.camel = ctx;
    }

    public String getCamelContextName() {
        return this.camel.getName();
    }

    public void run() throws Exception {
        while (true) {
            block5: {
                try {
                    MBeanServer mBeanServer = null;
                    ObjectName j2eeServer = null;
                    for (MBeanServer o : MBeanServerFactory.findMBeanServer(null)) {
                        MBeanServer currentServer = o;
                        Set<ObjectName> j2eeServerNames = currentServer.queryNames(new ObjectName("*:j2eeType=J2EEServer,*"), null);
                        if (j2eeServerNames.size() <= 0) continue;
                        j2eeServer = j2eeServerNames.iterator().next();
                        mBeanServer = currentServer;
                        break;
                    }
                    if (mBeanServer == null) break;
                    if (mBeanServer.getAttribute(j2eeServer, "state").toString().contains("running")) {
                    }
                    break block5;
                }
                catch (AttributeNotFoundException ignored) {
                    this.logger.debug((Object)"Ignore exception {0}, as we are not in a java-EE compliant environment", new Object[]{ignored});
                }
                break;
            }
            Thread.sleep(1000L);
        }
        this.camel.start();
    }

    @Override
    public void stopContext() throws Exception {
        this.camel.stop();
    }

    @Override
    public void addRoutes(RouteBuilder builder) throws Exception {
        this.logger.debug((Object)"Adding a route to the context", new Object[0]);
        this.camel.addRoutes((RoutesBuilder)builder);
    }

    @Override
    public List<RouteDefinition> getRoutes() {
        return this.camel.getRouteDefinitions();
    }

    @Override
    public void addToTheRegistry(InputStream inputStream) throws Exception {
        if (this.registry == null) {
            this.registry = new FileRegistryComponent();
            this.addComponent("registry", this.registry);
            this.logger.debug((Object)"Registry component added", new Object[0]);
        }
        this.registry.addValues(inputStream);
    }

    @Override
    public void removeFromTheRegistry(InputStream inputStream) {
        if (this.registry == null) {
            throw new IllegalStateException("The registry has not been initiated with value yet. Removing values is therefore forbidden.");
        }
        this.registry.removeValues(inputStream);
    }

    @Override
    public ProducerTemplate getProducerTemplate() {
        return this.camel.createProducerTemplate();
    }

    @Override
    public void addComponent(String componentName, Component component) {
        component.setCamelContext(this.camel);
        this.camel.addComponent(componentName, component);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

