/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.util.DefaultAnnotationProcessor;
import org.apache.catalina.util.ServerInfo;
import org.apache.tomcat.util.digester.Digester;
import org.objectweb.util.monolog.api.BasicLevel;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.easybeans.deployment.api.EZBInjectionHolder;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDesc;
import org.ow2.jonas.jndi.checker.api.IResourceCheckerManager;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.security.SecurityService;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.tm.TransactionService;
import org.ow2.jonas.web.JWebContainerService;
import org.ow2.jonas.web.JWebContainerServiceException;
import org.ow2.jonas.web.base.BaseWebContainerService;
import org.ow2.jonas.web.base.lib.PermissionManager;
import org.ow2.jonas.web.tomcat6.CheckOpenResourcesValve;
import org.ow2.jonas.web.tomcat6.JCatalinaRuleSet;
import org.ow2.jonas.web.tomcat6.JOnASContextConfig;
import org.ow2.jonas.web.tomcat6.JOnASStandardContext;
import org.ow2.jonas.web.tomcat6.ResetAuthenticationValve;
import org.ow2.jonas.web.tomcat6.security.Realm;
import org.ow2.jonas.web.tomcat6.tx.TransactionValve;
import org.ow2.jonas.web.tomcat6.versioning.ContextFinder;
import org.ow2.jonas.web.tomcat6.ws.WSContextLifecycleListener;
import org.ow2.jonas.web.tomcat6.ws.WSDeployment;
import org.ow2.jonas.web.tomcat6.ws.WebservicesWebDeployer;
import org.ow2.jonas.ws.jaxws.IWebServiceDeploymentManager;
import org.ow2.jonas.ws.jaxws.ejb.IWebDeployer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tomcat6Service
extends BaseWebContainerService
implements JWebContainerService {
    private static Log logger = LogFactory.getLog(Tomcat6Service.class);
    protected static final String CONFIG_FILE = "conf" + File.separator + "tomcat6-server.xml";
    private Server server = null;
    private ClassLoader externalLoader = null;
    private boolean tomcatStarted = false;
    private SecurityService securityService = null;
    private BundleContext context;
    private ServiceRegistration reg;
    private ServiceRegistration reg2;
    private TransactionService transactionService = null;
    private IResourceCheckerManager resourceCheckerManager = null;

    public Tomcat6Service(BundleContext context) {
        this.context = context;
    }

    protected void initCatalinaEnvironment() throws ServiceException {
        String jonasRoot = System.getProperty("jonas.root");
        String jonasBase = System.getProperty("jonas.base");
        String catalinaHome = System.getProperty("catalina.home");
        String catalinaBase = System.getProperty("catalina.base");
        if (catalinaHome != null && !jonasRoot.equals(catalinaHome)) {
            logger.warn((Object)"The CATALINA_HOME property was set to ''{0}'', fix it by using JONAS_ROOT ''{1}''", new Object[]{catalinaHome, jonasRoot});
        }
        System.setProperty("catalina.home", jonasRoot);
        if (catalinaBase != null && !jonasBase.equals(catalinaBase)) {
            logger.warn((Object)"The CATALINA_BASE property was set to ''{0}'', fix it by using JONAS_BASE ''{1}''", new Object[]{catalinaBase, jonasBase});
        }
        System.setProperty("catalina.base", jonasBase);
        System.setProperty("catalina.useNaming", "false");
    }

    public void doStart() throws ServiceException {
        this.initCatalinaEnvironment();
        if (!this.isOnDemandFeatureEnabled()) {
            this.startInternalWebContainer();
        }
        super.doStart();
    }

    public synchronized void startInternalWebContainer() throws JWebContainerServiceException {
        if (this.tomcatStarted) {
            return;
        }
        LoaderManager lm = LoaderManager.getInstance();
        try {
            this.externalLoader = lm.getExternalLoader();
        }
        catch (Exception e1) {
            throw new ServiceException("Cannot get Application/Tomcat ClassLoader", (Throwable)e1);
        }
        ContextFinder.setParent(this);
        ContextFinder.setJmxService(this.jmxService);
        Digester digester = this.createServerDigester();
        File configFile = null;
        try {
            configFile = this.getConfigFile();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Cannot find the file ''{0}''", new Object[]{CONFIG_FILE, e});
            throw new ServiceException("Cannot find the configuration file", (Throwable)e);
        }
        try {
            InputSource is = new InputSource("file://" + configFile.getAbsolutePath());
            FileInputStream fis = new FileInputStream(configFile);
            is.setByteStream(fis);
            digester.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            digester.push((Object)this);
            digester.parse(is);
            fis.close();
        }
        catch (Exception e) {
            logger.error((Object)"Cannot parse the configuration file ''{0}''", new Object[]{configFile, e});
            throw new ServiceException("Cannot parse the configuration file '" + configFile + "'", (Throwable)e);
        }
        for (StandardEngine engine : this.getEngines()) {
            engine.setDomain(this.getDomainName());
            engine.setName(this.getDomainName());
        }
        if (this.isOnDemandFeatureEnabled()) {
            Service[] services = this.getServer().findServices();
            if (services.length > 0) {
                services[0].setName(this.getDomainName());
            }
            for (int s = 0; s < services.length; ++s) {
                Connector[] connectors = services[s].findConnectors();
                if (connectors.length < 1) continue;
                Connector connector = connectors[0];
                connector.setProperty("maxKeepAliveRequests", "1");
                connector.setPort(this.getOnDemandRedirectPort());
            }
        }
        IExecution<Void> startExec = new IExecution<Void>(){

            public Void execute() throws ServiceException {
                if (Tomcat6Service.this.server instanceof Lifecycle) {
                    try {
                        Field domainField = Tomcat6Service.this.server.getClass().getDeclaredField("domain");
                        domainField.setAccessible(true);
                        domainField.set(Tomcat6Service.this.server, Tomcat6Service.this.getDomainName());
                        Tomcat6Service.this.server.initialize();
                        domainField.set(Tomcat6Service.this.server, Tomcat6Service.this.getDomainName());
                        Service[] services = Tomcat6Service.this.getServer().findServices();
                        if (services.length > 0) {
                            services[0].setName(Tomcat6Service.this.getDomainName());
                        }
                        ((Lifecycle)((Object)Tomcat6Service.this.server)).start();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Cannot start the Tomcat server", new Object[]{e});
                        throw new ServiceException("Cannot start the Tomcat server", (Throwable)e);
                    }
                }
                return null;
            }
        };
        ExecutionResult startExecResult = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)startExec);
        if (startExecResult.hasException()) {
            logger.error((Object)"Cannot start the Tomcat server", new Object[]{startExecResult.getException()});
            throw new ServiceException("Cannot start the Tomcat Server", (Throwable)startExecResult.getException());
        }
        WSDeployment manager = new WSDeployment(this);
        manager.setWorkDirectory(WORK_DIR);
        this.reg = this.context.registerService(IWebServiceDeploymentManager.class.getName(), (Object)manager, null);
        WebservicesWebDeployer webDeployer = new WebservicesWebDeployer(this);
        webDeployer.setWorkDirectory(WORK_DIR);
        this.reg2 = this.context.registerService(IWebDeployer.class.getName(), (Object)webDeployer, null);
        this.tomcatStarted = true;
    }

    protected void setWebEnvironment(javax.naming.Context ctxParam, EZBInjectionHolder ezbInjectionHolder, ClassLoader webAppClassLoader) throws JWebContainerServiceException {
        super.setWebEnvironment(ctxParam, ezbInjectionHolder, webAppClassLoader);
        try {
            this.getNaming().getComponentContext(webAppClassLoader).bind("comp/env/BundleContext", (Object)this.context);
        }
        catch (NamingException e) {
            throw new JWebContainerServiceException("Cannot bind bundle context", (Throwable)e);
        }
    }

    public boolean isInternalContainerStarted() {
        return this.tomcatStarted;
    }

    protected void doStop() throws ServiceException {
        super.doStop();
        if (this.reg != null) {
            this.reg.unregister();
        }
        if (this.reg2 != null) {
            this.reg2.unregister();
        }
        if (this.tomcatStarted && this.server instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.server)).stop();
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage(), (Throwable)e);
            }
        }
        this.tomcatStarted = false;
    }

    protected void doRegisterWar(javax.naming.Context ctx) throws JWebContainerServiceException {
        URL warURL = null;
        URL earURL = null;
        URL unpackedWarURL = null;
        String contextRoot = null;
        boolean java2DelegationModel = true;
        PermissionManager permissionManager = null;
        boolean inEarCase = true;
        String earAppName = null;
        WebContainerDeploymentDesc webDD = null;
        String userURI = null;
        Map webservices = null;
        try {
            warURL = (URL)ctx.lookup("warURL");
            unpackedWarURL = (URL)ctx.lookup("unpackedWarURL");
            contextRoot = (String)ctx.lookup("contextRoot");
            Boolean bool = (Boolean)ctx.lookup("java2DelegationModel");
            java2DelegationModel = bool;
            webDD = (WebContainerDeploymentDesc)ctx.lookup("webDD");
            permissionManager = (PermissionManager)ctx.lookup("permissionManager");
            userURI = (String)ctx.lookup("userURI");
            webservices = (Map)ctx.lookup("webservices-metadatas");
        }
        catch (NamingException e) {
            logger.error((Object)"Unable to get default parameters", new Object[]{e});
            throw new JWebContainerServiceException("Unable to get default parameters", (Throwable)e);
        }
        EZBInjectionHolder injectionHolder = null;
        try {
            injectionHolder = (EZBInjectionHolder)ctx.lookup(EZBInjectionHolder.class.getName());
        }
        catch (NamingException e) {
            logger.debug((Object)"No injection holder", new Object[0]);
        }
        try {
            earAppName = (String)ctx.lookup("earAppName");
            earURL = (URL)ctx.lookup("earURL");
        }
        catch (NamingException e) {
            inEarCase = false;
            earURL = warURL;
        }
        ClassLoader webClassLoader = null;
        try {
            webClassLoader = (ClassLoader)ctx.lookup("parentCL");
        }
        catch (NamingException e) {
            logger.error((Object)"Unable to get parentCL parameter", new Object[]{e});
            throw new JWebContainerServiceException("Unable to get parentCL parameter", (Throwable)e);
        }
        String hostName = null;
        try {
            hostName = (String)ctx.lookup("hostName");
        }
        catch (NamingException e) {
            hostName = "";
        }
        contextRoot = contextRoot.equals("/") ? "" : "/" + contextRoot;
        File fWar = URLUtils.urlToFile((URL)warURL);
        File destDir = null;
        destDir = fWar.isDirectory() ? URLUtils.urlToFile((URL)warURL) : URLUtils.urlToFile((URL)unpackedWarURL);
        File contextXmlFile = new File(destDir, File.separator + "META-INF" + File.separator + "context.xml");
        List<JOnASStandardContext> jonasContexts = this.getConfiguredMatchingJonasContexts(contextRoot, fWar, destDir.getPath());
        Host deployer = null;
        if (jonasContexts.isEmpty()) {
            deployer = this.findHost(hostName);
            JOnASStandardContext context = new JOnASStandardContext(false, java2DelegationModel, inEarCase);
            context.setDocBase(destDir.getPath());
            context.setPath(contextRoot);
            ContextConfig config = this.createContextConfig();
            context.addLifecycleListener(config);
            jonasContexts.add(context);
        }
        for (JOnASStandardContext jStdCtx : jonasContexts) {
            jStdCtx.setTomcatService(this);
            jStdCtx.setParentClassLoader(webClassLoader);
            jStdCtx.setDelegate(java2DelegationModel);
            if (Tomcat6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                Tomcat6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Webapp class loader java 2 delegation model set to " + java2DelegationModel));
            }
            jStdCtx.addValve(new ResetAuthenticationValve());
            if (this.transactionService != null) {
                jStdCtx.addValve(new TransactionValve((TransactionManager)this.transactionService.getTransactionManager()));
            }
            if (this.resourceCheckerManager != null) {
                jStdCtx.addValve(new CheckOpenResourcesValve(this.resourceCheckerManager));
            }
            if (!webservices.isEmpty() && this.getJAXWSService() != null) {
                WSContextLifecycleListener listener = new WSContextLifecycleListener(webservices, this.getJAXWSService());
                jStdCtx.addLifecycleListener(listener);
            }
            if (contextXmlFile.exists()) {
                jStdCtx.setConfigFile(contextXmlFile.getAbsolutePath());
            }
            javax.naming.Context envCtx = null;
            try {
                envCtx = (javax.naming.Context)this.getNaming().getComponentContext(webClassLoader).lookup("comp/env");
            }
            catch (NamingException e) {
                Tomcat6Service.getLogger().log(BasicLevel.ERROR, (Object)("Cannot get the context of the webapplication '" + warURL + "'."), (Throwable)e);
            }
            DefaultAnnotationProcessor annotationProcessor = new DefaultAnnotationProcessor(envCtx);
            annotationProcessor.setEncBindingHolder(webDD.getENCBindingHolder());
            jStdCtx.setAnnotationProcessor(annotationProcessor);
            jStdCtx.setJ2EEServer(this.getJonasServerName());
            jStdCtx.setServer(J2eeObjectName.J2EEServer((String)this.getDomainName(), (String)this.getJonasServerName()).toString());
            MBeanServer mbeanServer = this.jmxService.getJmxServer();
            ObjectName j2eeServerOn = J2eeObjectName.J2EEServer((String)this.getDomainName(), (String)this.getJonasServerName());
            try {
                String[] as = (String[])mbeanServer.getAttribute(j2eeServerOn, "javaVMs");
                jStdCtx.setJavaVMs(as);
            }
            catch (Exception e) {
                Tomcat6Service.getLogger().log(BasicLevel.WARN, (Object)("Set MBean JVM error : " + e.getClass().getName() + " " + e.getMessage()));
            }
            if (earAppName != null) {
                jStdCtx.setJ2EEApplication(earAppName);
            } else {
                jStdCtx.setJ2EEApplication("null");
            }
            jStdCtx.setJonasDeploymentDescriptor(webDD.getJOnASXmlContent());
            jStdCtx.setWebDeploymentDescriptor(webDD);
            org.apache.catalina.Realm ctxRealm = jStdCtx.getRealm();
            if (ctxRealm == null) {
                ctxRealm = deployer.getRealm();
            }
            if (ctxRealm != null && ctxRealm instanceof Realm) {
                Realm jaccRealm = null;
                try {
                    jaccRealm = (Realm)((Realm)ctxRealm).clone();
                }
                catch (CloneNotSupportedException cnse) {
                    String err = "Cannot clone the realm used by the existing context or its parent realm";
                    Tomcat6Service.getLogger().log(BasicLevel.ERROR, (Object)(err + cnse.getMessage()));
                    throw new JWebContainerServiceException(err, (Throwable)cnse);
                }
                if (Tomcat6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Tomcat6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Setting permission manager to " + permissionManager));
                }
                jaccRealm.setPermissionManager(permissionManager);
                jaccRealm.setSecurityService(this.securityService);
                jaccRealm.setContext(jStdCtx);
                jStdCtx.setRealm(jaccRealm);
            }
            jStdCtx.setWarURL(warURL);
            if (inEarCase) {
                jStdCtx.setEarURL(earURL);
            }
            if (jStdCtx.isInServerXml()) {
                try {
                    jStdCtx.setLoader(null);
                    jStdCtx.start();
                }
                catch (LifecycleException lce) {
                    logger.error((Object)("Cannot start the context '" + jStdCtx + "'."), new Object[]{lce});
                    throw new JWebContainerServiceException("Cannot start the context '" + jStdCtx + "'.", (Throwable)lce);
                }
            } else {
                if (deployer == null) {
                    logger.error((Object)("No deployer found for the deployment of the context '" + jStdCtx + "'."), new Object[0]);
                    throw new JWebContainerServiceException("No deployer found for the deployment of the context '" + jStdCtx + "'.");
                }
                deployer.addChild(jStdCtx);
            }
            if (this.getJAXWSService() != null) {
                this.getJAXWSService().finalizePOJODeployment(jStdCtx.getServletContext());
            }
            this.checkStartedContext(jStdCtx, permissionManager);
            try {
                ctx.rebind("WebModule", (Object)jStdCtx.createObjectName(this.getDomainName(), jStdCtx.getParentName()));
            }
            catch (Exception e) {
                String err = "Cannot rebind WebModule ObjectName in Context";
                logger.error((Object)err, new Object[]{e});
                throw new JWebContainerServiceException(err, (Throwable)e);
            }
            ContextFinder.addNonVersionedContext(contextRoot);
            try {
                if (!this.isVersioningEnabled() || contextRoot.length() <= 0 || userURI.length() <= 0) continue;
                if (contextRoot.charAt(0) != '/') {
                    contextRoot = '/' + contextRoot;
                }
                if (userURI.charAt(0) != '/') {
                    userURI = '/' + userURI;
                }
                if (contextRoot.equals(userURI)) continue;
                logger.info((Object)("Deploying versioned application " + userURI + ", path for the added version is " + contextRoot), new Object[0]);
                String policy = this.getVersioningService().getDefaultDeploymentPolicy();
                if (earAppName != null) {
                    ContextFinder.bindContextRoot(earAppName, userURI, jStdCtx, policy);
                    continue;
                }
                ContextFinder.bindContextRoot(URLUtils.urlToFile((URL)warURL).getName(), userURI, jStdCtx, policy);
            }
            catch (Exception e) {
                throw new JWebContainerServiceException("Failed binding versioned web context", (Throwable)e);
            }
        }
    }

    protected ContextConfig createContextConfig() {
        JOnASContextConfig config = new JOnASContextConfig();
        config.setSecurityService(this.securityService);
        return config;
    }

    public Realm createJOnASRealm(String name, boolean isJaccRealm) {
        Realm realm = new Realm();
        realm.setSecurityService(this.getSecurityService());
        if (isJaccRealm) {
            realm.setResourceName(name);
        } else {
            realm.setJaasEntry(name);
        }
        return realm;
    }

    protected List<JOnASStandardContext> getConfiguredMatchingJonasContexts(String contextRoot, File fpackedWar, String destDir) {
        ArrayList<JOnASStandardContext> jonasContexts = new ArrayList<JOnASStandardContext>();
        for (Context ctx : this.getContexts()) {
            String serverCtxRoot;
            JOnASStandardContext jStdCtx;
            if (!(ctx instanceof JOnASStandardContext) || (jStdCtx = (JOnASStandardContext)ctx) == null || !jStdCtx.isInServerXml() || !(serverCtxRoot = jStdCtx.getPath()).equals(contextRoot)) continue;
            if (jStdCtx.getPrivileged()) {
                if (fpackedWar.isDirectory()) {
                    logger.error((Object)("Can deploy a privileged context '" + jStdCtx + "' only if it's a war file (and not a directory)"), new Object[0]);
                }
                jStdCtx.setDocBase(fpackedWar.getPath());
            } else {
                jStdCtx.setDocBase(destDir);
            }
            jonasContexts.add(jStdCtx);
        }
        return jonasContexts;
    }

    protected void checkStartedContext(Context context, PermissionManager permissionManager) throws JWebContainerServiceException {
        Realm jaccRealm;
        PermissionManager ctxPerm;
        if (!context.getConfigured()) {
            throw new JWebContainerServiceException("Context '" + context + "' was not configured");
        }
        org.apache.catalina.Realm ctxRealm = context.getRealm();
        if (ctxRealm != null && ctxRealm instanceof Realm && (ctxPerm = (jaccRealm = (Realm)ctxRealm).getPermissionManager()) == null && permissionManager != null) {
            jaccRealm.setPermissionManager(permissionManager);
            jaccRealm.setContext(context);
        }
        if (Tomcat6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
            Tomcat6Service.getLogger().log(BasicLevel.DEBUG, (Object)("context " + context + " started"));
        }
    }

    protected synchronized List<StandardEngine> getEngines() throws JWebContainerServiceException {
        ArrayList<StandardEngine> engines = new ArrayList<StandardEngine>();
        Service[] services = this.getServer().findServices();
        for (int s = 0; s < services.length; ++s) {
            Container cont = services[s].getContainer();
            if (!(cont instanceof StandardEngine)) {
                String err = "The container of the service must be an engine (server.xml)";
                throw new JWebContainerServiceException(err);
            }
            engines.add((StandardEngine)cont);
        }
        return engines;
    }

    protected synchronized List<Context> getContexts() throws JWebContainerServiceException {
        ArrayList<Context> contexts = new ArrayList<Context>();
        for (StandardEngine engine : this.getEngines()) {
            Container[] hosts = engine.findChildren();
            for (int j = 0; j < hosts.length; ++j) {
                Container[] containers = hosts[j].findChildren();
                for (int k = 0; k < containers.length; ++k) {
                    Container container = containers[k];
                    if (!(container instanceof Context)) continue;
                    contexts.add((Context)container);
                }
            }
        }
        return contexts;
    }

    protected void doUnRegisterWar(javax.naming.Context ctx) throws JWebContainerServiceException {
        String contextRoot = null;
        try {
            contextRoot = (String)ctx.lookup("contextRoot");
        }
        catch (NamingException e) {
            throw new JWebContainerServiceException("Unable to find the contextRoot parameter", (Throwable)e);
        }
        contextRoot = contextRoot.equals("/") ? "" : "/" + contextRoot;
        ContextFinder.removeNonVersionedContext(contextRoot);
        String hostName = null;
        try {
            hostName = (String)ctx.lookup("hostName");
        }
        catch (NamingException e) {
            logger.debug((Object)"No hostname was defined for this context", new Object[0]);
        }
        if (hostName == null) {
            boolean found = false;
            for (Context context : this.getContexts()) {
                String serverCtxRoot = context.getPath();
                if (!serverCtxRoot.equals(contextRoot)) continue;
                this.removeContext(context);
                found = true;
                break;
            }
            if (!found) {
                throw new JWebContainerServiceException("Unable to remove a context with the context name '" + contextRoot + "'.");
            }
        } else {
            Host host = this.findHost(hostName);
            Context context = host.map(contextRoot);
            if (context != null) {
                this.removeContext(context);
            } else {
                throw new JWebContainerServiceException("Unable to find a context for the given hostname '" + hostName + "'.");
            }
        }
        try {
            if (this.isVersioningEnabled() && contextRoot.length() > 0) {
                if (contextRoot.charAt(0) != '/') {
                    contextRoot = '/' + contextRoot;
                }
                if (ContextFinder.unbindContextRoot(contextRoot)) {
                    logger.info((Object)("Undeployed version " + contextRoot), new Object[0]);
                }
            }
        }
        catch (Exception e) {
            throw new JWebContainerServiceException("Failed unbinding web context", (Throwable)e);
        }
    }

    public synchronized void removeContext(Context context) throws JWebContainerServiceException {
        boolean found = false;
        Iterator<Context> it = this.getContexts().iterator();
        while (it.hasNext() && !found) {
            if (context != it.next()) continue;
            found = true;
        }
        if (!found) {
            return;
        }
        if (context instanceof JOnASStandardContext) {
            JOnASStandardContext jctx = (JOnASStandardContext)context;
            if (jctx.isInServerXml()) {
                try {
                    ((JOnASStandardContext)context).stop();
                }
                catch (LifecycleException le) {
                    throw new JWebContainerServiceException("Cannot stop context (" + le.getMessage() + ")");
                }
            } else {
                context.getParent().removeChild(context);
            }
        } else {
            context.getParent().removeChild(context);
            if (context instanceof StandardContext) {
                StandardContext ctx = (StandardContext)context;
                try {
                    this.jmxService.getJmxServer().unregisterMBean(ctx.getJmxName());
                }
                catch (Exception e) {
                    Tomcat6Service.getLogger().log(BasicLevel.ERROR, (Object)("Cannot remove the MBean for the WebModule " + ctx.getObjectName() + " : " + e.getMessage()));
                }
            }
        }
    }

    public boolean isTomcatStarted() {
        return this.tomcatStarted;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public synchronized Server getServer() {
        if (this.server == null) {
            this.startInternalWebContainer();
        }
        return this.server;
    }

    protected File getConfigFile() throws FileNotFoundException {
        String fileName = System.getProperty("catalina.base");
        File file = new File(fileName = fileName + File.separator + CONFIG_FILE);
        if (!file.exists()) {
            throw new FileNotFoundException("The configuration file '" + fileName + "' does not exists.");
        }
        return file;
    }

    public Host findHost(String hostName) throws JWebContainerServiceException {
        Service[] services = this.getServer().findServices();
        if (services.length < 1) {
            String err = "At least one service must be define in the server.xml of Tomcat";
            throw new JWebContainerServiceException(err);
        }
        if (hostName == null || hostName.equals("")) {
            Service service = services[0];
            Container cont = service.getContainer();
            if (!(cont instanceof Engine)) {
                String err = "The container of the service must be an engine";
                throw new JWebContainerServiceException(err);
            }
            Engine engine = (Engine)cont;
            String defaultHost = engine.getDefaultHost();
            if (defaultHost == null) {
                String err = "Default host must be specified in server.xml or host must be specified in jonas-web.xml";
                throw new JWebContainerServiceException(err);
            }
            Container child = engine.findChild(defaultHost);
            if (child instanceof Host) {
                return (Host)child;
            }
            String err = "Default host " + defaultHost + " not found";
            throw new JWebContainerServiceException(err);
        }
        ArrayList<Host> hosts = new ArrayList<Host>();
        for (int s = 0; s < services.length; ++s) {
            Container cont = services[s].getContainer();
            if (!(cont instanceof Engine)) {
                String err = "The container of a service must be an engine";
                throw new JWebContainerServiceException(err);
            }
            Engine engine = (Engine)cont;
            Container child = engine.findChild(hostName);
            if (!(child instanceof Host)) continue;
            hosts.add((Host)child);
        }
        if (hosts.size() == 0) {
            String err = "Host " + hostName + " not found in all services/Engine of server.xml";
            throw new JWebContainerServiceException(err);
        }
        return (Host)hosts.get(0);
    }

    protected Digester createServerDigester() {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addRuleSet(new JCatalinaRuleSet(this.externalLoader, this.securityService));
        digester.setUseContextClassLoader(true);
        return digester;
    }

    protected void updateServerInfos() {
        String infos = ServerInfo.getServerInfo();
        StringTokenizer st = new StringTokenizer(infos, "/");
        if (st.countTokens() != 2) {
            this.setServerName(infos);
            this.setServerVersion("");
        } else {
            this.setServerName(st.nextToken());
            this.setServerVersion(st.nextToken());
        }
    }

    public String getDefaultHost() throws JWebContainerServiceException {
        Engine engine = (Engine)this.getFirstService().getContainer();
        return engine.getDefaultHost();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDefaultHttpPort() throws JWebContainerServiceException {
        String string;
        if (this.tomcatStarted) return String.valueOf(this.getPort("http"));
        File configFile = null;
        try {
            configFile = this.getConfigFile();
        }
        catch (FileNotFoundException e) {
            throw new JWebContainerServiceException("Cannot get configuration file", (Throwable)e);
        }
        FileInputStream is = null;
        try {
            String text;
            is = new FileInputStream(configFile);
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setNamespaceAware(true);
            DocumentBuilder builder = null;
            try {
                builder = domFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new JWebContainerServiceException("Cannot build document builder", (Throwable)e);
            }
            Document doc = null;
            try {
                doc = builder.parse(is);
            }
            catch (SAXException e) {
                throw new JWebContainerServiceException("Cannot analyze configuration file", (Throwable)e);
            }
            catch (IOException e) {
                throw new JWebContainerServiceException("Cannot analyze configuration file", (Throwable)e);
            }
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpr = null;
            try {
                xPathExpr = xPath.compile("//Server/Service/Connector[1]");
            }
            catch (XPathExpressionException e) {
                throw new JWebContainerServiceException("Cannot analyze configuration file", (Throwable)e);
            }
            Node node = null;
            try {
                node = (Node)xPathExpr.evaluate(doc, XPathConstants.NODE);
            }
            catch (XPathExpressionException e) {
                throw new JWebContainerServiceException("Cannot analyze configuration file", (Throwable)e);
            }
            if (node == null) {
                throw new JWebContainerServiceException("No connector element found in the configuration file");
            }
            string = text = node.getAttributes().getNamedItem("port").getNodeValue();
            if (is == null) return string;
        }
        catch (FileNotFoundException e) {
            try {
                throw new JWebContainerServiceException("Cannot get input stream", (Throwable)e);
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    ((InputStream)is).close();
                    throw throwable;
                }
                catch (IOException e2) {
                    logger.debug((Object)"Cannot close input stream", new Object[]{e2});
                }
                throw throwable;
            }
        }
        try {
            ((InputStream)is).close();
            return string;
        }
        catch (IOException e) {
            logger.debug((Object)"Cannot close input stream", new Object[]{e});
        }
        return string;
    }

    public String getDefaultHttpsPort() throws JWebContainerServiceException {
        return String.valueOf(this.getPort("https"));
    }

    protected int getPort(String scheme) throws JWebContainerServiceException {
        Service svc = this.getFirstService();
        ArrayList<Connector> conn = new ArrayList<Connector>();
        for (Connector c : svc.findConnectors()) {
            if (!c.getScheme().equalsIgnoreCase(scheme)) continue;
            conn.add(c);
        }
        if (conn.isEmpty()) {
            throw new JWebContainerServiceException("No Connectors found for scheme '" + scheme + "' in " + CONFIG_FILE);
        }
        Connector c = (Connector)conn.get(0);
        if (conn.size() > 1 && Tomcat6Service.getLogger().isLoggable(BasicLevel.WARN)) {
            Tomcat6Service.getLogger().log(BasicLevel.WARN, (Object)("Found multiple Connectors for scheme '" + scheme + "' in " + CONFIG_FILE + ", using first by default! (port:" + c.getPort() + ")"));
        }
        return c.getPort();
    }

    protected Service getFirstService() {
        Service[] svc = this.getServer().findServices();
        if (svc == null || svc.length == 0) {
            throw new JWebContainerServiceException("No Services found in " + CONFIG_FILE);
        }
        if (svc.length > 1 && Tomcat6Service.getLogger().isLoggable(BasicLevel.WARN)) {
            Tomcat6Service.getLogger().log(BasicLevel.WARN, (Object)("Found multiple Services in " + CONFIG_FILE + ", using first by default!"));
        }
        return svc[0];
    }

    public void registerWar(String fileName) throws RemoteException, JWebContainerServiceException {
        ClassLoader old = null;
        try {
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.externalLoader);
            super.registerWar(fileName);
        }
        catch (Exception e) {
            throw new ServiceException("Exception during registering war", (Throwable)e);
        }
        finally {
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    public void unRegisterWar(String fileName) throws RemoteException, JWebContainerServiceException {
        ClassLoader old = null;
        try {
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.externalLoader);
            super.unRegisterWar(fileName);
        }
        catch (Exception e) {
            throw new ServiceException("Exception during unregistering war", (Throwable)e);
        }
        finally {
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    protected TransactionService getTransactionService() {
        return this.transactionService;
    }

    public IResourceCheckerManager getResourceCheckerManager() {
        return this.resourceCheckerManager;
    }

    public void setResourceCheckerManager(IResourceCheckerManager resourceCheckerManager) {
        this.resourceCheckerManager = resourceCheckerManager;
    }

    public void unsetResourceCheckerManager() {
        this.resourceCheckerManager = null;
    }
}

