/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jmx;

import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.monitor.CounterMonitor;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jmx.JMXComponent;
import org.apache.camel.component.jmx.JMXConsumer;
import org.apache.camel.component.jmx.JMXMessage;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMXEndpoint
extends DefaultEndpoint {
    private static final transient Log LOG = LogFactory.getLog(JMXEndpoint.class);
    private String name;
    private String observedObjectName;
    private String attributeName;
    private long granularityPeriod = 5000L;
    private Number threshold;
    private Number offset;
    private MBeanServer mbeanServer;
    private CounterMonitor counterMonitor = new CounterMonitor();

    public JMXEndpoint() {
    }

    public JMXEndpoint(String endpointUri, JMXComponent component) {
        super(endpointUri, component);
        this.observedObjectName = endpointUri;
    }

    public JMXEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Producer not supported");
    }

    public Consumer createConsumer(Processor proc) throws Exception {
        ObjectHelper.notNull(this.mbeanServer, "mbeanServer");
        ObjectName observedName = new ObjectName(this.observedObjectName);
        if (this.name == null) {
            String type = observedName.getKeyProperty("type");
            type = type != null ? type : "UNKNOWN";
            this.name = this.mbeanServer.getDefaultDomain() + ":type=CounterMonitor_" + type;
        }
        JMXConsumer result = new JMXConsumer(this, proc);
        ObjectName ourName = new ObjectName(this.name);
        this.counterMonitor.setNotify(true);
        this.counterMonitor.addObservedObject(observedName);
        this.counterMonitor.setObservedAttribute(this.attributeName);
        this.counterMonitor.setGranularityPeriod(this.granularityPeriod);
        this.counterMonitor.setDifferenceMode(false);
        this.counterMonitor.setInitThreshold(this.threshold);
        this.counterMonitor.setOffset(this.offset);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registering and adding notification listener for [" + this.counterMonitor + "] with name [" + ourName + "]"));
        }
        this.mbeanServer.registerMBean(this.counterMonitor, ourName);
        this.mbeanServer.addNotificationListener(ourName, result, null, new Object());
        return result;
    }

    public boolean isSingleton() {
        return true;
    }

    public Exchange createExchange(Notification notification) {
        Exchange exchange = this.createExchange();
        exchange.setIn(new JMXMessage(notification));
        return exchange;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public long getGranularityPeriod() {
        return this.granularityPeriod;
    }

    public void setGranularityPeriod(long granularityPeriod) {
        this.granularityPeriod = granularityPeriod;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Number getOffset() {
        return this.offset;
    }

    public void setOffset(Number offset) {
        this.offset = offset;
    }

    public Number getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Number threshold) {
        this.threshold = threshold;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }
}

