/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.converter.jaxp.BytesSource;
import org.apache.camel.converter.jaxp.StringSource;
import org.apache.camel.util.ObjectHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@Converter
public class XmlConverter {
    public static final String DEFAULT_CHARSET_PROPERTY = "org.apache.camel.default.charset";
    public static String defaultCharset = ObjectHelper.getSystemProperty("org.apache.camel.default.charset", "UTF-8");
    private static final Class DOM_TO_SAX_CLASS;
    private DocumentBuilderFactory documentBuilderFactory;
    private TransformerFactory transformerFactory;

    public XmlConverter() {
    }

    public XmlConverter(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    public Properties defaultOutputProperties() {
        Properties properties = new Properties();
        properties.put("encoding", defaultCharset);
        properties.put("omit-xml-declaration", "yes");
        return properties;
    }

    public void toResult(Source source, Result result) throws TransformerException {
        this.toResult(source, result, this.defaultOutputProperties());
    }

    public void toResult(Source source, Result result, Properties outputProperties) throws TransformerException {
        if (source == null) {
            return;
        }
        Transformer transformer = this.createTransfomer();
        if (transformer == null) {
            throw new TransformerException("Could not create a transformer - JAXP is misconfigured!");
        }
        transformer.setOutputProperties(outputProperties);
        transformer.transform(source, result);
    }

    @Converter
    public BytesSource toSource(byte[] data) {
        return new BytesSource(data);
    }

    @Converter
    public StringSource toSource(String data) {
        return new StringSource(data);
    }

    @Converter
    public DOMSource toSource(Document document) {
        return new DOMSource(document);
    }

    @Converter
    public Source toSource(Node node) {
        return new DOMSource(node);
    }

    @Converter
    public String toString(Source source) throws TransformerException {
        if (source == null) {
            return null;
        }
        if (source instanceof StringSource) {
            return ((StringSource)source).getText();
        }
        if (source instanceof BytesSource) {
            return new String(((BytesSource)source).getData());
        }
        StringWriter buffer = new StringWriter();
        this.toResult(source, new StreamResult(buffer));
        return buffer.toString();
    }

    @Converter
    public byte[] toByteArray(Source source, Exchange exchange) throws TransformerException {
        String answer = this.toString(source);
        if (exchange != null) {
            return exchange.getContext().getTypeConverter().convertTo(byte[].class, exchange, answer);
        }
        return answer.getBytes();
    }

    @Converter
    public String toString(Node node) throws TransformerException {
        return this.toString(new DOMSource(node));
    }

    @Converter
    public DOMSource toDOMSource(Source source) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        if (source instanceof DOMSource) {
            return (DOMSource)source;
        }
        if (source instanceof SAXSource) {
            return this.toDOMSourceFromSAX((SAXSource)source);
        }
        if (source instanceof StreamSource) {
            return this.toDOMSourceFromStream((StreamSource)source);
        }
        return null;
    }

    @Converter
    public DOMSource toDOMSource(String text) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        StringSource source = this.toSource(text);
        if (source != null) {
            return this.toDOMSourceFromStream(source);
        }
        return null;
    }

    @Converter
    public SAXSource toSAXSource(String source) throws IOException, SAXException, TransformerException {
        return this.toSAXSource(this.toSource(source));
    }

    @Converter
    public SAXSource toSAXSource(InputStream source) throws IOException, SAXException, TransformerException {
        return this.toSAXSource(this.toStreamSource(source));
    }

    @Converter
    public SAXSource toSAXSource(Source source) throws IOException, SAXException, TransformerException {
        if (source instanceof SAXSource) {
            return (SAXSource)source;
        }
        if (source instanceof DOMSource) {
            return this.toSAXSourceFromDOM((DOMSource)source);
        }
        if (source instanceof StreamSource) {
            return this.toSAXSourceFromStream((StreamSource)source);
        }
        return null;
    }

    @Converter
    public StreamSource toStreamSource(Source source) throws TransformerException {
        if (source instanceof StreamSource) {
            return (StreamSource)source;
        }
        if (source instanceof DOMSource) {
            return this.toStreamSourceFromDOM((DOMSource)source);
        }
        if (source instanceof SAXSource) {
            return this.toStreamSourceFromSAX((SAXSource)source);
        }
        return null;
    }

    @Converter
    public StreamSource toStreamSource(InputStream in) throws TransformerException {
        if (in != null) {
            return new StreamSource(in);
        }
        return null;
    }

    @Converter
    public StreamSource toStreamSource(Reader in) throws TransformerException {
        if (in != null) {
            return new StreamSource(in);
        }
        return null;
    }

    @Converter
    public StreamSource toStreamSource(File in) throws TransformerException {
        if (in != null) {
            return new StreamSource(in);
        }
        return null;
    }

    @Converter
    public StreamSource toStreamSource(byte[] in, Exchange exchange) throws TransformerException {
        if (in != null) {
            InputStream is = exchange.getContext().getTypeConverter().convertTo(InputStream.class, in);
            return new StreamSource(is);
        }
        return null;
    }

    @Converter
    public StreamSource toStreamSource(ByteBuffer in, Exchange exchange) throws TransformerException {
        if (in != null) {
            InputStream is = exchange.getContext().getTypeConverter().convertTo(InputStream.class, in);
            return new StreamSource(is);
        }
        return null;
    }

    @Converter
    public StreamSource toStreamSourceFromSAX(SAXSource source) throws TransformerException {
        InputSource inputSource = source.getInputSource();
        if (inputSource != null) {
            if (inputSource.getCharacterStream() != null) {
                return new StreamSource(inputSource.getCharacterStream());
            }
            if (inputSource.getByteStream() != null) {
                return new StreamSource(inputSource.getByteStream());
            }
        }
        String result = this.toString(source);
        return new StringSource(result);
    }

    @Converter
    public StreamSource toStreamSourceFromDOM(DOMSource source) throws TransformerException {
        String result = this.toString(source);
        return new StringSource(result);
    }

    @Converter
    public SAXSource toSAXSourceFromStream(StreamSource source) {
        InputSource inputSource = source.getReader() != null ? new InputSource(source.getReader()) : new InputSource(source.getInputStream());
        inputSource.setSystemId(source.getSystemId());
        inputSource.setPublicId(source.getPublicId());
        return new SAXSource(inputSource);
    }

    @Converter
    public Reader toReaderFromSource(Source src) throws TransformerException {
        StreamSource stSrc = this.toStreamSource(src);
        Reader r = stSrc.getReader();
        if (r == null) {
            r = new InputStreamReader(stSrc.getInputStream());
        }
        return r;
    }

    @Converter
    public DOMSource toDOMSourceFromStream(StreamSource source) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder builder = this.createDocumentBuilder();
        String systemId = source.getSystemId();
        Document document = null;
        Reader reader = source.getReader();
        if (reader != null) {
            document = builder.parse(new InputSource(reader));
        } else {
            InputStream inputStream = source.getInputStream();
            if (inputStream != null) {
                InputSource inputsource = new InputSource(inputStream);
                inputsource.setSystemId(systemId);
                document = builder.parse(inputsource);
            } else {
                throw new IOException("No input stream or reader available");
            }
        }
        return new DOMSource(document, systemId);
    }

    @Converter
    public SAXSource toSAXSourceFromDOM(DOMSource source) throws TransformerException {
        if (DOM_TO_SAX_CLASS != null) {
            try {
                Constructor cns = DOM_TO_SAX_CLASS.getConstructor(Node.class);
                XMLReader converter = (XMLReader)cns.newInstance(source.getNode());
                return new SAXSource(converter, new InputSource());
            }
            catch (Exception e) {
                throw new TransformerException(e);
            }
        }
        String str = this.toString(source);
        StringReader reader = new StringReader(str);
        return new SAXSource(new InputSource(reader));
    }

    @Converter
    public DOMSource toDOMSourceFromSAX(SAXSource source) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        return new DOMSource(this.toDOMNodeFromSAX(source));
    }

    @Converter
    public Node toDOMNodeFromSAX(SAXSource source) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        DOMResult result = new DOMResult();
        this.toResult(source, result);
        return result.getNode();
    }

    @Converter
    public Node toDOMNode(Source source) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        DOMSource domSrc = this.toDOMSource(source);
        return domSrc != null ? domSrc.getNode() : null;
    }

    @Converter
    public Element toDOMElement(Source source) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        Node node = this.toDOMNode(source);
        return this.toDOMElement(node);
    }

    @Converter
    public Element toDOMElement(Node node) throws TransformerException {
        if (node instanceof Document) {
            return ((Document)node).getDocumentElement();
        }
        if (node instanceof Element) {
            return (Element)node;
        }
        throw new TransformerException("Unable to convert DOM node to an Element");
    }

    @Converter
    public Document toDOMDocument(byte[] data) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder documentBuilder = this.getDocumentBuilderFactory().newDocumentBuilder();
        return documentBuilder.parse(new ByteArrayInputStream(data));
    }

    @Converter
    public Document toDOMDocument(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder documentBuilder = this.getDocumentBuilderFactory().newDocumentBuilder();
        return documentBuilder.parse(in);
    }

    @Converter
    public Document toDOMDocument(Reader in) throws IOException, SAXException, ParserConfigurationException {
        return this.toDOMDocument(new InputSource(in));
    }

    @Converter
    public Document toDOMDocument(InputSource in) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder documentBuilder = this.getDocumentBuilderFactory().newDocumentBuilder();
        return documentBuilder.parse(in);
    }

    @Converter
    public Document toDOMDocument(String text) throws IOException, SAXException, ParserConfigurationException {
        return this.toDOMDocument(new StringReader(text));
    }

    @Converter
    public Document toDOMDocument(File file) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder documentBuilder = this.getDocumentBuilderFactory().newDocumentBuilder();
        return documentBuilder.parse(file);
    }

    @Converter
    public Document toDOMDocument(Source source) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        Node node = this.toDOMNode(source);
        return this.toDOMDocument(node);
    }

    @Converter
    public Document toDOMDocument(Node node) throws ParserConfigurationException, TransformerException {
        if (node instanceof Document) {
            return (Document)node;
        }
        if (node instanceof Element) {
            Element elem = (Element)node;
            if (elem.getOwnerDocument().getDocumentElement() == elem) {
                return elem.getOwnerDocument();
            }
            Document doc = this.createDocument();
            doc.appendChild(doc.importNode(node, true));
            return doc;
        }
        throw new TransformerException("Unable to convert DOM node to a Document");
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        if (this.documentBuilderFactory == null) {
            this.documentBuilderFactory = this.createDocumentBuilderFactory();
        }
        return this.documentBuilderFactory;
    }

    public void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    public DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        return factory;
    }

    public DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = this.getDocumentBuilderFactory();
        return factory.newDocumentBuilder();
    }

    public Document createDocument() throws ParserConfigurationException {
        DocumentBuilder builder = this.createDocumentBuilder();
        return builder.newDocument();
    }

    public TransformerFactory getTransformerFactory() {
        if (this.transformerFactory == null) {
            this.transformerFactory = this.createTransformerFactory();
        }
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public Transformer createTransfomer() throws TransformerConfigurationException {
        TransformerFactory factory = this.getTransformerFactory();
        return factory.newTransformer();
    }

    public TransformerFactory createTransformerFactory() {
        return TransformerFactory.newInstance();
    }

    static {
        Class<?> cl = null;
        try {
            cl = ObjectHelper.loadClass("org.apache.xalan.xsltc.trax.DOM2SAX");
        }
        catch (Exception exception) {
            // empty catch block
        }
        DOM_TO_SAX_CLASS = cl;
    }
}

