/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ScheduledPollConsumer
extends DefaultConsumer
implements Runnable {
    private static final transient Log LOG = LogFactory.getLog(ScheduledPollConsumer.class);
    private final ScheduledExecutorService executor;
    private ScheduledFuture<?> future;
    private Exception firstExceptionThrown;
    private long initialDelay = 1000L;
    private long delay = 500L;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private boolean useFixedDelay;

    public ScheduledPollConsumer(DefaultEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        ExecutorService service = endpoint.getExecutorService();
        ScheduledExecutorService scheduled = service instanceof ScheduledExecutorService ? (ScheduledExecutorService)service : ExecutorServiceHelper.newScheduledThreadPool(5, this.getEndpoint().getEndpointUri(), true);
        this.executor = scheduled;
        ObjectHelper.notNull(this.executor, "executor");
    }

    public ScheduledPollConsumer(Endpoint endpoint, Processor processor, ScheduledExecutorService executor) {
        super(endpoint, processor);
        this.executor = executor;
        ObjectHelper.notNull(executor, "executor");
    }

    public void run() {
        block5: {
            try {
                if (this.isRunAllowed()) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Starting to poll: " + this.getEndpoint()));
                    }
                    this.poll();
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("An exception occurred while polling: " + this.getEndpoint() + ": " + e.getMessage()), (Throwable)e);
                if (this.firstExceptionThrown != null) break block5;
                this.firstExceptionThrown = e;
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Finished polling: " + this.getEndpoint()));
        }
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public boolean isUseFixedDelay() {
        return this.useFixedDelay;
    }

    public void setUseFixedDelay(boolean useFixedDelay) {
        this.useFixedDelay = useFixedDelay;
    }

    protected abstract void poll() throws Exception;

    protected void doStart() throws Exception {
        this.firstExceptionThrown = null;
        super.doStart();
        this.future = this.isUseFixedDelay() ? this.executor.scheduleWithFixedDelay(this, this.getInitialDelay(), this.getDelay(), this.getTimeUnit()) : this.executor.scheduleAtFixedRate(this, this.getInitialDelay(), this.getDelay(), this.getTimeUnit());
    }

    protected void doStop() throws Exception {
        if (this.future != null) {
            this.future.cancel(false);
        }
        super.doStop();
        if (this.firstExceptionThrown != null) {
            throw this.firstExceptionThrown;
        }
    }
}

