/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="policy")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PolicyDefinition
extends OutputDefinition<ProcessorDefinition> {
    @XmlTransient
    protected Class<? extends Policy> type;
    @XmlAttribute(required=true)
    protected String ref;
    @XmlTransient
    private Policy policy;

    public PolicyDefinition() {
    }

    public PolicyDefinition(Policy policy) {
        this.policy = policy;
    }

    public String toString() {
        return "Policy[" + this.description() + "]";
    }

    @Override
    public String getShortName() {
        return "policy";
    }

    @Override
    public String getLabel() {
        if (this.ref != null) {
            return "ref: " + this.ref;
        }
        if (this.policy != null) {
            return this.policy.toString();
        }
        return "";
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public void setType(Class<? extends Policy> type) {
        this.type = type;
    }

    public PolicyDefinition ref(String ref) {
        this.setRef(ref);
        return this;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Processor childProcessor = this.createOutputsProcessor(routeContext);
        Policy policy = this.resolvePolicy(routeContext);
        ObjectHelper.notNull(policy, "policy", this);
        return policy.wrap(routeContext, childProcessor);
    }

    protected String description() {
        if (this.policy != null) {
            return this.policy.toString();
        }
        return "ref: " + this.ref;
    }

    protected Policy resolvePolicy(RouteContext routeContext) {
        if (this.policy != null) {
            return this.policy;
        }
        return TransactedDefinition.doResolvePolicy(routeContext, this.getRef(), this.type);
    }
}

