/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;

@XmlRootElement(name="secureXML")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class XMLSecurityDataFormat
extends DataFormatDefinition {
    private static final transient String TRIPLEDES = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    @XmlAttribute(required=false)
    private String xmlCipherAlgorithm;
    @XmlAttribute(required=false)
    private String passPhrase;
    @XmlAttribute(required=false)
    private String secureTag;
    @XmlAttribute(required=false)
    private boolean secureTagContents;

    public XMLSecurityDataFormat() {
        super("org.apache.camel.dataformat.xmlsecurity.XMLSecurityDataFormat");
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, String passPhrase) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setPassPhrase(passPhrase);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, String passPhrase, String xmlCipherAlgorithm) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setPassPhrase(passPhrase);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
    }

    protected void configureDataFormat(DataFormat dataFormat) {
        if (this.getSecureTag() != null) {
            this.setProperty(dataFormat, "secureTag", this.getSecureTag());
        } else {
            this.setProperty(dataFormat, "secureTag", "");
        }
        this.setProperty(dataFormat, "secureTagContents", this.getSecureTagContents());
        if (this.passPhrase != null) {
            this.setProperty(dataFormat, "passPhrase", this.getPassPhrase());
        } else {
            this.setProperty(dataFormat, "passPhrase", "Just another 24 Byte key".getBytes());
        }
        if (this.getXmlCipherAlgorithm() != null) {
            this.setProperty(dataFormat, "xmlCipherAlgorithm", this.getXmlCipherAlgorithm());
        } else {
            this.setProperty(dataFormat, "xmlCipherAlgorithm", TRIPLEDES);
        }
    }

    public String getXmlCipherAlgorithm() {
        return this.xmlCipherAlgorithm;
    }

    public void setXmlCipherAlgorithm(String xmlCipherAlgorithm) {
        this.xmlCipherAlgorithm = xmlCipherAlgorithm;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(String passPhrase) {
        this.passPhrase = passPhrase;
    }

    public String getSecureTag() {
        return this.secureTag;
    }

    public void setSecureTag(String secureTag) {
        this.secureTag = secureTag;
    }

    public boolean isSecureTagContents() {
        return this.secureTagContents;
    }

    public boolean getSecureTagContents() {
        return this.secureTagContents;
    }

    public void setSecureTagContents(boolean secureTagContents) {
        this.secureTagContents = secureTagContents;
    }
}

