/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pipeline
extends MulticastProcessor
implements Processor {
    private static final transient Log LOG = LogFactory.getLog(Pipeline.class);

    public Pipeline(Collection<Processor> processors) {
        super(processors);
    }

    public static Processor newInstance(List<Processor> processors) {
        if (processors.isEmpty()) {
            return null;
        }
        if (processors.size() == 1) {
            return processors.get(0);
        }
        return new Pipeline(processors);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Iterator<Processor> processors = this.getProcessors().iterator();
        Exchange nextExchange = exchange;
        boolean first = true;
        while (this.continueRouting(processors, nextExchange)) {
            if (first) {
                first = false;
            } else {
                nextExchange = this.createNextExchange(nextExchange);
            }
            Processor processor = processors.next();
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Processing exchangeId: " + nextExchange.getExchangeId() + " >>> " + nextExchange));
                }
                processor.process(nextExchange);
            }
            catch (Exception e) {
                nextExchange.setException(e);
            }
            boolean exceptionHandled = Pipeline.hasExceptionBeenHandled(nextExchange);
            if (!nextExchange.isFailed() && !exceptionHandled) continue;
            if (!LOG.isDebugEnabled()) break;
            LOG.debug((Object)("Message exchange has failed so breaking out of pipeline: " + nextExchange + " exception: " + nextExchange.getException() + " fault: " + (nextExchange.hasFault() ? nextExchange.getFault() : null) + (exceptionHandled ? " handled by the error handler" : "")));
            break;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Processing compelete for exchangeId: " + exchange.getExchangeId() + " >>> " + nextExchange));
        }
        ExchangeHelper.copyResults(exchange, nextExchange);
    }

    private static boolean hasExceptionBeenHandled(Exchange nextExchange) {
        return Boolean.TRUE.equals(nextExchange.getProperty("CamelExceptionHandled"));
    }

    protected Exchange createNextExchange(Exchange previousExchange) {
        Exchange answer = previousExchange.newInstance();
        answer.setExchangeId(previousExchange.getExchangeId());
        answer.getProperties().putAll(previousExchange.getProperties());
        Message in = answer.getIn();
        if (previousExchange.hasOut()) {
            in.copyFrom(previousExchange.getOut());
        } else {
            in.copyFrom(previousExchange.getIn());
        }
        return answer;
    }

    protected boolean continueRouting(Iterator<Processor> it, Exchange exchange) {
        Object stop = exchange.getProperty("CamelRouteStop");
        if (stop != null) {
            boolean doStop = exchange.getContext().getTypeConverter().convertTo(Boolean.class, stop);
            if (doStop) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Exchange is marked to stop routing: " + exchange));
                }
                return false;
            }
            return true;
        }
        return it.hasNext();
    }

    @Override
    public String toString() {
        return "Pipeline" + this.getProcessors();
    }
}

