/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.SessionHandler;
import org.ops4j.pax.swissbox.core.BundleUtils;
import org.ops4j.pax.web.service.internal.HttpServiceContext;
import org.ops4j.pax.web.service.internal.JettyServerHandlerCollection;
import org.ops4j.pax.web.service.internal.model.Model;
import org.ops4j.pax.web.service.internal.model.ServerModel;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JettyServerWrapper
extends Server {
    private static final Log LOG = LogFactory.getLog(JettyServerWrapper.class);
    private final ServerModel m_serverModel;
    private final Map<HttpContext, Context> m_contexts;
    private Map<String, Object> m_contextAttributes;
    private Integer m_sessionTimeout;

    JettyServerWrapper(ServerModel serverModel) {
        this.m_serverModel = serverModel;
        this.m_contexts = new IdentityHashMap<HttpContext, Context>();
    }

    public void addHandler(Handler handler) {
        if (this.getHandler() == null) {
            this.setHandler((Handler)new JettyServerHandlerCollection(this.m_serverModel));
        }
        ((HandlerCollection)this.getHandler()).addHandler(handler);
    }

    public void configureContext(Map<String, Object> attributes, Integer sessionTimeout) {
        this.m_contextAttributes = attributes;
        this.m_sessionTimeout = sessionTimeout;
    }

    Context getContext(HttpContext httpContext) {
        return this.m_contexts.get(httpContext);
    }

    Context getOrCreateContext(Model model) {
        Context context = this.m_contexts.get(model.getContextModel().getHttpContext());
        if (context == null) {
            context = this.addContext(model);
            this.m_contexts.put(model.getContextModel().getHttpContext(), context);
        }
        return context;
    }

    void removeContext(HttpContext httpContext) {
        this.removeHandler((Handler)this.getContext(httpContext));
        this.m_contexts.remove(httpContext);
    }

    private Context addContext(Model model) {
        HttpServiceContext context = new HttpServiceContext(this, model.getContextModel().getContextParams(), this.getContextAttributes(BundleUtils.getBundleContext(model.getContextModel().getBundle())), model.getContextModel().getContextName(), model.getContextModel().getHttpContext(), model.getContextModel().getAccessControllerContext());
        context.setClassLoader(model.getContextModel().getClassLoader());
        if (model.getContextModel().getSessionTimeout() != null) {
            this.configureSessionTimeout(context, model.getContextModel().getSessionTimeout());
        } else if (this.m_sessionTimeout != null) {
            this.configureSessionTimeout(context, this.m_sessionTimeout);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("added servlet context: " + (Object)((Object)context));
        }
        if (this.isStarted()) {
            try {
                LOG.debug("(Re)starting servlet contexts...");
                Handler serverHandler = this.getHandler();
                if (!serverHandler.isStarted() && !serverHandler.isStarting()) {
                    serverHandler.start();
                }
                if (!context.isStarted() && !context.isStarting()) {
                    context.start();
                }
            }
            catch (Exception ignore) {
                LOG.error("Could not start the servlet context for http context [" + model.getContextModel().getHttpContext() + "]", ignore);
            }
        }
        return context;
    }

    private Map<String, Object> getContextAttributes(BundleContext bundleContext) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (this.m_contextAttributes != null) {
            attributes.putAll(this.m_contextAttributes);
        }
        attributes.put("osgi-bundlecontext", bundleContext);
        attributes.put("org.springframework.osgi.web.org.osgi.framework.BundleContext", bundleContext);
        return attributes;
    }

    private void configureSessionTimeout(Context context, Integer minutes) {
        SessionManager sessionManager;
        SessionHandler sessionHandler = context.getSessionHandler();
        if (sessionHandler != null && (sessionManager = sessionHandler.getSessionManager()) != null) {
            sessionManager.setMaxInactiveInterval(minutes * 60);
            LOG.debug("Session timeout set to " + minutes + " minutes for context [" + context + "]");
        }
    }
}

