/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import org.apache.camel.Endpoint;
import org.apache.camel.component.timer.TimerEndpoint;
import org.apache.camel.impl.DefaultComponent;

public class TimerComponent
extends DefaultComponent {
    private final Map<String, Timer> timers = new HashMap<String, Timer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer getTimer(TimerEndpoint endpoint) {
        Timer answer;
        String key = endpoint.getTimerName();
        if (!endpoint.isDaemon()) {
            key = "nonDaemon:" + key;
        }
        Map<String, Timer> map = this.timers;
        synchronized (map) {
            answer = this.timers.get(key);
            if (answer == null) {
                answer = new Timer(endpoint.getTimerName(), endpoint.isDaemon());
                this.timers.put(key, answer);
            }
        }
        return answer;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        TimerEndpoint answer = new TimerEndpoint(uri, this, remaining);
        this.setProperties(answer, parameters);
        return answer;
    }

    protected void doStop() throws Exception {
        Collection<Timer> collection = this.timers.values();
        for (Timer timer : collection) {
            timer.cancel();
        }
        this.timers.clear();
    }
}

