/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.FailedToCreateConsumerException;
import org.apache.camel.IsSingleton;
import org.apache.camel.PollingConsumer;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConsumerCache
extends ServiceSupport {
    private static final transient Log LOG = LogFactory.getLog(ConsumerCache.class);
    private final Map<String, PollingConsumer> consumers = new HashMap<String, PollingConsumer>();

    public synchronized PollingConsumer getConsumer(Endpoint endpoint) {
        String key = endpoint.getEndpointUri();
        PollingConsumer answer = this.consumers.get(key);
        if (answer == null) {
            try {
                answer = endpoint.createPollingConsumer();
                answer.start();
            }
            catch (Exception e) {
                throw new FailedToCreateConsumerException(endpoint, (Throwable)e);
            }
            boolean singleton = true;
            if (answer instanceof IsSingleton) {
                singleton = ((IsSingleton)((Object)answer)).isSingleton();
            }
            if (singleton) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding to consumer cache with key: " + endpoint + " for consumer: " + answer));
                }
                this.consumers.put(key, answer);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Consumer for endpoint: " + key + " is not singleton and thus not added to producer cache"));
            }
        }
        return answer;
    }

    public Exchange receive(Endpoint endpoint) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<<<< " + endpoint));
        }
        PollingConsumer consumer = this.getConsumer(endpoint);
        return consumer.receive();
    }

    public Exchange receive(Endpoint endpoint, long timeout) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<<<< " + endpoint));
        }
        PollingConsumer consumer = this.getConsumer(endpoint);
        return consumer.receive(timeout);
    }

    public Exchange receiveNoWait(Endpoint endpoint) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<<<< " + endpoint));
        }
        PollingConsumer consumer = this.getConsumer(endpoint);
        return consumer.receiveNoWait();
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.consumers.values());
        this.consumers.clear();
    }

    protected void doStart() throws Exception {
    }
}

