/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.impl.DefaultRouteContext;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelContextHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="route")
@XmlType(propOrder={"inputs", "outputs"})
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class RouteDefinition
extends ProcessorDefinition<ProcessorDefinition>
implements CamelContextAware {
    private List<FromDefinition> inputs = new ArrayList<FromDefinition>();
    private List<ProcessorDefinition> outputs = new ArrayList<ProcessorDefinition>();
    private String group;
    private CamelContext camelContext;

    public RouteDefinition() {
    }

    public RouteDefinition(String uri) {
        this.from(uri);
    }

    public RouteDefinition(Endpoint endpoint) {
        this.from(endpoint);
    }

    public String toString() {
        return "Route[" + this.inputs + " -> " + this.outputs + "]";
    }

    @Override
    public String getShortName() {
        return "route";
    }

    public ServiceStatus getStatus() {
        if (this.camelContext != null) {
            ServiceStatus answer = this.camelContext.getRouteStatus(this);
            if (answer == null) {
                answer = ServiceStatus.Stopped;
            }
            return answer;
        }
        return null;
    }

    public boolean isStartable() {
        ServiceStatus status = this.getStatus();
        if (status == null) {
            return true;
        }
        return status.isStartable();
    }

    public boolean isStoppable() {
        ServiceStatus status = this.getStatus();
        if (status == null) {
            return false;
        }
        return status.isStoppable();
    }

    public List<RouteContext> addRoutes(CamelContext context, Collection<Route> routes) throws Exception {
        ArrayList<RouteContext> answer = new ArrayList<RouteContext>();
        this.setCamelContext(context);
        ErrorHandlerBuilder handler = context.getErrorHandlerBuilder();
        if (handler != null) {
            this.setErrorHandlerBuilderIfNull(handler);
        }
        for (FromDefinition fromType : this.inputs) {
            RouteContext routeContext = this.addRoutes(routes, fromType);
            answer.add(routeContext);
        }
        return answer;
    }

    public Endpoint resolveEndpoint(String uri) throws NoSuchEndpointException {
        CamelContext context = this.getCamelContext();
        if (context == null) {
            throw new IllegalArgumentException("CamelContext has not been injected!");
        }
        return CamelContextHelper.getMandatoryEndpoint(context, uri);
    }

    public RouteDefinition from(String uri) {
        this.getInputs().add(new FromDefinition(uri));
        return this;
    }

    public RouteDefinition from(Endpoint endpoint) {
        this.getInputs().add(new FromDefinition(endpoint));
        return this;
    }

    public RouteDefinition from(String ... uris) {
        for (String uri : uris) {
            this.getInputs().add(new FromDefinition(uri));
        }
        return this;
    }

    public RouteDefinition from(Endpoint ... endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.getInputs().add(new FromDefinition(endpoint));
        }
        return this;
    }

    public RouteDefinition group(String name) {
        this.setGroup(name);
        return this;
    }

    public List<FromDefinition> getInputs() {
        return this.inputs;
    }

    @XmlElementRef
    public void setInputs(List<FromDefinition> inputs) {
        this.inputs = inputs;
    }

    @Override
    public List<ProcessorDefinition> getOutputs() {
        return this.outputs;
    }

    @XmlElementRef
    public void setOutputs(List<ProcessorDefinition> outputs) {
        this.outputs = outputs;
        if (outputs != null) {
            for (ProcessorDefinition output : outputs) {
                this.configureChild(output);
            }
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    @XmlTransient
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getGroup() {
        return this.group;
    }

    @XmlAttribute
    public void setGroup(String group) {
        this.group = group;
    }

    protected RouteContext addRoutes(Collection<Route> routes, FromDefinition fromType) throws Exception {
        DefaultRouteContext routeContext = new DefaultRouteContext(this, fromType, routes);
        routeContext.getEndpoint();
        if (this.camelContext != null) {
            this.camelContext.getLifecycleStrategy().onRouteContextCreate(routeContext);
        }
        ArrayList<ProcessorDefinition> list = new ArrayList<ProcessorDefinition>(this.outputs);
        for (ProcessorDefinition output : list) {
            output.addRoutes(routeContext, routes);
        }
        routeContext.commit();
        return routeContext;
    }

    @Override
    protected void configureChild(ProcessorDefinition output) {
        super.configureChild(output);
    }
}

