/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.TraceInterceptor;
import org.apache.camel.spi.TraceableUnitOfWork;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.util.MessageHelper;

public class DefaultTraceFormatter
implements TraceFormatter {
    private int breadCrumbLength;
    private int nodeLength;
    private boolean showBreadCrumb = true;
    private boolean showNode = true;
    private boolean showExchangeId;
    private boolean showShortExchangeId;
    private boolean showExchangePattern = true;
    private boolean showProperties = true;
    private boolean showHeaders = true;
    private boolean showBody = true;
    private boolean showBodyType = true;
    private boolean showOutHeaders;
    private boolean showOutBody;
    private boolean showOutBodyType;
    private boolean showException = true;
    private int maxChars;

    public Object format(TraceInterceptor interceptor, ProcessorDefinition node, Exchange exchange) {
        Message in = exchange.getIn();
        Message out = null;
        if (exchange.hasOut()) {
            out = exchange.getOut();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.extractBreadCrumb(interceptor, node, exchange));
        if (this.showExchangePattern) {
            sb.append(", Pattern:").append((Object)exchange.getPattern());
        }
        if (this.showProperties && !exchange.getProperties().isEmpty()) {
            sb.append(", Properties:").append(exchange.getProperties());
        }
        if (this.showHeaders && !in.getHeaders().isEmpty()) {
            sb.append(", Headers:").append(in.getHeaders());
        }
        if (this.showBodyType) {
            sb.append(", BodyType:").append(MessageHelper.getBodyTypeName(in));
        }
        if (this.showBody) {
            sb.append(", Body:").append(MessageHelper.extractBodyAsString(in));
        }
        if (this.showOutHeaders && out != null) {
            sb.append(", OutHeaders:").append(out.getHeaders());
        }
        if (this.showOutBodyType && out != null) {
            sb.append(", OutBodyType:").append(MessageHelper.getBodyTypeName(out));
        }
        if (this.showOutBody && out != null) {
            sb.append(", OutBody:").append(MessageHelper.extractBodyAsString(out));
        }
        if (this.showException && exchange.getException() != null) {
            sb.append(", Exception:").append(exchange.getException());
        }
        if (this.maxChars > 0) {
            String s = sb.toString();
            if (s.length() > this.maxChars) {
                s = s.substring(0, this.maxChars) + "...";
            }
            return s;
        }
        return sb.toString();
    }

    public boolean isShowBody() {
        return this.showBody;
    }

    public void setShowBody(boolean showBody) {
        this.showBody = showBody;
    }

    public boolean isShowBodyType() {
        return this.showBodyType;
    }

    public void setShowBodyType(boolean showBodyType) {
        this.showBodyType = showBodyType;
    }

    public void setShowOutBody(boolean showOutBody) {
        this.showOutBody = showOutBody;
    }

    public boolean isShowOutBody() {
        return this.showOutBody;
    }

    public void setShowOutBodyType(boolean showOutBodyType) {
        this.showOutBodyType = showOutBodyType;
    }

    public boolean isShowOutBodyType() {
        return this.showOutBodyType;
    }

    public boolean isShowBreadCrumb() {
        return this.showBreadCrumb;
    }

    public void setShowBreadCrumb(boolean showBreadCrumb) {
        this.showBreadCrumb = showBreadCrumb;
    }

    public boolean isShowExchangeId() {
        return this.showExchangeId;
    }

    public void setShowExchangeId(boolean showExchangeId) {
        this.showExchangeId = showExchangeId;
    }

    public boolean isShowHeaders() {
        return this.showHeaders;
    }

    public void setShowHeaders(boolean showHeaders) {
        this.showHeaders = showHeaders;
    }

    public boolean isShowOutHeaders() {
        return this.showOutHeaders;
    }

    public void setShowOutHeaders(boolean showOutHeaders) {
        this.showOutHeaders = showOutHeaders;
    }

    public boolean isShowProperties() {
        return this.showProperties;
    }

    public void setShowProperties(boolean showProperties) {
        this.showProperties = showProperties;
    }

    public boolean isShowNode() {
        return this.showNode;
    }

    public void setShowNode(boolean showNode) {
        this.showNode = showNode;
    }

    public boolean isShowExchangePattern() {
        return this.showExchangePattern;
    }

    public void setShowExchangePattern(boolean showExchangePattern) {
        this.showExchangePattern = showExchangePattern;
    }

    public boolean isShowException() {
        return this.showException;
    }

    public void setShowException(boolean showException) {
        this.showException = showException;
    }

    public int getBreadCrumbLength() {
        return this.breadCrumbLength;
    }

    public void setBreadCrumbLength(int breadCrumbLength) {
        this.breadCrumbLength = breadCrumbLength;
    }

    public boolean isShowShortExchangeId() {
        return this.showShortExchangeId;
    }

    public void setShowShortExchangeId(boolean showShortExchangeId) {
        this.showShortExchangeId = showShortExchangeId;
    }

    public int getNodeLength() {
        return this.nodeLength;
    }

    public void setNodeLength(int nodeLength) {
        this.nodeLength = nodeLength;
    }

    public int getMaxChars() {
        return this.maxChars;
    }

    public void setMaxChars(int maxChars) {
        this.maxChars = maxChars;
    }

    protected Object getBreadCrumbID(Exchange exchange) {
        UnitOfWork unitOfWork = exchange.getUnitOfWork();
        if (unitOfWork != null) {
            return unitOfWork.getId();
        }
        return exchange.getExchangeId();
    }

    protected String getNodeMessage(ProcessorDefinition node) {
        String message = node.getShortName() + "(" + node.getLabel() + ")";
        if (this.nodeLength > 0) {
            return String.format("%1$-" + this.nodeLength + "." + this.nodeLength + "s", message);
        }
        return message;
    }

    protected String extractBreadCrumb(TraceInterceptor interceptor, ProcessorDefinition currentNode, Exchange exchange) {
        String result;
        String id = "";
        if (!(this.showBreadCrumb || this.showExchangeId || this.showShortExchangeId || this.showNode)) {
            return "";
        }
        if (this.showBreadCrumb) {
            id = this.getBreadCrumbID(exchange).toString();
        } else if (this.showExchangeId || this.showShortExchangeId) {
            id = this.getBreadCrumbID(exchange).toString();
            if (this.showShortExchangeId) {
                id = id.substring(id.indexOf("/") + 1);
            }
        }
        String from = "";
        if (this.showNode && exchange.getUnitOfWork() instanceof TraceableUnitOfWork) {
            TraceableUnitOfWork tuow = (TraceableUnitOfWork)exchange.getUnitOfWork();
            ProcessorDefinition prev = tuow.getLastInterceptedNode();
            if (prev != null) {
                from = this.getNodeMessage(prev);
            } else if (exchange.getFromEndpoint() != null) {
                from = exchange.getFromEndpoint().getEndpointUri();
            }
        }
        String to = "";
        if (this.showNode) {
            to = this.getNodeMessage(currentNode);
        }
        if (this.showNode) {
            result = id.trim() + " >>> " + from + " --> " + to.trim();
            if (interceptor.shouldTraceOutExchanges() && exchange.hasOut()) {
                result = result + " (OUT) ";
            }
        } else {
            result = id;
        }
        if (this.breadCrumbLength > 0) {
            return String.format("%1$-" + this.breadCrumbLength + "." + this.breadCrumbLength + "s", result.trim());
        }
        return result.trim();
    }
}

