/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtil {
    private static final int RETRY_SLEEP_MILLIS = 10;
    private static File defaultTempDir;

    private FileUtil() {
    }

    public static String normalizePath(String path) {
        if (path != null && System.getProperty("os.name").startsWith("Windows") && path.indexOf("/") >= 0) {
            return path.replace('/', '\\');
        }
        return path;
    }

    private static synchronized File getDefaultTempDir() {
        if (defaultTempDir != null && defaultTempDir.exists()) {
            return defaultTempDir;
        }
        String s = null;
        try {
            s = System.getProperty(FileUtil.class.getName() + ".TempDirectory");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (s == null) {
            int x = (int)(Math.random() * 1000000.0);
            s = System.getProperty("java.io.tmpdir");
            File checkExists = new File(s);
            if (!checkExists.exists()) {
                throw new RuntimeException("The directory " + checkExists.getAbsolutePath() + " does not exist, please set java.io.tempdir" + " to an existing directory");
            }
            File f = new File(s, "camel-tmp-" + x);
            while (!f.mkdir()) {
                x = (int)(Math.random() * 1000000.0);
                f = new File(s, "camel-tmp-" + x);
            }
            defaultTempDir = f;
            Thread hook = new Thread(){

                public void run() {
                    FileUtil.removeDir(defaultTempDir);
                }
            };
            Runtime.getRuntime().addShutdownHook(hook);
        } else {
            File f = new File(s);
            f.mkdirs();
            defaultTempDir = f;
        }
        return defaultTempDir;
    }

    public static void mkDir(File dir) {
        boolean result;
        if (dir == null) {
            throw new RuntimeException("dir attribute is required");
        }
        if (dir.isFile()) {
            throw new RuntimeException("Unable to create directory as a file already exists with that name: " + dir.getAbsolutePath());
        }
        if (!dir.exists() && !(result = FileUtil.doMkDirs(dir))) {
            String msg = "Directory " + dir.getAbsolutePath() + " creation was not successful for an unknown reason";
            throw new RuntimeException(msg);
        }
    }

    private static boolean doMkDirs(File f) {
        if (!f.mkdirs()) {
            try {
                Thread.sleep(10L);
                return f.mkdirs();
            }
            catch (InterruptedException ex) {
                return f.mkdirs();
            }
        }
        return true;
    }

    public static void removeDir(File d) {
        String[] list = d.list();
        if (list == null) {
            list = new String[]{};
        }
        for (int i = 0; i < list.length; ++i) {
            String s = list[i];
            File f = new File(d, s);
            if (f.isDirectory()) {
                FileUtil.removeDir(f);
                continue;
            }
            FileUtil.delete(f);
        }
        FileUtil.delete(d);
    }

    public static void delete(File f) {
        if (!f.delete()) {
            if (FileUtil.isWindows()) {
                System.gc();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!f.delete()) {
                f.deleteOnExit();
            }
        }
    }

    private static boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.indexOf("windows") > -1;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return FileUtil.createTempFile(prefix, suffix, null, false);
    }

    public static File createTempFile(String prefix, String suffix, File parentDir, boolean deleteOnExit) throws IOException {
        File parent;
        File result = null;
        File file = parent = parentDir == null ? FileUtil.getDefaultTempDir() : parentDir;
        if (suffix == null) {
            suffix = ".tmp";
        }
        if (prefix == null) {
            prefix = "camel";
        } else if (prefix.length() < 3) {
            prefix = prefix + "camel";
        }
        result = File.createTempFile(prefix, suffix, parent);
        if (deleteOnExit && parentDir != null) {
            result.deleteOnExit();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromFile(File location) {
        FileInputStream is = null;
        String result = null;
        try {
            is = new FileInputStream(location);
            result = FileUtil.normalizeCRLF(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public static String normalizeCRLF(InputStream instream) {
        BufferedReader in = new BufferedReader(new InputStreamReader(instream));
        StringBuffer result = new StringBuffer();
        String line = null;
        try {
            line = in.readLine();
            while (line != null) {
                String[] tok = line.split("\\s");
                for (int x = 0; x < tok.length; ++x) {
                    String token = tok[x];
                    result.append("  " + token);
                }
                line = in.readLine();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String rtn = result.toString();
        rtn = FileUtil.ignoreTokens(rtn, "<!--", "-->");
        rtn = FileUtil.ignoreTokens(rtn, "/*", "*/");
        return rtn;
    }

    private static String ignoreTokens(String contents, String startToken, String endToken) {
        String rtn = contents;
        int headerIndexStart = rtn.indexOf(startToken);
        int headerIndexEnd = rtn.indexOf(endToken);
        if (headerIndexStart != -1 && headerIndexEnd != -1 && headerIndexStart < headerIndexEnd) {
            rtn = rtn.substring(0, headerIndexStart - 1) + rtn.substring(headerIndexEnd + endToken.length() + 1);
        }
        return rtn;
    }

    public static List<File> getFiles(File dir, String pattern) {
        return FileUtil.getFiles(dir, pattern, null);
    }

    public static List<File> getFilesRecurse(File dir, String pattern) {
        return FileUtil.getFilesRecurse(dir, pattern, null);
    }

    public static List<File> getFiles(File dir, String pattern, File exclude) {
        return FileUtil.getFilesRecurse(dir, Pattern.compile(pattern), exclude, false, new ArrayList<File>());
    }

    public static List<File> getFilesRecurse(File dir, String pattern, File exclude) {
        return FileUtil.getFilesRecurse(dir, Pattern.compile(pattern), exclude, true, new ArrayList<File>());
    }

    private static List<File> getFilesRecurse(File dir, Pattern pattern, File exclude, boolean rec, List<File> fileList) {
        for (File file : dir.listFiles()) {
            if (file.equals(exclude)) continue;
            if (file.isDirectory() && rec) {
                FileUtil.getFilesRecurse(file, pattern, exclude, rec, fileList);
                continue;
            }
            Matcher m = pattern.matcher(file.getName());
            if (!m.matches()) continue;
            fileList.add(file);
        }
        return fileList;
    }

    public static List<String> readLines(File file) throws Exception {
        if (!file.exists()) {
            return new ArrayList<String>();
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        ArrayList<String> results = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            results.add(line);
            line = reader.readLine();
        }
        return results;
    }

    public static String stripLeadingSeparator(String name) {
        if (name == null) {
            return null;
        }
        while (name.startsWith("/") || name.startsWith(File.separator)) {
            name = name.substring(1);
        }
        return name;
    }

    public static String stripTrailingSeparator(String name) {
        if (name == null) {
            return null;
        }
        while (name.endsWith("/") || name.endsWith(File.separator)) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    public static String stripPath(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.lastIndexOf("/");
        if (pos == -1) {
            pos = name.lastIndexOf(File.separator);
        }
        if (pos != -1) {
            return name.substring(pos + 1);
        }
        return name;
    }

    public static String onlyPath(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.lastIndexOf("/");
        if (pos == -1) {
            pos = name.lastIndexOf(File.separator);
        }
        if (pos != -1) {
            return name.substring(0, pos);
        }
        return null;
    }

    public static String compactPath(String path) {
        String[] parts;
        if (path.indexOf("..") == -1) {
            return path;
        }
        Stack<String> stack = new Stack<String>();
        for (String part : parts = path.split(File.separator)) {
            if (part.equals("..") && !stack.isEmpty()) {
                stack.pop();
                continue;
            }
            stack.push(part);
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = stack.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(File.separator);
        }
        return sb.toString();
    }
}

